/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.UdfFunction;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Verify;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class JavaCallFunction
extends BuiltInFunction<Value> {
    public JavaCallFunction() {
        super("java_call", List.of(Type.primitiveType(Type.TypeCode.STRING)), new Type.Any(), JavaCallFunction::findFunction);
    }

    @Nonnull
    private static Value findFunction(@Nonnull BuiltInFunction<Value> ignored, List<? extends Typed> arguments) {
        Class<?> clazz;
        Verify.verify(!arguments.isEmpty());
        Verify.verify(arguments.get(0).getResultType().getTypeCode().equals((Object)Type.TypeCode.STRING));
        Verify.verify(arguments.get(0) instanceof LiteralValue);
        LiteralValue literalValue = (LiteralValue)arguments.get(0);
        String functionName = (String)literalValue.evalWithoutStore(EvaluationContext.empty());
        try {
            clazz = Class.forName(functionName);
        }
        catch (ClassNotFoundException e) {
            throw new RecordCoreException("could not find function", e).addLogInfo(new Object[]{LogMessageKeys.FUNCTION, functionName});
        }
        if (!UdfFunction.class.isAssignableFrom(clazz)) {
            throw new RecordCoreException("expecting class to be a subclass of '" + UdfFunction.class.getSimpleName() + "'", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, UdfFunction.class.getSimpleName()}).addLogInfo(new Object[]{LogMessageKeys.ACTUAL, clazz.getName()});
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (Value)((UdfFunction)constructor.newInstance(new Object[0])).encapsulate(arguments.stream().skip(1L).collect(Collectors.toUnmodifiableList()));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RecordCoreException("could not instantiate call-site from '" + clazz.getName() + "'", e);
        }
    }
}

