/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PLikeOperatorValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BooleanValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class LikeOperatorValue
extends AbstractValue
implements BooleanValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Like-Operator-Value");
    @Nonnull
    private final Value srcChild;
    @Nonnull
    private final Value patternChild;

    public LikeOperatorValue(@Nonnull Value srcChild, @Nonnull Value patternChild) {
        this.srcChild = srcChild;
        this.patternChild = patternChild;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        String lhs = (String)this.srcChild.eval(store, context);
        String rhs = (String)this.patternChild.eval(store, context);
        return LikeOperatorValue.likeOperation(lhs, rhs);
    }

    @Nullable
    public static Boolean likeOperation(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(rhs);
        return pattern.matcher(lhs).find();
    }

    @Override
    public Optional<QueryPredicate> toQueryPredicate(@Nullable TypeRepository typeRepository, @Nonnull Set<CorrelationIdentifier> localAliases) {
        return Optional.of(new ValuePredicate(this.srcChild, new Comparisons.ValueComparison(Comparisons.Type.LIKE, this.patternChild)));
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.srcChild, this.patternChild);
    }

    @Override
    @Nonnull
    public LikeOperatorValue withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(Iterables.size(newChildren) == 2);
        return new LikeOperatorValue(Iterables.get(newChildren, 0), Iterables.get(newChildren, 1));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.srcChild, this.patternChild);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokensWithPrecedence src = Iterables.get(explainSuppliers, 0).get();
        ExplainTokensWithPrecedence pattern = Iterables.get(explainSuppliers, 1).get();
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.BETWEEN, ExplainTokensWithPrecedence.Precedence.BETWEEN.parenthesizeChild(src, true).addWhitespace().addKeyword("LIKE").addWhitespace().addNested(ExplainTokensWithPrecedence.Precedence.BETWEEN.parenthesizeChild(pattern)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PLikeOperatorValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PLikeOperatorValue.newBuilder().setSrcChild(this.srcChild.toValueProto(serializationContext)).setPatternChild(this.patternChild.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setLikeOperatorValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static LikeOperatorValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLikeOperatorValue likeOperatorValueProto) {
        return new LikeOperatorValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(likeOperatorValueProto.getSrcChild())), Value.fromValueProto(serializationContext, Objects.requireNonNull(likeOperatorValueProto.getPatternChild())));
    }

    @Nonnull
    private static Value encapsulate(@Nonnull List<? extends Typed> arguments) {
        Verify.verify(arguments.size() == 2);
        Type srcType = arguments.get(0).getResultType();
        Type patternType = arguments.get(1).getResultType();
        SemanticException.check(srcType.getTypeCode().equals((Object)Type.TypeCode.STRING), SemanticException.ErrorCode.OPERAND_OF_LIKE_OPERATOR_IS_NOT_STRING);
        SemanticException.check(patternType.getTypeCode().equals((Object)Type.TypeCode.STRING), SemanticException.ErrorCode.OPERAND_OF_LIKE_OPERATOR_IS_NOT_STRING);
        return new LikeOperatorValue((Value)arguments.get(0), (Value)arguments.get(1));
    }

    public static class Deserializer
    implements PlanDeserializer<PLikeOperatorValue, LikeOperatorValue> {
        @Override
        @Nonnull
        public Class<PLikeOperatorValue> getProtoMessageClass() {
            return PLikeOperatorValue.class;
        }

        @Override
        @Nonnull
        public LikeOperatorValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLikeOperatorValue likeOperatorValueProto) {
            return LikeOperatorValue.fromProto(serializationContext, likeOperatorValueProto);
        }
    }

    public static class LikeFn
    extends BuiltInFunction<Value> {
        public LikeFn() {
            super("like", ImmutableList.of(Type.primitiveType(Type.TypeCode.STRING), Type.primitiveType(Type.TypeCode.STRING)), (BuiltInFunction<T> ignored, List<Typed> args) -> LikeOperatorValue.encapsulate(args));
        }
    }
}

