/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PLiteralValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class LiteralValue<T>
extends AbstractValue
implements LeafValue,
Value.RangeMatchableValue,
PlanSerializable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Literal-Value");
    @Nonnull
    private final Type resultType;
    @Nullable
    private final T value;

    @VisibleForTesting
    public LiteralValue(@Nullable T value) {
        this(Type.fromObject(value), value);
    }

    @VisibleForTesting
    public LiteralValue(@Nonnull Type resultType, @Nullable T value) {
        this.resultType = resultType;
        this.value = value;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.value;
    }

    @Nullable
    public T getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean canResultInType(@Nonnull Type type) {
        return type.isNullable() && this.resultType.equals(type.nullable());
    }

    @Override
    @Nonnull
    public LiteralValue<T> with(@Nonnull Type type) {
        if (this.getResultType().equals(type)) {
            return this;
        }
        Verify.verify(this.canResultInType(type));
        return new LiteralValue<T>(type, this.value);
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return false;
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return LeafValue.super.equalsWithoutChildren(other).filter(ignored -> {
            LiteralValue that = (LiteralValue)other;
            if (this.value == null && that.value == null) {
                return true;
            }
            return Boolean.TRUE.equals(Comparisons.evalComparison(Comparisons.Type.EQUALS, this.value, that.value));
        });
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(this.value);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.value);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public PLiteralValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PLiteralValue.Builder builder = PLiteralValue.newBuilder();
        builder.setValue(PlanSerialization.valueObjectToProto(this.value));
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        PLiteralValue specificValueProto = this.toProto(serializationContext);
        return PValue.newBuilder().setLiteralValue(specificValueProto).build();
    }

    @Nonnull
    public static <T> LiteralValue<T> fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLiteralValue literalValueProto) {
        return new LiteralValue<Object>(Type.fromTypeProto(serializationContext, literalValueProto.getResultType()), PlanSerialization.protoToValueObject(literalValueProto.getValue()));
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addToString(LiteralValue.formatLiteral(this.resultType, Comparisons.toPrintable(this.value))));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Nonnull
    public static String formatLiteral(@Nonnull Type type, @Nonnull String literal) {
        Object comparandString;
        if (type.isPrimitive()) {
            switch (type.getTypeCode()) {
                case INT: {
                    comparandString = literal;
                    break;
                }
                case LONG: {
                    comparandString = literal + "l";
                    break;
                }
                case FLOAT: {
                    comparandString = literal + "f";
                    break;
                }
                case DOUBLE: {
                    comparandString = literal + "d";
                    break;
                }
                default: {
                    comparandString = "'" + literal + "'";
                    break;
                }
            }
        } else {
            comparandString = literal;
        }
        return comparandString;
    }

    public static <T> LiteralValue<T> ofScalar(T value) {
        LiteralValue<T> result = new LiteralValue<T>(Type.fromObject(value), value);
        Verify.verify(result.resultType.isPrimitive());
        return result;
    }

    public static <T> LiteralValue<List<T>> ofList(@Nonnull List<T> listValue) {
        Type resolvedElementType = null;
        for (T elementValue : listValue) {
            Type currentType = Type.primitiveType(Type.typeCodeFromPrimitive(elementValue));
            if (resolvedElementType == null) {
                resolvedElementType = currentType;
                continue;
            }
            if (currentType.equals(resolvedElementType)) continue;
            resolvedElementType = new Type.Any();
            break;
        }
        resolvedElementType = resolvedElementType == null ? new Type.Any() : resolvedElementType;
        return new LiteralValue<List<T>>(new Type.Array(resolvedElementType), listValue);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    public static class Deserializer<T>
    implements PlanDeserializer<PLiteralValue, LiteralValue<T>> {
        @Override
        @Nonnull
        public Class<PLiteralValue> getProtoMessageClass() {
            return PLiteralValue.class;
        }

        @Override
        @Nonnull
        public LiteralValue<T> fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLiteralValue literalValueProto) {
            return LiteralValue.fromProto(serializationContext, literalValueProto);
        }
    }
}

