/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.TupleFieldsHelper;
import com.apple.foundationdb.record.planprotos.PCoercionBiFunction;
import com.apple.foundationdb.record.planprotos.PCoercionTrieNode;
import com.apple.foundationdb.record.planprotos.PTransformationTrieNode;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.NullableArrayTypeUtils;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.TrieNode;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.ImmutableIntArray;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MessageHelpers {
    private MessageHelpers() {
    }

    @Nullable
    public static Object getFieldValueForFieldNames(@Nonnull MessageOrBuilder message, @Nonnull List<String> fieldNames) {
        if (fieldNames.isEmpty()) {
            throw new RecordCoreException("empty list of field names", new Object[0]);
        }
        MessageOrBuilder current = message;
        for (int fieldNamesIndex = 0; fieldNamesIndex < fieldNames.size() - 1; ++fieldNamesIndex) {
            if ((current = MessageHelpers.getFieldMessageOnMessage(current, fieldNames.get(fieldNamesIndex))) != null) continue;
            return null;
        }
        return MessageHelpers.getFieldOnMessage(current, fieldNames.get(fieldNames.size() - 1));
    }

    @Nullable
    public static Object getFieldValueForFieldOrdinals(@Nonnull MessageOrBuilder message, @Nonnull ImmutableIntArray fieldOrdinals) {
        if (fieldOrdinals.isEmpty()) {
            throw new RecordCoreException("empty list of fields", new Object[0]);
        }
        MessageOrBuilder current = message;
        for (int fieldOrdinal = 0; fieldOrdinal < fieldOrdinals.length() - 1; ++fieldOrdinal) {
            if ((current = MessageHelpers.getFieldMessageOnMessageByOrdinal(current, fieldOrdinals.get(fieldOrdinal))) != null) continue;
            return null;
        }
        return MessageHelpers.getFieldOnMessageByOrdinal(current, fieldOrdinals.get(fieldOrdinals.length() - 1));
    }

    @Nullable
    public static Object getFieldOnMessage(@Nonnull MessageOrBuilder message, @Nonnull String fieldName) {
        Descriptors.FieldDescriptor field = MessageHelpers.findFieldDescriptorOnMessage(message, fieldName);
        return MessageHelpers.getFieldOnMessage(message, field);
    }

    @Nullable
    public static Object getFieldOnMessage(@Nonnull MessageOrBuilder message, @Nonnull Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            int count = message.getRepeatedFieldCount(field);
            ArrayList<Object> list = new ArrayList<Object>(count);
            for (int i = 0; i < count; ++i) {
                list.add(message.getRepeatedField(field, i));
            }
            return list;
        }
        if (field.hasDefaultValue() || message.hasField(field)) {
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && TupleFieldsHelper.isTupleField(field.getMessageType())) {
                return TupleFieldsHelper.fromProto((Message)message.getField(field), field.getMessageType());
            }
            return message.getField(field);
        }
        return null;
    }

    @Nullable
    public static Object getFieldOnMessageByOrdinal(@Nonnull MessageOrBuilder message, int fieldOrdinal) {
        Descriptors.FieldDescriptor field = MessageHelpers.findFieldDescriptorOnMessageByOrdinal(message, fieldOrdinal);
        return MessageHelpers.getFieldOnMessage(message, field);
    }

    @Nonnull
    public static Descriptors.FieldDescriptor findFieldDescriptorOnMessage(@Nonnull MessageOrBuilder message, @Nonnull String fieldName) {
        Descriptors.FieldDescriptor field = message.getDescriptorForType().findFieldByName(fieldName);
        if (field == null) {
            throw new Query.InvalidExpressionException("Missing field " + fieldName);
        }
        return field;
    }

    @Nonnull
    public static Descriptors.FieldDescriptor findFieldDescriptorOnMessage(@Nonnull MessageOrBuilder message, int fieldNumber) {
        Descriptors.FieldDescriptor field = message.getDescriptorForType().findFieldByNumber(fieldNumber);
        if (field == null) {
            throw new Query.InvalidExpressionException("Missing field " + fieldNumber);
        }
        return field;
    }

    @Nonnull
    public static Descriptors.FieldDescriptor findFieldDescriptorOnMessageByOrdinal(@Nonnull MessageOrBuilder message, int fieldOrdinal) {
        if (fieldOrdinal < 0 || fieldOrdinal >= message.getDescriptorForType().getFields().size()) {
            throw new Query.InvalidExpressionException("Missing field (#ord=" + fieldOrdinal + ")");
        }
        return message.getDescriptorForType().getFields().get(fieldOrdinal);
    }

    public static boolean compareMessageEquals(@Nonnull Object o1, @Nonnull Object o2) {
        if (!(o1 instanceof Message) || !(o2 instanceof Message)) {
            return false;
        }
        MessageOrBuilder m1 = (MessageOrBuilder)o1;
        MessageOrBuilder m22 = (MessageOrBuilder)o2;
        if (m1.getDescriptorForType() == m22.getDescriptorForType()) {
            return m1.equals(m22);
        }
        if (m1.getDescriptorForType().getFields().size() != m22.getDescriptorForType().getFields().size()) {
            return false;
        }
        for (int i = 1; i <= m1.getDescriptorForType().getFields().size(); ++i) {
            Descriptors.FieldDescriptor f1 = MessageHelpers.findFieldDescriptorOnMessage(m1, i);
            Descriptors.FieldDescriptor f2 = MessageHelpers.findFieldDescriptorOnMessage(m22, i);
            Verify.verify(!f1.isRepeated() && !f1.isMapField() && f1.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE);
            Verify.verify(!f2.isRepeated() && !f2.isMapField() && f2.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE);
            if (f1.getJavaType() == f2.getJavaType() && m1.getField(f1).equals(m22.getField(f2))) {
                if (m1.getField(f1).equals(m22.getField(f2))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static Message getFieldMessageOnMessage(@Nonnull MessageOrBuilder message, @Nonnull String fieldName) {
        Descriptors.FieldDescriptor field = MessageHelpers.findFieldDescriptorOnMessage(message, fieldName);
        return MessageHelpers.getFieldMessageOnMessage(message, field);
    }

    @Nullable
    private static Message getFieldMessageOnMessage(@Nonnull MessageOrBuilder message, Descriptors.FieldDescriptor field) {
        if (!field.isRepeated() && (field.hasDefaultValue() || message.hasField(field)) && field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return (Message)message.getField(field);
        }
        return null;
    }

    @Nullable
    private static Message getFieldMessageOnMessageByOrdinal(@Nonnull MessageOrBuilder message, int fieldOrdinal) {
        Descriptors.FieldDescriptor field = MessageHelpers.findFieldDescriptorOnMessageByOrdinal(message, fieldOrdinal);
        return MessageHelpers.getFieldMessageOnMessage(message, field);
    }

    @Nonnull
    public static Message deepCopyMessageIfNeeded(@Nonnull Descriptors.Descriptor targetDescriptor, @Nonnull Message message) {
        if (targetDescriptor == message.getDescriptorForType()) {
            return message;
        }
        DynamicMessage.Builder builder = DynamicMessage.newBuilder(targetDescriptor);
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            Descriptors.FieldDescriptor targetField = targetDescriptor.findFieldByNumber(field.getNumber());
            if (field.isRepeated()) {
                for (Object element : (List)entry.getValue()) {
                    if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        builder.addRepeatedField(targetField, MessageHelpers.deepCopyMessageIfNeeded(targetField.getMessageType(), (Message)element));
                        continue;
                    }
                    if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                        String enumValue = ((Descriptors.EnumValueDescriptor)element).getName();
                        builder.addRepeatedField(targetField, targetField.getEnumType().findValueByName(enumValue));
                        continue;
                    }
                    builder.addRepeatedField(targetField, element);
                }
                continue;
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                Message existingValue = (Message)builder.getField(targetField);
                if (existingValue == existingValue.getDefaultInstanceForType()) {
                    builder.setField(field, entry.getValue());
                    continue;
                }
                DynamicMessage mergedObject = DynamicMessage.newBuilder(targetField.getMessageType()).mergeFrom(MessageHelpers.deepCopyMessageIfNeeded(targetField.getMessageType(), existingValue)).mergeFrom(MessageHelpers.deepCopyMessageIfNeeded(targetField.getMessageType(), (Message)entry.getValue())).build();
                builder.setField(targetField, mergedObject);
                continue;
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                String enumValue = ((Descriptors.EnumValueDescriptor)entry.getValue()).getName();
                builder.setField(targetField, targetField.getEnumType().findValueByName(enumValue));
                continue;
            }
            builder.setField(targetField, entry.getValue());
        }
        builder.mergeUnknownFields(message.getUnknownFields());
        return builder.build();
    }

    @Nonnull
    public static <M extends Message> Object transformMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable TransformationTrieNode transformationsTrie, @Nullable CoercionTrieNode coercionsTrie, @Nonnull Type targetType, @Nonnull Descriptors.Descriptor targetDescriptor, @Nonnull Type currentType, @Nonnull Descriptors.Descriptor currentDescriptor, @Nullable Object current) {
        Value value = transformationsTrie == null ? null : (Value)transformationsTrie.getValue();
        Verify.verify(value == null);
        List<Descriptors.FieldDescriptor> targetDescriptorFields = targetDescriptor.getFields();
        Type.Record targetRecordType = (Type.Record)targetType;
        Type.Record currentRecordType = (Type.Record)currentType;
        Map transformationsChildrenMap = transformationsTrie == null ? null : transformationsTrie.getChildrenMap();
        Map coercionsChildrenMap = coercionsTrie == null ? null : coercionsTrie.getChildrenMap();
        Message currentMessage = (Message)current;
        DynamicMessage.Builder resultMessageBuilder = DynamicMessage.newBuilder(targetDescriptor);
        for (Descriptors.FieldDescriptor messageFieldDescriptor : currentDescriptor.getFields()) {
            Object fieldResult;
            Type currentFieldType;
            int index = messageFieldDescriptor.getIndex();
            TransformationTrieNode transformationTrieForField = transformationsChildrenMap == null ? null : (TransformationTrieNode)transformationsChildrenMap.get(index);
            Descriptors.FieldDescriptor targetFieldDescriptor = targetDescriptorFields.get(index);
            Descriptors.Descriptor targetDescriptorForField = targetFieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? targetFieldDescriptor.getMessageType() : (targetFieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM ? targetFieldDescriptor.getEnumType() : null);
            CoercionTrieNode promotionTrieForField = coercionsChildrenMap == null ? null : (CoercionTrieNode)coercionsChildrenMap.get(index);
            Type targetFieldType = targetRecordType.getField(index).getFieldType();
            if (transformationTrieForField != null) {
                currentFieldType = currentRecordType.getField(index).getFieldType();
                if (transformationTrieForField.getValue() == null) {
                    Verify.verify(targetDescriptorForField instanceof Descriptors.Descriptor);
                    fieldResult = MessageHelpers.transformMessage(store, context, transformationTrieForField, promotionTrieForField, targetFieldType, targetDescriptorForField, currentFieldType, Verify.verifyNotNull(messageFieldDescriptor.getMessageType()), currentMessage == null ? null : currentMessage.getField(messageFieldDescriptor));
                } else {
                    Value transformationValue = (Value)transformationTrieForField.getValue();
                    fieldResult = MessageHelpers.coerceObject(promotionTrieForField, targetFieldType, targetDescriptorForField, currentFieldType, transformationValue.eval(store, context));
                }
                if (fieldResult == null) continue;
                resultMessageBuilder.setField(targetFieldDescriptor, fieldResult);
                continue;
            }
            if (currentMessage == null) continue;
            currentFieldType = Verify.verifyNotNull(currentRecordType.getField(messageFieldDescriptor.getIndex())).getFieldType();
            Object object = fieldResult = messageFieldDescriptor.isRepeated() || !messageFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE) ? MessageHelpers.getFieldOnMessage((MessageOrBuilder)currentMessage, messageFieldDescriptor) : MessageHelpers.getFieldMessageOnMessage((MessageOrBuilder)currentMessage, messageFieldDescriptor);
            Object coercedObject = MessageHelpers.coerceObject(promotionTrieForField, targetFieldType, targetDescriptorForField, currentFieldType, fieldResult = NullableArrayTypeUtils.unwrapIfArray(fieldResult, currentFieldType));
            if (coercedObject == null) continue;
            resultMessageBuilder.setField(targetFieldDescriptor, coercedObject);
        }
        return resultMessageBuilder.build();
    }

    @Nullable
    public static Object coerceObject(@Nullable CoercionTrieNode coercionsTrie, @Nonnull Type targetType, @Nullable Descriptors.GenericDescriptor targetDescriptor, @Nonnull Type currentType, @Nullable Object current) {
        SemanticException.check(current != null || targetType.isNullable(), SemanticException.ErrorCode.NULL_ASSIGNMENT);
        if (current == null) {
            return null;
        }
        if (coercionsTrie == null) {
            if (targetDescriptor != null && current instanceof Message) {
                Verify.verify(targetDescriptor instanceof Descriptors.Descriptor);
                return MessageHelpers.deepCopyMessageIfNeeded((Descriptors.Descriptor)targetDescriptor, (Message)current);
            }
            return current;
        }
        if (targetType.isPrimitive()) {
            Verify.verify(currentType.isPrimitive());
            CoercionBiFunction coercionFunction = Verify.verifyNotNull((CoercionBiFunction)coercionsTrie.getValue());
            return Verify.verifyNotNull(coercionFunction.apply(null, current));
        }
        if (targetType.isUuid()) {
            CoercionBiFunction coercionFunction = Verify.verifyNotNull((CoercionBiFunction)coercionsTrie.getValue());
            return Verify.verifyNotNull(coercionFunction.apply(null, current));
        }
        if (targetType.isEnum()) {
            Verify.verify(targetDescriptor instanceof Descriptors.EnumDescriptor);
            CoercionBiFunction coercionFunction = Verify.verifyNotNull((CoercionBiFunction)coercionsTrie.getValue());
            return Verify.verifyNotNull(coercionFunction.apply(targetDescriptor, current));
        }
        if (targetType.isArray()) {
            Verify.verify(currentType.isArray());
            CoercionBiFunction coercionFunction = Verify.verifyNotNull((CoercionBiFunction)coercionsTrie.getValue());
            return Verify.verifyNotNull(coercionFunction.apply(targetDescriptor, current));
        }
        if (targetType.isRecord()) {
            Verify.verify(targetDescriptor instanceof Descriptors.Descriptor);
            return MessageHelpers.coerceMessage(coercionsTrie, targetType, Verify.verifyNotNull((Descriptors.Descriptor)targetDescriptor), currentType, (Message)current);
        }
        throw new IllegalStateException("unsupported java type for record field");
    }

    @Nonnull
    public static Object coerceArray(@Nonnull Type.Array targetArrayType, @Nonnull Type.Array currentArrayType, @Nullable Descriptors.GenericDescriptor targetDescriptor, @Nullable CoercionTrieNode elementsTrie, @Nonnull Object current) {
        Descriptors.FieldDescriptor targetElementFieldDescriptor;
        Type targetElementType = Verify.verifyNotNull(targetArrayType.getElementType());
        Type currentElementType = Verify.verifyNotNull(currentArrayType.getElementType());
        if (targetArrayType.isNullable()) {
            Verify.verify(targetDescriptor instanceof Descriptors.Descriptor);
            targetElementFieldDescriptor = Verify.verifyNotNull((Descriptors.Descriptor)targetDescriptor).findFieldByName(NullableArrayTypeUtils.getRepeatedFieldName());
        } else {
            targetElementFieldDescriptor = null;
        }
        Descriptors.Descriptor targetDescriptorForElementField = null;
        if (targetElementFieldDescriptor != null) {
            targetDescriptorForElementField = targetElementFieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? targetElementFieldDescriptor.getMessageType() : null;
        }
        List currentObjects = (List)current;
        ImmutableList.Builder coercedObjectsBuilder = ImmutableList.builder();
        for (Object currentObject : currentObjects) {
            SemanticException.check(currentObject != null, SemanticException.ErrorCode.UNSUPPORTED);
            Object coercedObject = Verify.verifyNotNull(MessageHelpers.coerceObject(elementsTrie, targetElementType, targetElementFieldDescriptor == null ? targetDescriptor : targetDescriptorForElementField, currentElementType, currentObject));
            coercedObjectsBuilder.add(coercedObject);
        }
        ImmutableCollection coercedArray = coercedObjectsBuilder.build();
        if (targetArrayType.isNullable()) {
            DynamicMessage.Builder wrapperBuilder = DynamicMessage.newBuilder(Verify.verifyNotNull((Descriptors.Descriptor)targetDescriptor));
            wrapperBuilder.setField(Verify.verifyNotNull(targetElementFieldDescriptor), coercedArray);
            return wrapperBuilder.build();
        }
        return coercedArray;
    }

    @Nonnull
    public static Message coerceMessage(@Nullable CoercionTrieNode coercionsTrie, @Nonnull Type targetType, @Nonnull Descriptors.Descriptor targetDescriptor, @Nonnull Type currentType, @Nonnull Message currentMessage) {
        targetDescriptor = Verify.verifyNotNull(targetDescriptor);
        Map promotionsChildrenMap = coercionsTrie == null ? null : coercionsTrie.getChildrenMap();
        Type.Record targetRecordType = (Type.Record)targetType;
        Type.Record currentRecordType = (Type.Record)currentType;
        DynamicMessage.Builder resultMessageBuilder = DynamicMessage.newBuilder(targetDescriptor);
        Descriptors.Descriptor messageDescriptor = currentMessage.getDescriptorForType();
        List<Descriptors.FieldDescriptor> targetFieldsFromDescriptor = targetDescriptor.getFields();
        for (Descriptors.FieldDescriptor messageFieldDescriptor : messageDescriptor.getFields()) {
            if (!MessageHelpers.hasAnySuchField(currentMessage, messageFieldDescriptor)) continue;
            int index = messageFieldDescriptor.getIndex();
            Descriptors.FieldDescriptor targetFieldDescriptor = Verify.verifyNotNull(targetFieldsFromDescriptor.get(index));
            Type targetFieldType = Verify.verifyNotNull(targetRecordType.getField(index)).getFieldType();
            Type.Record.Field currentField = currentRecordType.getField(index);
            Type currentFieldType = Verify.verifyNotNull(currentField).getFieldType();
            Descriptors.GenericDescriptor nestedTargetDescriptor = targetFieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? targetFieldDescriptor.getMessageType() : (targetFieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM ? targetFieldDescriptor.getEnumType() : null);
            Object coercedObject = Verify.verifyNotNull(MessageHelpers.coerceObject(promotionsChildrenMap == null ? null : (CoercionTrieNode)promotionsChildrenMap.get(index), targetFieldType, nestedTargetDescriptor, currentFieldType, currentMessage.getField(messageFieldDescriptor)));
            resultMessageBuilder.setField(targetFieldDescriptor, coercedObject);
        }
        return resultMessageBuilder.build();
    }

    private static boolean hasAnySuchField(@Nonnull Message message, Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.isRepeated()) {
            return message.getRepeatedFieldCount(fieldDescriptor) > 0;
        }
        return message.hasField(fieldDescriptor);
    }

    public static class TransformationTrieNode
    extends TrieNode.AbstractTrieNode<Integer, Value, TransformationTrieNode>
    implements PlanHashable,
    PlanSerializable {
        public TransformationTrieNode(@Nullable Value value, @Nullable Map<Integer, TransformationTrieNode> childrenMap) {
            super(value, childrenMap);
        }

        @Override
        @Nonnull
        public TransformationTrieNode getThis() {
            return this;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            if (this.getChildrenMap() == null) {
                return PlanHashable.objectPlanHash(mode, this.getValue());
            }
            return PlanHashable.objectPlanHash(mode, this.getChildrenMap());
        }

        public boolean semanticEquals(Object other, @Nonnull AliasMap equivalencesMap) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransformationTrieNode)) {
                return false;
            }
            TransformationTrieNode otherTransformationTrieNode = (TransformationTrieNode)other;
            return TransformationTrieNode.equalsNullable((Value)this.getValue(), (Value)otherTransformationTrieNode.getValue(), (t2, o) -> t2.semanticEquals(o, equivalencesMap)) && TransformationTrieNode.equalsNullable(this.getChildrenMap(), otherTransformationTrieNode.getChildrenMap(), (t2, o) -> TransformationTrieNode.semanticEqualsForChildrenMap(t2, o, equivalencesMap));
        }

        private static boolean semanticEqualsForChildrenMap(@Nonnull Map<Integer, TransformationTrieNode> self, @Nonnull Map<Integer, TransformationTrieNode> other, @Nonnull AliasMap equivalencesMap) {
            if (self.size() != other.size()) {
                return false;
            }
            for (Map.Entry<Integer, TransformationTrieNode> entry : self.entrySet()) {
                TransformationTrieNode otherNestedTrie;
                Integer ordinal = entry.getKey();
                TransformationTrieNode selfNestedTrie = entry.getValue();
                if (selfNestedTrie.semanticEquals(otherNestedTrie = other.get(ordinal), equivalencesMap)) continue;
                return false;
            }
            return true;
        }

        private static <T> boolean equalsNullable(@Nullable T self, @Nullable T other, @Nonnull BiFunction<T, T, Boolean> nonNullableTest) {
            if (self == null && other == null) {
                return true;
            }
            if (self == null) {
                return false;
            }
            return nonNullableTest.apply(self, other);
        }

        @Override
        @Nonnull
        public PTransformationTrieNode toProto(@Nonnull PlanSerializationContext serializationContext) {
            PTransformationTrieNode.Builder builder = PTransformationTrieNode.newBuilder();
            if (this.getValue() != null) {
                builder.setValue(((Value)this.getValue()).toValueProto(serializationContext));
            }
            builder.setChildrenMapIsNull(this.getChildrenMap() == null);
            if (this.getChildrenMap() != null) {
                for (Map.Entry entry : this.getChildrenMap().entrySet()) {
                    builder.addChildPair(PTransformationTrieNode.IntChildPair.newBuilder().setIndex((Integer)entry.getKey()).setChildTransformationTrieNode(((TransformationTrieNode)entry.getValue()).toProto(serializationContext)));
                }
            }
            return builder.build();
        }

        @Nonnull
        public static TransformationTrieNode fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PTransformationTrieNode transformationTrieNodeProto) {
            ImmutableMap childrenMap;
            Value value = transformationTrieNodeProto.hasValue() ? Value.fromValueProto(serializationContext, transformationTrieNodeProto.getValue()) : null;
            Verify.verify(transformationTrieNodeProto.hasChildrenMapIsNull());
            if (!transformationTrieNodeProto.getChildrenMapIsNull()) {
                ImmutableMap.Builder<Integer, TransformationTrieNode> childrenMapBuilder = ImmutableMap.builder();
                for (int i = 0; i < transformationTrieNodeProto.getChildPairCount(); ++i) {
                    PTransformationTrieNode.IntChildPair childPair = transformationTrieNodeProto.getChildPair(i);
                    Verify.verify(childPair.hasIndex());
                    Verify.verify(childPair.hasChildTransformationTrieNode());
                    childrenMapBuilder.put(childPair.getIndex(), TransformationTrieNode.fromProto(serializationContext, childPair.getChildTransformationTrieNode()));
                }
                childrenMap = childrenMapBuilder.build();
            } else {
                childrenMap = null;
            }
            return new TransformationTrieNode(value, childrenMap);
        }
    }

    public static class CoercionTrieNode
    extends TrieNode.AbstractTrieNode<Integer, CoercionBiFunction, CoercionTrieNode>
    implements PlanHashable,
    PlanSerializable {
        public CoercionTrieNode(@Nullable CoercionBiFunction value, @Nullable Map<Integer, CoercionTrieNode> childrenMap) {
            super(value, childrenMap);
        }

        @Override
        @Nonnull
        public CoercionTrieNode getThis() {
            return this;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            if (this.getChildrenMap() == null) {
                return PlanHashable.objectPlanHash(mode, this.getValue());
            }
            return PlanHashable.objectPlanHash(mode, this.getChildrenMap());
        }

        @Override
        @Nonnull
        public PCoercionTrieNode toProto(@Nonnull PlanSerializationContext serializationContext) {
            PCoercionTrieNode.Builder builder = PCoercionTrieNode.newBuilder();
            if (this.getValue() != null) {
                builder.setValue(((CoercionBiFunction)this.getValue()).toCoercionBiFunctionProto(serializationContext));
            }
            builder.setChildrenMapIsNull(this.getChildrenMap() == null);
            if (this.getChildrenMap() != null) {
                for (Map.Entry entry : this.getChildrenMap().entrySet()) {
                    builder.addChildPair(PCoercionTrieNode.IntChildPair.newBuilder().setIndex((Integer)entry.getKey()).setChildCoercionTrieNode(((CoercionTrieNode)entry.getValue()).toProto(serializationContext)));
                }
            }
            return builder.build();
        }

        @Nonnull
        public static CoercionTrieNode fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCoercionTrieNode coercionTrieNodeProto) {
            ImmutableMap childrenMap;
            CoercionBiFunction value = coercionTrieNodeProto.hasValue() ? CoercionBiFunction.fromCoercionBiFunctionProto(serializationContext, coercionTrieNodeProto.getValue()) : null;
            Verify.verify(coercionTrieNodeProto.hasChildrenMapIsNull());
            if (!coercionTrieNodeProto.getChildrenMapIsNull()) {
                ImmutableMap.Builder<Integer, CoercionTrieNode> childrenMapBuilder = ImmutableMap.builder();
                for (int i = 0; i < coercionTrieNodeProto.getChildPairCount(); ++i) {
                    PCoercionTrieNode.IntChildPair childPair = coercionTrieNodeProto.getChildPair(i);
                    Verify.verify(childPair.hasIndex());
                    Verify.verify(childPair.hasChildCoercionTrieNode());
                    childrenMapBuilder.put(childPair.getIndex(), CoercionTrieNode.fromProto(serializationContext, childPair.getChildCoercionTrieNode()));
                }
                childrenMap = childrenMapBuilder.build();
            } else {
                childrenMap = null;
            }
            return new CoercionTrieNode(value, childrenMap);
        }
    }

    public static interface CoercionBiFunction
    extends BiFunction<Descriptors.GenericDescriptor, Object, Object>,
    PlanHashable,
    PlanSerializable {
        @Nonnull
        public PCoercionBiFunction toCoercionBiFunctionProto(@Nonnull PlanSerializationContext var1);

        @Nonnull
        public static CoercionBiFunction fromCoercionBiFunctionProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCoercionBiFunction coercionBiFunctionProto) {
            return (CoercionBiFunction)PlanSerialization.dispatchFromProtoContainer(serializationContext, coercionBiFunctionProto);
        }
    }
}

