/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PNotValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BooleanValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class NotValue
extends AbstractValue
implements BooleanValue,
ValueWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Not-Value");
    @Nonnull
    private final Value child;

    public NotValue(@Nonnull Value child) {
        this.child = child;
    }

    @Override
    public Optional<QueryPredicate> toQueryPredicate(@Nullable TypeRepository typeRepository, @Nonnull Set<CorrelationIdentifier> localAliases) {
        Verify.verify(this.child instanceof BooleanValue);
        Optional<QueryPredicate> predicateOptional = ((BooleanValue)this.child).toQueryPredicate(typeRepository, localAliases);
        if (predicateOptional.isPresent()) {
            QueryPredicate queryPredicate = predicateOptional.get();
            if (queryPredicate.equals(ConstantPredicate.FALSE)) {
                return Optional.of(ConstantPredicate.TRUE);
            }
            if (queryPredicate.equals(ConstantPredicate.TRUE)) {
                return Optional.of(ConstantPredicate.FALSE);
            }
            if (queryPredicate.equals(ConstantPredicate.NULL)) {
                return Optional.of(ConstantPredicate.NULL);
            }
            return Optional.of(NotPredicate.not(queryPredicate));
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    public ValueWithChild withNewChild(@Nonnull Value rebasedChild) {
        return new NotValue(rebasedChild);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object result = this.child.eval(store, context);
        if (result == null) {
            return null;
        }
        return (Boolean)result == false;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.child);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokensWithPrecedence childExplainInfo = Iterables.getOnlyElement(explainSuppliers).get();
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.NOT, new ExplainTokens().addKeyword("NOT").addWhitespace().addNested(ExplainTokensWithPrecedence.Precedence.NOT.parenthesizeChild(childExplainInfo)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PNotValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PNotValue.newBuilder().setChild(this.child.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setNotValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static NotValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNotValue notValueProto) {
        return new NotValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(notValueProto.getChild())));
    }

    public static class Deserializer
    implements PlanDeserializer<PNotValue, NotValue> {
        @Override
        @Nonnull
        public Class<PNotValue> getProtoMessageClass() {
            return PNotValue.class;
        }

        @Override
        @Nonnull
        public NotValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNotValue notValueProto) {
            return NotValue.fromProto(serializationContext, notValueProto);
        }
    }

    public static class NotFn
    extends BuiltInFunction<Value> {
        public NotFn() {
            super("not", ImmutableList.of(Type.primitiveType(Type.TypeCode.BOOLEAN)), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> NotFn.encapsulateInternal(arguments));
        }

        private static Value encapsulateInternal(@Nonnull List<? extends Typed> arguments) {
            return new NotValue((Value)arguments.get(0));
        }
    }
}

