/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PNullValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class NullValue
extends AbstractValue
implements LeafValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Null-Value");
    @Nonnull
    private final Type resultType;

    public NullValue(@Nonnull Type resultType) {
        this.resultType = resultType.nullable();
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return null;
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return false;
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.resultType.equals(other.getResultType()));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.resultType);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addToString("NULL"));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    public boolean canResultInType(@Nonnull Type type) {
        if (!type.isNullable()) {
            return false;
        }
        return this.resultType.isUnresolved() || this.resultType.getTypeCode() == Type.TypeCode.ANY;
    }

    @Override
    @Nonnull
    public Value with(@Nonnull Type type) {
        Verify.verify(type.isNullable());
        return new NullValue(type);
    }

    @Override
    @Nonnull
    public PNullValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PNullValue.newBuilder().setResultType(this.resultType.toTypeProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setNullValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static NullValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNullValue nullValueProto) {
        return new NullValue(Type.fromTypeProto(serializationContext, Objects.requireNonNull(nullValueProto.getResultType())));
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    public static class Deserializer
    implements PlanDeserializer<PNullValue, NullValue> {
        @Override
        @Nonnull
        public Class<PNullValue> getProtoMessageClass() {
            return PNullValue.class;
        }

        @Override
        @Nonnull
        public NullValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNullValue nullValueProto) {
            return NullValue.fromProto(serializationContext, nullValueProto);
        }
    }
}

