/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.planprotos.PNumericAggregationValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Accumulator;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Enums;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class NumericAggregationValue
extends AbstractValue
implements ValueWithChild,
AggregateValue {
    @Nonnull
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Sum-Value");
    @Nonnull
    private static final Supplier<Map<Pair<LogicalOperator, Type.TypeCode>, PhysicalOperator>> operatorMapSupplier = Suppliers.memoize(NumericAggregationValue::computeOperatorMap);
    @Nonnull
    protected final PhysicalOperator operator;
    @Nonnull
    private final Value child;

    protected NumericAggregationValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue numericAggregationValueProto) {
        this.operator = PhysicalOperator.fromProto(serializationContext, Objects.requireNonNull(numericAggregationValueProto.getOperator()));
        this.child = Value.fromValueProto(serializationContext, Objects.requireNonNull(numericAggregationValueProto.getChild()));
    }

    protected NumericAggregationValue(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
        this.operator = operator;
        this.child = child;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        throw new IllegalStateException("unable to eval an aggregation function with eval()");
    }

    @Override
    @Nullable
    public <M extends Message> Object evalToPartial(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.operator.evalInitialToPartial(this.child.eval(store, context));
    }

    @Override
    @Nonnull
    public Accumulator createAccumulatorWithInitialState(@Nonnull TypeRepository typeRepository, @Nullable List<RecordCursorProto.AccumulatorState> initialState) {
        if (initialState == null) {
            return new NumericAccumulator(this.operator);
        }
        Verify.verify(initialState.size() == 1);
        return new NumericAccumulator(this.operator, initialState.get(0));
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall(this.operator.name().toLowerCase(Locale.ROOT), Iterables.getOnlyElement(explainSuppliers).get().getExplainTokens()));
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(this.operator.getResultTypeCode());
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.operator});
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.operator, this.child});
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Nonnull
    public PNumericAggregationValue toNumericAggregationValueProto(@Nonnull PlanSerializationContext serializationContext) {
        PNumericAggregationValue.Builder builder = PNumericAggregationValue.newBuilder();
        builder.setOperator(this.operator.toProto(serializationContext));
        builder.setChild(this.child.toValueProto(serializationContext));
        return builder.build();
    }

    @Nonnull
    private static Map<Pair<LogicalOperator, Type.TypeCode>, PhysicalOperator> getOperatorMap() {
        return operatorMapSupplier.get();
    }

    @Nonnull
    private static AggregateValue encapsulate(@Nonnull String functionName, @Nonnull List<? extends Typed> arguments, @Nonnull BiFunction<PhysicalOperator, Value, NumericAggregationValue> valueSupplier) {
        Verify.verify(arguments.size() == 1);
        Typed arg0 = arguments.get(0);
        Type type0 = arg0.getResultType();
        SemanticException.check(type0.isPrimitive(), SemanticException.ErrorCode.ARGUMENT_TO_ARITHMETIC_OPERATOR_IS_OF_COMPLEX_TYPE);
        Optional<LogicalOperator> logicalOperatorOptional = Enums.getIfPresent(LogicalOperator.class, functionName.toUpperCase(Locale.ROOT)).toJavaUtil();
        Verify.verify(logicalOperatorOptional.isPresent());
        LogicalOperator logicalOperator = logicalOperatorOptional.get();
        PhysicalOperator physicalOperator = NumericAggregationValue.getOperatorMap().get(Pair.of(logicalOperator, type0.getTypeCode()));
        Verify.verifyNotNull(physicalOperator, "unable to encapsulate aggregate operation due to type mismatch(es)", new Object[0]);
        return valueSupplier.apply(physicalOperator, (Value)arg0);
    }

    private static Map<Pair<LogicalOperator, Type.TypeCode>, PhysicalOperator> computeOperatorMap() {
        ImmutableMap.Builder<Pair<LogicalOperator, Type.TypeCode>, PhysicalOperator> mapBuilder = ImmutableMap.builder();
        for (PhysicalOperator operator : PhysicalOperator.values()) {
            mapBuilder.put(Pair.of(operator.getLogicalOperator(), operator.getArgType()), operator);
        }
        return mapBuilder.build();
    }

    public static enum PhysicalOperator {
        SUM_I(LogicalOperator.SUM, Type.TypeCode.INT, Type.TypeCode.INT, Objects::requireNonNull, (s2, v) -> Math.addExact((Integer)s2, (Integer)v), UnaryOperator.identity()),
        SUM_L(LogicalOperator.SUM, Type.TypeCode.LONG, Type.TypeCode.LONG, Objects::requireNonNull, (s2, v) -> Math.addExact((Long)s2, (Long)v), UnaryOperator.identity()),
        SUM_F(LogicalOperator.SUM, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, Objects::requireNonNull, (s2, v) -> Float.valueOf(((Float)s2).floatValue() + ((Float)v).floatValue()), UnaryOperator.identity()),
        SUM_D(LogicalOperator.SUM, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, Objects::requireNonNull, (s2, v) -> (Double)s2 + (Double)v, UnaryOperator.identity()),
        AVG_I(LogicalOperator.AVG, Type.TypeCode.INT, Type.TypeCode.DOUBLE, v -> Pair.of(v, 1L), (s1, s2) -> {
            Pair pair1 = (Pair)s1;
            Pair pair2 = (Pair)s2;
            return Pair.of(Math.addExact((Integer)pair1.getKey(), (Integer)pair2.getKey()), Math.addExact((Long)pair1.getValue(), (Long)pair2.getValue()));
        }, s2 -> {
            Pair pair = (Pair)s2;
            return (double)((Integer)pair.getKey()).intValue() / (double)((Long)pair.getValue()).longValue();
        }),
        AVG_L(LogicalOperator.AVG, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, v -> Pair.of(v, 1L), (s1, s2) -> {
            Pair pair1 = (Pair)s1;
            Pair pair2 = (Pair)s2;
            return Pair.of(Math.addExact((Long)pair1.getKey(), (Long)pair2.getKey()), Math.addExact((Long)pair1.getValue(), (Long)pair2.getValue()));
        }, s2 -> {
            Pair pair = (Pair)s2;
            return (double)((Long)pair.getKey()).longValue() / (double)((Long)pair.getValue()).longValue();
        }),
        AVG_F(LogicalOperator.AVG, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, v -> Pair.of(v, 1L), (s1, s2) -> {
            Pair pair1 = (Pair)s1;
            Pair pair2 = (Pair)s2;
            return Pair.of(Float.valueOf(((Float)pair1.getKey()).floatValue() + ((Float)pair2.getKey()).floatValue()), Math.addExact((Long)pair1.getValue(), (Long)pair2.getValue()));
        }, s2 -> {
            Pair pair = (Pair)s2;
            return (double)((Float)pair.getKey()).floatValue() / (double)((Long)pair.getValue()).longValue();
        }),
        AVG_D(LogicalOperator.AVG, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, v -> Pair.of(v, 1L), (s1, s2) -> {
            Pair pair1 = (Pair)s1;
            Pair pair2 = (Pair)s2;
            return Pair.of((Double)pair1.getKey() + (Double)pair2.getKey(), Math.addExact((Long)pair1.getValue(), (Long)pair2.getValue()));
        }, s2 -> {
            Pair pair = (Pair)s2;
            return (Double)pair.getKey() / (double)((Long)pair.getValue()).longValue();
        }),
        MIN_I(LogicalOperator.MIN, Type.TypeCode.INT, Type.TypeCode.INT, Objects::requireNonNull, (s2, v) -> Math.min((Integer)s2, (Integer)v), UnaryOperator.identity()),
        MIN_L(LogicalOperator.MIN, Type.TypeCode.LONG, Type.TypeCode.LONG, Objects::requireNonNull, (s2, v) -> Math.min((Long)s2, (Long)v), UnaryOperator.identity()),
        MIN_F(LogicalOperator.MIN, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, Objects::requireNonNull, (s2, v) -> Float.valueOf(Math.min(((Float)s2).floatValue(), ((Float)v).floatValue())), UnaryOperator.identity()),
        MIN_D(LogicalOperator.MIN, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, Objects::requireNonNull, (s2, v) -> Math.min((Double)s2, (Double)v), UnaryOperator.identity()),
        MAX_I(LogicalOperator.MAX, Type.TypeCode.INT, Type.TypeCode.INT, Objects::requireNonNull, (s2, v) -> Math.max((Integer)s2, (Integer)v), UnaryOperator.identity()),
        MAX_L(LogicalOperator.MAX, Type.TypeCode.LONG, Type.TypeCode.LONG, Objects::requireNonNull, (s2, v) -> Math.max((Long)s2, (Long)v), UnaryOperator.identity()),
        MAX_F(LogicalOperator.MAX, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, Objects::requireNonNull, (s2, v) -> Float.valueOf(Math.max(((Float)s2).floatValue(), ((Float)v).floatValue())), UnaryOperator.identity()),
        MAX_D(LogicalOperator.MAX, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, Objects::requireNonNull, (s2, v) -> Math.max((Double)s2, (Double)v), UnaryOperator.identity()),
        BITMAP_CONSTRUCT_AGG_L(LogicalOperator.BITMAP_CONSTRUCT_AGG, Type.TypeCode.LONG, Type.TypeCode.BYTES, s2 -> {
            BitSet sset = new BitSet();
            sset.set(((Long)s2).intValue());
            return sset;
        }, (s2, v) -> {
            BitSet sset = (BitSet)s2;
            sset.or((BitSet)v);
            return sset;
        }, s2 -> {
            int fixedResultArraySize = 1250;
            byte[] res = ((BitSet)s2).toByteArray();
            if (res.length > 31250) {
                throw new RecordCoreArgumentException("entry size option is too large", new Object[0]).addLogInfo("entrySize", res.length * 8, "maxEntrySize", 250000);
            }
            if (res.length > fixedResultArraySize) {
                return res;
            }
            return Arrays.copyOf(res, fixedResultArraySize);
        }),
        BITMAP_CONSTRUCT_AGG_I(LogicalOperator.BITMAP_CONSTRUCT_AGG, Type.TypeCode.INT, Type.TypeCode.BYTES, s2 -> {
            BitSet sset = new BitSet();
            sset.set((Integer)s2);
            return sset;
        }, (s2, v) -> {
            BitSet sset = (BitSet)s2;
            sset.or((BitSet)v);
            return sset;
        }, s2 -> {
            int fixedResultArraySize = 1250;
            byte[] res = ((BitSet)s2).toByteArray();
            if (res.length > 31250) {
                throw new RecordCoreArgumentException("entry size option is too large", new Object[0]).addLogInfo("entrySize", res.length * 8, "maxEntrySize", 250000);
            }
            if (res.length > fixedResultArraySize) {
                return res;
            }
            return Arrays.copyOf(res, fixedResultArraySize);
        });

        @Nonnull
        private static final Supplier<BiMap<PhysicalOperator, PNumericAggregationValue.PPhysicalOperator>> protoEnumBiMapSupplier;
        @Nonnull
        private final LogicalOperator logicalOperator;
        @Nonnull
        private final Type.TypeCode argType;
        @Nonnull
        private final Type.TypeCode resultType;
        @Nonnull
        private final UnaryOperator<Object> initialToPartialFunction;
        @Nonnull
        private final BinaryOperator<Object> partialToPartialFunction;
        @Nonnull
        private final UnaryOperator<Object> partialToFinalFunction;

        private PhysicalOperator(@Nonnull LogicalOperator logicalOperator, @Nonnull Type.TypeCode argType, @Nonnull Type.TypeCode resultType, @Nonnull UnaryOperator<Object> initialToPartialFunction, BinaryOperator<Object> partialToPartialFunction, UnaryOperator<Object> partialToFinalFunction) {
            this.logicalOperator = logicalOperator;
            this.argType = argType;
            this.resultType = resultType;
            this.initialToPartialFunction = initialToPartialFunction;
            this.partialToPartialFunction = partialToPartialFunction;
            this.partialToFinalFunction = partialToFinalFunction;
        }

        @Nonnull
        private LogicalOperator getLogicalOperator() {
            return this.logicalOperator;
        }

        @Nonnull
        public Type.TypeCode getArgType() {
            return this.argType;
        }

        @Nonnull
        public Type.TypeCode getResultTypeCode() {
            return this.resultType;
        }

        @Nonnull
        public UnaryOperator<Object> getInitialToPartialFunction() {
            return this.initialToPartialFunction;
        }

        @Nonnull
        public BinaryOperator<Object> getPartialToPartialFunction() {
            return this.partialToPartialFunction;
        }

        @Nonnull
        public UnaryOperator<Object> getPartialToFinalFunction() {
            return this.partialToFinalFunction;
        }

        @Nullable
        public Object evalInitialToPartial(@Nullable Object object) {
            if (object == null) {
                return null;
            }
            return this.initialToPartialFunction.apply(object);
        }

        @Nullable
        public Object evalPartialToPartial(@Nullable Object object1, @Nullable Object object2) {
            if (object1 == null) {
                return object2;
            }
            if (object2 == null) {
                return object1;
            }
            return this.partialToPartialFunction.apply(object1, object2);
        }

        @Nullable
        public Object evalPartialToFinal(@Nullable Object object) {
            if (object == null) {
                return null;
            }
            return this.partialToFinalFunction.apply(object);
        }

        @Nonnull
        public PNumericAggregationValue.PPhysicalOperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            return Objects.requireNonNull((PNumericAggregationValue.PPhysicalOperator)PhysicalOperator.getProtoEnumBiMap().get((Object)this));
        }

        @Nonnull
        public static PhysicalOperator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PPhysicalOperator physicalOperatorProto) {
            return Objects.requireNonNull((PhysicalOperator)((Object)PhysicalOperator.getProtoEnumBiMap().inverse().get(physicalOperatorProto)));
        }

        @Nonnull
        private static BiMap<PhysicalOperator, PNumericAggregationValue.PPhysicalOperator> getProtoEnumBiMap() {
            return protoEnumBiMapSupplier.get();
        }

        static {
            protoEnumBiMapSupplier = Suppliers.memoize(() -> PlanSerialization.protoEnumBiMap(PhysicalOperator.class, PNumericAggregationValue.PPhysicalOperator.class));
        }
    }

    public static class NumericAccumulator
    implements Accumulator {
        private final PhysicalOperator physicalOperator;
        Object state = null;

        public NumericAccumulator(@Nonnull PhysicalOperator physicalOperator) {
            this.physicalOperator = physicalOperator;
        }

        public NumericAccumulator(@Nonnull PhysicalOperator physicalOperator, @Nonnull RecordCursorProto.AccumulatorState initialState) {
            this.physicalOperator = physicalOperator;
            switch (physicalOperator) {
                case SUM_I: 
                case MAX_I: 
                case MIN_I: {
                    Verify.verify(initialState.getStateList().size() == 1);
                    Verify.verify(initialState.getState(0).hasInt32State());
                    this.state = initialState.getState(0).getInt32State();
                    break;
                }
                case SUM_L: 
                case MAX_L: 
                case MIN_L: {
                    Verify.verify(initialState.getStateList().size() == 1);
                    Verify.verify(initialState.getState(0).hasInt64State());
                    this.state = initialState.getState(0).getInt64State();
                    break;
                }
                case SUM_D: 
                case MAX_D: 
                case MIN_D: {
                    Verify.verify(initialState.getStateList().size() == 1);
                    Verify.verify(initialState.getState(0).hasDoubleState());
                    this.state = initialState.getState(0).getDoubleState();
                    break;
                }
                case SUM_F: 
                case MAX_F: 
                case MIN_F: {
                    Verify.verify(initialState.getStateList().size() == 1);
                    Verify.verify(initialState.getState(0).hasFloatState());
                    this.state = Float.valueOf(initialState.getState(0).getFloatState());
                    break;
                }
                case AVG_I: {
                    Verify.verify(initialState.getStateList().size() == 2);
                    Verify.verify(initialState.getState(0).hasInt32State());
                    Verify.verify(initialState.getState(1).hasInt64State());
                    this.state = Pair.of(initialState.getState(0).getInt32State(), initialState.getState(1).getInt64State());
                    break;
                }
                case AVG_L: {
                    Verify.verify(initialState.getStateList().size() == 2);
                    Verify.verify(initialState.getState(0).hasInt64State());
                    Verify.verify(initialState.getState(1).hasInt64State());
                    this.state = Pair.of(initialState.getState(0).getInt64State(), initialState.getState(1).getInt64State());
                    break;
                }
                case AVG_D: {
                    Verify.verify(initialState.getStateList().size() == 2);
                    Verify.verify(initialState.getState(0).hasDoubleState());
                    Verify.verify(initialState.getState(1).hasInt64State());
                    this.state = Pair.of(initialState.getState(0).getDoubleState(), initialState.getState(1).getInt64State());
                    break;
                }
                case AVG_F: {
                    Verify.verify(initialState.getStateList().size() == 2);
                    Verify.verify(initialState.getState(0).hasFloatState());
                    Verify.verify(initialState.getState(1).hasInt64State());
                    this.state = Pair.of(Float.valueOf(initialState.getState(0).getFloatState()), initialState.getState(1).getInt64State());
                    break;
                }
                case BITMAP_CONSTRUCT_AGG_I: 
                case BITMAP_CONSTRUCT_AGG_L: {
                    Verify.verify(initialState.getStateList().size() == 1);
                    Verify.verify(initialState.getState(0).hasBytesState());
                    this.state = BitSet.valueOf(initialState.getState(0).getBytesState().toByteArray());
                    break;
                }
                default: {
                    throw new RecordCoreException("Unsupported physical operator name in initial accumulator state.", new Object[0]);
                }
            }
        }

        @Override
        public void accumulate(@Nullable Object currentObject) {
            this.state = this.physicalOperator.evalPartialToPartial(this.state, currentObject);
        }

        @Override
        @Nullable
        public Object finish() {
            return this.physicalOperator.evalPartialToFinal(this.state);
        }

        @Override
        @Nonnull
        public List<RecordCursorProto.AccumulatorState> getAccumulatorStates() {
            if (this.state == null) {
                return List.of();
            }
            RecordCursorProto.AccumulatorState.Builder builder = RecordCursorProto.AccumulatorState.newBuilder();
            switch (this.physicalOperator) {
                case SUM_I: 
                case MAX_I: 
                case MIN_I: {
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt32State((Integer)this.state));
                    break;
                }
                case SUM_L: 
                case MAX_L: 
                case MIN_L: {
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt64State((Long)this.state));
                    break;
                }
                case SUM_D: 
                case MAX_D: 
                case MIN_D: {
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setDoubleState((Double)this.state));
                    break;
                }
                case SUM_F: 
                case MAX_F: 
                case MIN_F: {
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setFloatState(((Float)this.state).floatValue()));
                    break;
                }
                case AVG_I: {
                    Pair pair = (Pair)this.state;
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt32State((Integer)pair.getLeft())).addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt64State((Long)pair.getRight()));
                    break;
                }
                case AVG_L: {
                    Pair pair = (Pair)this.state;
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt64State((Long)pair.getLeft())).addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt64State((Long)pair.getRight()));
                    break;
                }
                case AVG_D: {
                    Pair pair = (Pair)this.state;
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setDoubleState((Double)pair.getLeft())).addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt64State((Long)pair.getRight()));
                    break;
                }
                case AVG_F: {
                    Pair pair = (Pair)this.state;
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setFloatState(((Float)pair.getLeft()).floatValue())).addState(RecordCursorProto.OneOfTypedState.newBuilder().setInt64State((Long)pair.getRight()));
                    break;
                }
                case BITMAP_CONSTRUCT_AGG_I: 
                case BITMAP_CONSTRUCT_AGG_L: {
                    builder.addState(RecordCursorProto.OneOfTypedState.newBuilder().setBytesState(ByteString.copyFrom(((BitSet)this.state).toByteArray())));
                    break;
                }
            }
            return List.of(builder.build());
        }
    }

    private static enum LogicalOperator {
        SUM,
        AVG,
        MIN,
        MAX,
        BITMAP_CONSTRUCT_AGG;

    }

    public static class MaxFn
    extends BuiltInFunction<AggregateValue> {
        public MaxFn() {
            super("MAX", ImmutableList.of(new Type.Any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> Max.encapsulate(x$0, x$1));
        }
    }

    public static class MinFn
    extends BuiltInFunction<AggregateValue> {
        public MinFn() {
            super("MIN", ImmutableList.of(new Type.Any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> Min.encapsulate(x$0, x$1));
        }
    }

    public static class AvgFn
    extends BuiltInFunction<AggregateValue> {
        public AvgFn() {
            super("AVG", ImmutableList.of(new Type.Any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> Avg.encapsulate(x$0, x$1));
        }
    }

    public static class BitmapConstructAggFn
    extends BuiltInFunction<AggregateValue> {
        public BitmapConstructAggFn() {
            super("BITMAP_CONSTRUCT_AGG", ImmutableList.of(new Type.Any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> BitmapConstructAgg.encapsulate(x$0, x$1));
        }
    }

    public static class SumFn
    extends BuiltInFunction<AggregateValue> {
        public SumFn() {
            super("SUM", ImmutableList.of(new Type.Any()), (BuiltInFunction<T> x$0, List<Typed> x$1) -> Sum.encapsulate(x$0, x$1));
        }
    }

    public static class Max
    extends NumericAggregationValue
    implements StreamableAggregateValue,
    IndexableAggregateValue {
        public Max(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
            super(operator, child);
        }

        protected Max(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PMax maxProto) {
            super(serializationContext, Objects.requireNonNull(maxProto.getSuper()));
        }

        @Override
        @Nonnull
        public String getIndexTypeName() {
            return "permuted_max";
        }

        @Nonnull
        private static AggregateValue encapsulate(@Nonnull BuiltInFunction<AggregateValue> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return NumericAggregationValue.encapsulate(builtInFunction.getFunctionName(), arguments, Max::new);
        }

        @Override
        @Nonnull
        public ValueWithChild withNewChild(@Nonnull Value newChild) {
            return new Max(this.operator, newChild);
        }

        @Override
        @Nonnull
        public PNumericAggregationValue.PMax toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PNumericAggregationValue.PMax.newBuilder().setSuper(this.toNumericAggregationValueProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setNumericAggregationValueMax(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Max fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PMax maxProto) {
            return new Max(serializationContext, maxProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PNumericAggregationValue.PMax, Max> {
            @Override
            @Nonnull
            public Class<PNumericAggregationValue.PMax> getProtoMessageClass() {
                return PNumericAggregationValue.PMax.class;
            }

            @Override
            @Nonnull
            public Max fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PMax maxProto) {
                return Max.fromProto(serializationContext, maxProto);
            }
        }
    }

    public static class Min
    extends NumericAggregationValue
    implements StreamableAggregateValue,
    IndexableAggregateValue {
        public Min(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
            super(operator, child);
        }

        protected Min(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PMin minProto) {
            super(serializationContext, Objects.requireNonNull(minProto.getSuper()));
        }

        @Override
        @Nonnull
        public String getIndexTypeName() {
            return "permuted_min";
        }

        @Nonnull
        private static AggregateValue encapsulate(@Nonnull BuiltInFunction<AggregateValue> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return NumericAggregationValue.encapsulate(builtInFunction.getFunctionName(), arguments, Min::new);
        }

        @Override
        @Nonnull
        public ValueWithChild withNewChild(@Nonnull Value newChild) {
            return new Min(this.operator, newChild);
        }

        @Override
        @Nonnull
        public PNumericAggregationValue.PMin toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PNumericAggregationValue.PMin.newBuilder().setSuper(this.toNumericAggregationValueProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setNumericAggregationValueMin(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Min fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PMin minProto) {
            return new Min(serializationContext, minProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PNumericAggregationValue.PMin, Min> {
            @Override
            @Nonnull
            public Class<PNumericAggregationValue.PMin> getProtoMessageClass() {
                return PNumericAggregationValue.PMin.class;
            }

            @Override
            @Nonnull
            public Min fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PMin minProto) {
                return Min.fromProto(serializationContext, minProto);
            }
        }
    }

    public static class Avg
    extends NumericAggregationValue
    implements StreamableAggregateValue {
        public Avg(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
            super(operator, child);
        }

        protected Avg(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PAvg avgProto) {
            super(serializationContext, Objects.requireNonNull(avgProto.getSuper()));
        }

        @Nonnull
        private static AggregateValue encapsulate(@Nonnull BuiltInFunction<AggregateValue> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return NumericAggregationValue.encapsulate(builtInFunction.getFunctionName(), arguments, Avg::new);
        }

        @Override
        @Nonnull
        public ValueWithChild withNewChild(@Nonnull Value newChild) {
            return new Avg(this.operator, newChild);
        }

        @Override
        @Nonnull
        public PNumericAggregationValue.PAvg toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PNumericAggregationValue.PAvg.newBuilder().setSuper(this.toNumericAggregationValueProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setNumericAggregationValueAvg(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Avg fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PAvg avgProto) {
            return new Avg(serializationContext, avgProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PNumericAggregationValue.PAvg, Avg> {
            @Override
            @Nonnull
            public Class<PNumericAggregationValue.PAvg> getProtoMessageClass() {
                return PNumericAggregationValue.PAvg.class;
            }

            @Override
            @Nonnull
            public Avg fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PAvg avgProto) {
                return Avg.fromProto(serializationContext, avgProto);
            }
        }
    }

    public static class Sum
    extends NumericAggregationValue
    implements StreamableAggregateValue,
    IndexableAggregateValue {
        public Sum(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
            super(operator, child);
        }

        protected Sum(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PSum sumProto) {
            super(serializationContext, Objects.requireNonNull(sumProto.getSuper()));
        }

        @Override
        @Nonnull
        public String getIndexTypeName() {
            return "sum";
        }

        @Nonnull
        private static AggregateValue encapsulate(@Nonnull BuiltInFunction<AggregateValue> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return NumericAggregationValue.encapsulate(builtInFunction.getFunctionName(), arguments, Sum::new);
        }

        @Override
        @Nonnull
        public ValueWithChild withNewChild(@Nonnull Value newChild) {
            return new Sum(this.operator, newChild);
        }

        @Override
        @Nonnull
        public PNumericAggregationValue.PSum toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PNumericAggregationValue.PSum.newBuilder().setSuper(this.toNumericAggregationValueProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setNumericAggregationValueSum(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static Sum fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PSum sumProto) {
            return new Sum(serializationContext, sumProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PNumericAggregationValue.PSum, Sum> {
            @Override
            @Nonnull
            public Class<PNumericAggregationValue.PSum> getProtoMessageClass() {
                return PNumericAggregationValue.PSum.class;
            }

            @Override
            @Nonnull
            public Sum fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PSum sumProto) {
                return Sum.fromProto(serializationContext, sumProto);
            }
        }
    }

    public static class BitmapConstructAgg
    extends NumericAggregationValue
    implements StreamableAggregateValue,
    IndexableAggregateValue {
        public BitmapConstructAgg(@Nonnull PhysicalOperator operator, @Nonnull Value child) {
            super(operator, child);
        }

        protected BitmapConstructAgg(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PBitmapConstructAgg bitMapProto) {
            super(serializationContext, Objects.requireNonNull(bitMapProto.getSuper()));
        }

        @Override
        @Nonnull
        public String getIndexTypeName() {
            return "bitmap_value";
        }

        @Nonnull
        private static AggregateValue encapsulate(@Nonnull BuiltInFunction<AggregateValue> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return NumericAggregationValue.encapsulate(builtInFunction.getFunctionName(), arguments, BitmapConstructAgg::new);
        }

        @Override
        @Nonnull
        public ValueWithChild withNewChild(@Nonnull Value newChild) {
            return new BitmapConstructAgg(this.operator, newChild);
        }

        @Override
        @Nonnull
        public PNumericAggregationValue.PBitmapConstructAgg toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PNumericAggregationValue.PBitmapConstructAgg.newBuilder().setSuper(this.toNumericAggregationValueProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setNumericAggregationValueBitmapConstructAgg(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static BitmapConstructAgg fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PBitmapConstructAgg bitMapProto) {
            return new BitmapConstructAgg(serializationContext, bitMapProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PNumericAggregationValue.PBitmapConstructAgg, BitmapConstructAgg> {
            @Override
            @Nonnull
            public Class<PNumericAggregationValue.PBitmapConstructAgg> getProtoMessageClass() {
                return PNumericAggregationValue.PBitmapConstructAgg.class;
            }

            @Override
            @Nonnull
            public BitmapConstructAgg fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNumericAggregationValue.PBitmapConstructAgg bitMapProto) {
                return BitmapConstructAgg.fromProto(serializationContext, bitMapProto);
            }
        }
    }
}

