/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PObjectValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ObjectValue
extends AbstractValue
implements LeafValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Object-Value");
    @Nonnull
    private final CorrelationIdentifier alias;
    @Nonnull
    private final Type resultType;

    private ObjectValue(@Nonnull CorrelationIdentifier alias, @Nonnull Type resultType) {
        this.alias = alias;
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return ImmutableSet.of(this.alias);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public Value rebaseLeaf(@Nonnull CorrelationIdentifier targetAlias) {
        return ObjectValue.of(targetAlias, this.resultType);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return context.getBinding(Bindings.Internal.CORRELATION, this.alias);
    }

    @Nonnull
    public CorrelationIdentifier getAlias() {
        return this.alias;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, (Object)BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addAliasReference(this.alias));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return false;
    }

    @Override
    @Nonnull
    public PObjectValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PObjectValue.newBuilder().setAlias(this.getAlias().getId()).setResultType(this.resultType.toTypeProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setObjectValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PObjectValue objectValueProto) {
        return new ObjectValue(CorrelationIdentifier.of(Objects.requireNonNull(objectValueProto.getAlias())), Type.fromTypeProto(serializationContext, Objects.requireNonNull(objectValueProto.getResultType())));
    }

    @Nonnull
    public static ObjectValue of(@Nonnull CorrelationIdentifier alias, @Nonnull Type resultType) {
        return new ObjectValue(alias, resultType);
    }

    public static class Deserializer
    implements PlanDeserializer<PObjectValue, ObjectValue> {
        @Override
        @Nonnull
        public Class<PObjectValue> getProtoMessageClass() {
            return PObjectValue.class;
        }

        @Override
        @Nonnull
        public ObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PObjectValue objectValueProto) {
            return ObjectValue.fromProto(serializationContext, objectValueProto);
        }
    }
}

