/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.POfTypeValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OfTypeValue
extends AbstractValue
implements Value.RangeMatchableValue,
ValueWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Of-Type-Value");
    @Nonnull
    private final Value child;
    @Nonnull
    private final Type expectedType;

    private OfTypeValue(@Nonnull Value child, @Nonnull Type expectedType) {
        this.child = child;
        this.expectedType = expectedType;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.expectedType, this.child);
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.child;
    }

    @Nonnull
    public Type getExpectedType() {
        return this.expectedType;
    }

    @Override
    @Nonnull
    public ValueWithChild withNewChild(@Nonnull Value rebasedChild) {
        return new OfTypeValue(rebasedChild, this.expectedType);
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object value = this.child.eval(store, context);
        if (value == null) {
            return this.expectedType.isNullable();
        }
        if (value instanceof DynamicMessage) {
            return this.expectedType.isRecord();
        }
        Type type = Type.fromObject(value);
        if (type.isPrimitive() && this.expectedType.isPrimitive() && type.getTypeCode() != Type.TypeCode.NULL) {
            return type.nullable().equals(this.expectedType.nullable());
        }
        boolean promotionNeeded = PromoteValue.isPromotionNeeded(type, this.expectedType);
        if (!promotionNeeded) {
            return true;
        }
        return PromoteValue.resolvePhysicalOperator(type, this.expectedType) != null;
    }

    @Override
    @Nullable
    public Boolean evalWithoutStore(@Nonnull EvaluationContext context) {
        return this.eval((FDBRecordStoreBase)null, context);
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.expectedType.equals(((OfTypeValue)other).getExpectedType()));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, this.expectedType);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokens child = Iterables.getOnlyElement(explainSuppliers).get().getExplainTokens();
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.ALWAYS_PARENS, child.addWhitespace().addIdentifier("OF").addWhitespace().addKeyword("TYPE").addWhitespace().addNested(this.expectedType.describe()));
    }

    @Override
    @Nonnull
    public POfTypeValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return POfTypeValue.newBuilder().setChild(this.child.toValueProto(serializationContext)).setExpectedType(this.expectedType.toTypeProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setOfTypeValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static OfTypeValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull POfTypeValue ofTypeValueProto) {
        return new OfTypeValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(ofTypeValueProto.getChild())), Type.fromTypeProto(serializationContext, Objects.requireNonNull(ofTypeValueProto.getExpectedType())));
    }

    @Nonnull
    public static OfTypeValue of(@Nonnull Value value, @Nonnull Type type) {
        return new OfTypeValue(value, type);
    }

    @Nonnull
    public static OfTypeValue from(@Nonnull ConstantObjectValue value) {
        return new OfTypeValue(ConstantObjectValue.of(value.getAlias(), value.getConstantId(), Type.any()), value.getResultType());
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    public static class Deserializer
    implements PlanDeserializer<POfTypeValue, OfTypeValue> {
        @Override
        @Nonnull
        public Class<POfTypeValue> getProtoMessageClass() {
            return POfTypeValue.class;
        }

        @Override
        @Nonnull
        public OfTypeValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull POfTypeValue ofTypeValueProto) {
            return OfTypeValue.fromProto(serializationContext, ofTypeValueProto);
        }
    }
}

