/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PParameterObjectValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ParameterObjectValue
extends AbstractValue
implements LeafValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Parameter-Object-Value");
    @Nonnull
    private final String parameterName;
    @Nonnull
    private final Type resultType;

    private ParameterObjectValue(@Nonnull String parameterName, @Nonnull Type resultType) {
        this.parameterName = parameterName;
        this.resultType = resultType;
    }

    @Nonnull
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nonnull
    public Value rebaseLeaf(@Nonnull CorrelationIdentifier targetAlias) {
        return this;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return context.getBinding(this.parameterName);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, (Object)BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword("$").addIdentifier(this.parameterName));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return LeafValue.super.equalsWithoutChildren(other).filter(ignored -> this.getParameterName().equals(((ParameterObjectValue)other).getParameterName()));
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return false;
    }

    @Override
    @Nonnull
    public Value with(@Nonnull Type type) {
        return ParameterObjectValue.of(this.parameterName, type);
    }

    @Override
    @Nonnull
    public PParameterObjectValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PParameterObjectValue.Builder builder = PParameterObjectValue.newBuilder();
        builder.setParameterName(this.parameterName);
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        PParameterObjectValue specificValueProto = this.toProto(serializationContext);
        return PValue.newBuilder().setParameterObjectValue(specificValueProto).build();
    }

    @Nonnull
    public static ParameterObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PParameterObjectValue parameterObjectValueProto) {
        return new ParameterObjectValue(Objects.requireNonNull(parameterObjectValueProto.getParameterName()), Type.fromTypeProto(serializationContext, Objects.requireNonNull(parameterObjectValueProto.getResultType())));
    }

    @Nonnull
    public static ParameterObjectValue of(@Nonnull String parameterName, @Nonnull Type resultType) {
        return new ParameterObjectValue(parameterName, resultType);
    }

    public static class Deserializer
    implements PlanDeserializer<PParameterObjectValue, ParameterObjectValue> {
        @Override
        @Nonnull
        public Class<PParameterObjectValue> getProtoMessageClass() {
            return PParameterObjectValue.class;
        }

        @Override
        @Nonnull
        public ParameterObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PParameterObjectValue parameterObjectValueProto) {
            return ParameterObjectValue.fromProto(serializationContext, parameterObjectValueProto);
        }
    }
}

