/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PPatternForLikeValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.util.StringUtils;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class PatternForLikeValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Like-Operator-Value");
    private static final Map<String, String> REPLACE_MAP = ImmutableMap.builder().put("%", ".*").put("_", ".").put("|", "\\|").put(".", "\\.").put("^", "\\^").put("$", "\\$").put("\\", "\\\\").put("*", "\\*").put("+", "\\+").put("?", "\\?").put("[", "\\[").put("]", "\\]").put("{", "\\{").put("}", "\\}").put("(", "\\(").put(")", "\\)").build();
    @Nonnull
    private final Value patternChild;
    @Nonnull
    private final Value escapeChild;

    public PatternForLikeValue(@Nonnull Value patternChild, @Nonnull Value escapeChild) {
        this.patternChild = patternChild;
        this.escapeChild = escapeChild;
    }

    @Override
    @Nullable
    public <M extends Message> String eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Map<String, String> replaceMap;
        String patternStr = (String)this.patternChild.eval(store, context);
        String escapeChar = (String)this.escapeChild.eval(store, context);
        if (patternStr == null) {
            return null;
        }
        if (escapeChar == null) {
            replaceMap = REPLACE_MAP;
        } else {
            SemanticException.check(escapeChar.length() == 1, SemanticException.ErrorCode.ESCAPE_CHAR_OF_LIKE_OPERATOR_IS_NOT_SINGLE_CHAR);
            replaceMap = ImmutableMap.builderWithExpectedSize(REPLACE_MAP.size() + 2).put((CallSite)((Object)(escapeChar + "_")), "_").put((CallSite)((Object)(escapeChar + "%")), "%").putAll(REPLACE_MAP).build();
        }
        return "^" + StringUtils.replaceEach(patternStr, replaceMap) + "$";
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.patternChild, this.escapeChild);
    }

    @Override
    @Nonnull
    public PatternForLikeValue withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(Iterables.size(newChildren) == 2);
        return new PatternForLikeValue(Iterables.get(newChildren, 0), Iterables.get(newChildren, 1));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.patternChild, this.escapeChild);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokensWithPrecedence pattern = Iterables.get(explainSuppliers, 0).get();
        ExplainTokensWithPrecedence escape = Iterables.get(explainSuppliers, 1).get();
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.BETWEEN.parenthesizeChild(pattern).addWhitespace().addKeyword("ESCAPE").addWhitespace().addNested(ExplainTokensWithPrecedence.Precedence.BETWEEN.parenthesizeChild(escape)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(Type.TypeCode.STRING);
    }

    @Override
    @Nonnull
    public PPatternForLikeValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PPatternForLikeValue.newBuilder().setPatternChild(this.patternChild.toValueProto(serializationContext)).setEscapeChild(this.escapeChild.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setPatternForLikeValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static PatternForLikeValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPatternForLikeValue patternForLikeValueProto) {
        return new PatternForLikeValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(patternForLikeValueProto.getPatternChild())), Value.fromValueProto(serializationContext, Objects.requireNonNull(patternForLikeValueProto.getEscapeChild())));
    }

    @Nonnull
    private static Value encapsulate(@Nonnull List<? extends Typed> arguments) {
        Verify.verify(arguments.size() == 2);
        Type patternType = arguments.get(0).getResultType();
        Type escapeType = arguments.get(0).getResultType();
        SemanticException.check(patternType.getTypeCode().equals((Object)Type.TypeCode.STRING), SemanticException.ErrorCode.OPERAND_OF_LIKE_OPERATOR_IS_NOT_STRING);
        SemanticException.check(escapeType.getTypeCode().equals((Object)Type.TypeCode.STRING), SemanticException.ErrorCode.OPERAND_OF_LIKE_OPERATOR_IS_NOT_STRING);
        return new PatternForLikeValue((Value)arguments.get(0), (Value)arguments.get(1));
    }

    public static class Deserializer
    implements PlanDeserializer<PPatternForLikeValue, PatternForLikeValue> {
        @Override
        @Nonnull
        public Class<PPatternForLikeValue> getProtoMessageClass() {
            return PPatternForLikeValue.class;
        }

        @Override
        @Nonnull
        public PatternForLikeValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPatternForLikeValue patternForLikeValueProto) {
            return PatternForLikeValue.fromProto(serializationContext, patternForLikeValueProto);
        }
    }

    public static class PatternForLikeFn
    extends BuiltInFunction<Value> {
        public PatternForLikeFn() {
            super("patternForLike", ImmutableList.of(Type.primitiveType(Type.TypeCode.STRING), Type.primitiveType(Type.TypeCode.STRING)), (BuiltInFunction<T> ignored, List<Typed> args) -> PatternForLikeValue.encapsulate(args));
        }
    }
}

