/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PPickValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class PickValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Pick-Value");
    @Nonnull
    private final Value selectorValue;
    @Nonnull
    private final List<? extends Value> alternativeValues;
    @Nonnull
    private final Iterable<? extends Value> children;
    @Nonnull
    private final Type resultType;

    public PickValue(@Nonnull Value selectorValue, @Nonnull Iterable<? extends Value> alternativeValues) {
        this(selectorValue, alternativeValues, PickValue.resolveTypesFromAlternatives(alternativeValues));
    }

    private PickValue(@Nonnull Value selectorValue, @Nonnull Iterable<? extends Value> alternativeValues, @Nonnull Type resultType) {
        this.selectorValue = selectorValue;
        this.alternativeValues = ImmutableList.copyOf(alternativeValues);
        this.children = Iterables.concat(ImmutableList.of(selectorValue), alternativeValues);
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return this.children;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Integer boxedSelectedIndex = (Integer)this.selectorValue.eval(store, context);
        if (boxedSelectedIndex == null) {
            return null;
        }
        int selectedIndex = boxedSelectedIndex;
        return this.alternativeValues.get(selectedIndex).eval(store, context);
    }

    @Override
    @Nonnull
    public Value withChildren(Iterable<? extends Value> newChildren) {
        Iterator<? extends Value> newChildrenIterator = newChildren.iterator();
        Value newSelectorValue = newChildrenIterator.next();
        return new PickValue(newSelectorValue, ImmutableList.copyOf(newChildrenIterator));
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return this.alternativeValues.stream().allMatch(alternativeValue -> alternativeValue.isFunctionallyDependentOn(otherValue));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChildren());
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("pick", Value.explainFunctionArguments(explainSuppliers)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PPickValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PPickValue.Builder builder = PPickValue.newBuilder();
        builder.setSelectorValue(this.selectorValue.toValueProto(serializationContext));
        for (Value value : this.alternativeValues) {
            builder.addAlternativeValues(value.toValueProto(serializationContext));
        }
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setPickValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static PickValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPickValue pickValueProto) {
        ImmutableList.Builder alternativeValuesBuilder = ImmutableList.builder();
        for (int i = 0; i < pickValueProto.getAlternativeValuesCount(); ++i) {
            alternativeValuesBuilder.add(Value.fromValueProto(serializationContext, pickValueProto.getAlternativeValues(i)));
        }
        return new PickValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(pickValueProto.getSelectorValue())), alternativeValuesBuilder.build(), Type.fromTypeProto(serializationContext, Objects.requireNonNull(pickValueProto.getResultType())));
    }

    @Nonnull
    private static Type resolveTypesFromAlternatives(@Nonnull Iterable<? extends Value> alternativeValues) {
        Type commonType = null;
        for (Value value : alternativeValues) {
            Type resultType = value.getResultType();
            if (commonType == null) {
                commonType = resultType;
                continue;
            }
            SemanticException.check(commonType.equals(resultType), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
        }
        return ((Type)Verify.verifyNotNull(commonType)).withNullability(true);
    }

    public static class PickValueFn
    extends BuiltInFunction<Value> {
        public PickValueFn() {
            super("pick", List.of(Type.primitiveType(Type.TypeCode.INT), Type.any()), Type.any(), PickValueFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> ignored, @Nonnull List<? extends Typed> arguments) {
            Verify.verify(arguments.size() > 1);
            Value selectorValue = (Value)arguments.get(0);
            Type selectorMaxType = Type.maximumType(selectorValue.getResultType(), Type.primitiveType(Type.TypeCode.INT));
            SemanticException.check(selectorMaxType != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            selectorValue = PromoteValue.inject(selectorValue, selectorMaxType);
            Value firstAlternative = (Value)arguments.get(1);
            Type alternativesMaxType = firstAlternative.getResultType();
            for (int i = 2; i < arguments.size(); ++i) {
                SemanticException.check((alternativesMaxType = Type.maximumType(alternativesMaxType, arguments.get(i).getResultType())) != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            }
            ImmutableList.Builder alternativesList = ImmutableList.builder();
            for (int i = 1; i < arguments.size(); ++i) {
                alternativesList.add(PromoteValue.inject((Value)arguments.get(i), alternativesMaxType));
            }
            return new PickValue(selectorValue, alternativesList.build());
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PPickValue, PickValue> {
        @Override
        @Nonnull
        public Class<PPickValue> getProtoMessageClass() {
            return PPickValue.class;
        }

        @Override
        @Nonnull
        public PickValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPickValue pickValueProto) {
            return PickValue.fromProto(serializationContext, pickValueProto);
        }
    }
}

