/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PArrayCoercionBiFunction;
import com.apple.foundationdb.record.planprotos.PCoercionBiFunction;
import com.apple.foundationdb.record.planprotos.PPrimitiveCoercionBiFunction;
import com.apple.foundationdb.record.planprotos.PPromoteValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.CreatesDynamicTypesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class PromoteValue
extends AbstractValue
implements CreatesDynamicTypesValue,
ValueWithChild,
Value.RangeMatchableValue {
    private static final Map<NonnullPair<Type.TypeCode, Type.TypeCode>, PhysicalOperator> PROMOTION_MAP;
    private static final ObjectPlanHash BASE_HASH;
    @Nonnull
    private final Value inValue;
    @Nonnull
    private final Type promoteToType;
    @Nullable
    private final MessageHelpers.CoercionTrieNode promotionTrie;
    private final boolean isSimplePromotion;

    public PromoteValue(@Nonnull Value inValue, @Nonnull Type promoteToType, @Nullable MessageHelpers.CoercionTrieNode promotionTrie) {
        this.inValue = inValue;
        this.promoteToType = promoteToType;
        this.promotionTrie = promotionTrie;
        this.isSimplePromotion = promoteToType.isPrimitive() || promoteToType.isUuid() || promoteToType instanceof Type.Array && Objects.requireNonNull(((Type.Array)promoteToType).getElementType()).isPrimitive();
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.inValue;
    }

    @Override
    @Nonnull
    public PromoteValue withNewChild(@Nonnull Value newChild) {
        if (this.getChild() == newChild) {
            return this;
        }
        return new PromoteValue(newChild, this.promoteToType, this.promotionTrie);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Descriptors.GenericDescriptor genericDescriptor;
        Object result = this.inValue.eval(store, context);
        if (result == null) {
            return null;
        }
        if (this.promotionTrie == null) {
            return result;
        }
        if (this.isSimplePromotion) {
            genericDescriptor = null;
        } else if (this.promoteToType.isEnum()) {
            genericDescriptor = context.getTypeRepository().getEnumDescriptor(this.promoteToType);
        } else {
            Verify.verify(this.promoteToType.isRecord());
            genericDescriptor = context.getTypeRepository().getMessageDescriptor(this.promoteToType);
        }
        return MessageHelpers.coerceObject(this.promotionTrie, this.promoteToType, genericDescriptor, this.inValue.getResultType(), result);
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.promoteToType;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, this.promoteToType);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.inValue, this.promoteToType);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokensWithPrecedence in = Iterables.getOnlyElement(explainSuppliers).get();
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("promote", in.getExplainTokens().addWhitespace().addKeyword("AS").addWhitespace().addNested(this.promoteToType.describe())));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PPromoteValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PPromoteValue.Builder builder = PPromoteValue.newBuilder().setInValue(this.inValue.toValueProto(serializationContext)).setPromoteToType(this.promoteToType.toTypeProto(serializationContext));
        if (this.promotionTrie != null) {
            builder.setPromotionTrie(this.promotionTrie.toProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setPromoteValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static PromoteValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPromoteValue promoteValueProto) {
        MessageHelpers.CoercionTrieNode promotionTrie = promoteValueProto.hasPromotionTrie() ? MessageHelpers.CoercionTrieNode.fromProto(serializationContext, Objects.requireNonNull(promoteValueProto.getPromotionTrie())) : null;
        return new PromoteValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(promoteValueProto.getInValue())), Type.fromTypeProto(serializationContext, Objects.requireNonNull(promoteValueProto.getPromoteToType())), promotionTrie);
    }

    @Nullable
    public static MessageHelpers.CoercionTrieNode computePromotionsTrie(@Nonnull Type targetType, @Nonnull Type currentType, @Nullable MessageHelpers.TransformationTrieNode transformationsTrie) {
        if (targetType.getTypeCode() == Type.TypeCode.ANY) {
            return null;
        }
        if (transformationsTrie != null && transformationsTrie.getValue() != null) {
            currentType = ((Value)transformationsTrie.getValue()).getResultType();
        }
        if (currentType.isPrimitive()) {
            if (!PromoteValue.isPromotionNeeded(currentType, targetType)) {
                return null;
            }
            PhysicalOperator physicalOperator = PromoteValue.resolvePhysicalOperator(currentType, targetType);
            SemanticException.check(physicalOperator != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            return new MessageHelpers.CoercionTrieNode(new PrimitiveCoercionBiFunction(physicalOperator), null);
        }
        Verify.verify(targetType.getTypeCode() == currentType.getTypeCode());
        if (currentType.isUuid()) {
            return null;
        }
        if (currentType.isEnum()) {
            SemanticException.check(currentType.withNullability(false).equals(targetType.withNullability(false)), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            return null;
        }
        if (currentType.isArray()) {
            Type currentElementType;
            Type.Array targetArrayType = (Type.Array)targetType;
            Type.Array currentArrayType = (Type.Array)currentType;
            Type targetElementType = Verify.verifyNotNull(targetArrayType.getElementType());
            MessageHelpers.CoercionTrieNode elementsTrie = PromoteValue.computePromotionsTrie(targetElementType, currentElementType = Verify.verifyNotNull(currentArrayType.getElementType()), null);
            if (elementsTrie == null && currentType.isNullable() == targetType.isNullable()) {
                return null;
            }
            return new MessageHelpers.CoercionTrieNode(new ArrayCoercionBiFunction(currentArrayType, targetArrayType, elementsTrie), (Map<Integer, MessageHelpers.CoercionTrieNode>)(elementsTrie == null ? null : ImmutableMap.of(-1, elementsTrie)));
        }
        Verify.verify(currentType.isRecord());
        Type.Record targetRecordType = (Type.Record)targetType;
        Type.Record currentRecordType = (Type.Record)currentType;
        SemanticException.check(targetRecordType.getFields().size() == currentRecordType.getFields().size(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
        List<Type.Record.Field> targetFields = targetRecordType.getFields();
        List<Type.Record.Field> currentFields = currentRecordType.getFields();
        Map transformationsChildrenMap = transformationsTrie == null ? null : transformationsTrie.getChildrenMap();
        ImmutableMap.Builder<Integer, MessageHelpers.CoercionTrieNode> childrenMapBuilder = ImmutableMap.builder();
        for (int i = 0; i < targetFields.size(); ++i) {
            Type.Record.Field targetField = targetFields.get(i);
            Type.Record.Field currentField = currentFields.get(i);
            MessageHelpers.TransformationTrieNode transformationsFieldTrie = transformationsChildrenMap == null ? null : (MessageHelpers.TransformationTrieNode)transformationsChildrenMap.get(i);
            MessageHelpers.CoercionTrieNode fieldTrie = PromoteValue.computePromotionsTrie(targetField.getFieldType(), currentField.getFieldType(), transformationsFieldTrie);
            if (fieldTrie == null) continue;
            childrenMapBuilder.put(i, fieldTrie);
        }
        ImmutableMap<Integer, MessageHelpers.CoercionTrieNode> childrenMap = childrenMapBuilder.build();
        return childrenMap.isEmpty() ? null : new MessageHelpers.CoercionTrieNode(null, childrenMap);
    }

    @Nonnull
    public static Value inject(@Nonnull Value inValue, @Nonnull Type promoteToType) {
        Type inType = inValue.getResultType();
        if (inType.equals(promoteToType)) {
            return inValue;
        }
        if (inValue.canResultInType(promoteToType)) {
            return inValue.with(promoteToType);
        }
        MessageHelpers.CoercionTrieNode promotionTrie = PromoteValue.computePromotionsTrie(promoteToType, inType, null);
        return new PromoteValue(inValue, promoteToType, promotionTrie);
    }

    public static boolean isPromotable(@Nonnull Type inType, @Nonnull Type promoteToType) {
        return PromoteValue.resolvePhysicalOperator(inType, promoteToType) != null;
    }

    @Nullable
    static PhysicalOperator resolvePhysicalOperator(@Nonnull Type inType, @Nonnull Type promoteToType) {
        return PROMOTION_MAP.get(NonnullPair.of(inType.getTypeCode(), promoteToType.getTypeCode()));
    }

    public static boolean isPromotionNeeded(@Nonnull Type inType, @Nonnull Type promoteToType) {
        if (promoteToType.getTypeCode() == Type.TypeCode.ANY) {
            return false;
        }
        if (inType.getTypeCode() == Type.TypeCode.NULL) {
            return true;
        }
        if (inType.getTypeCode() == Type.TypeCode.NONE) {
            return true;
        }
        if (inType.isArray() && promoteToType.isArray()) {
            Type.Array inArray = (Type.Array)inType;
            Type.Array promoteToArray = (Type.Array)promoteToType;
            SemanticException.check(!inArray.isErased() && !promoteToArray.isErased(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            return PromoteValue.isPromotionNeeded(Verify.verifyNotNull(inArray.getElementType()), Verify.verifyNotNull(promoteToArray.getElementType()));
        }
        if (inType.isRecord() && promoteToType.isRecord()) {
            List<Type> inTypeElements = Objects.requireNonNull(((Type.Record)inType).getElementTypes());
            List<Type> promoteToTypeElements = Objects.requireNonNull(((Type.Record)promoteToType).getElementTypes());
            SemanticException.check(inTypeElements.size() == promoteToTypeElements.size(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            boolean promotionNeeded = false;
            for (int i = 0; i < inTypeElements.size(); ++i) {
                if (!PromoteValue.isPromotionNeeded(inTypeElements.get(i), promoteToTypeElements.get(i))) continue;
                promotionNeeded = true;
            }
            return promotionNeeded;
        }
        SemanticException.check(!(!inType.isPrimitive() && !inType.isEnum() && !inType.isUuid() || !promoteToType.isPrimitive() && !promoteToType.isEnum() && !promoteToType.isUuid()), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
        return inType.getTypeCode() != promoteToType.getTypeCode();
    }

    static {
        ImmutableMap.Builder<NonnullPair<Type.TypeCode, Type.TypeCode>, PhysicalOperator> mapBuilder = ImmutableMap.builder();
        for (PhysicalOperator operator : PhysicalOperator.values()) {
            mapBuilder.put(NonnullPair.of(operator.getFrom(), operator.getTo()), operator);
        }
        PROMOTION_MAP = mapBuilder.build();
        BASE_HASH = new ObjectPlanHash("Promote-Value");
    }

    static enum PhysicalOperator {
        INT_TO_LONG(Type.TypeCode.INT, Type.TypeCode.LONG, (descriptor, in) -> (long)((Integer)in).intValue()),
        INT_TO_FLOAT(Type.TypeCode.INT, Type.TypeCode.FLOAT, (descriptor, in) -> Float.valueOf(((Integer)in).intValue())),
        INT_TO_DOUBLE(Type.TypeCode.INT, Type.TypeCode.DOUBLE, (descriptor, in) -> (double)((Integer)in).intValue()),
        LONG_TO_FLOAT(Type.TypeCode.LONG, Type.TypeCode.FLOAT, (descriptor, in) -> Float.valueOf(((Long)in).longValue())),
        LONG_TO_DOUBLE(Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (descriptor, in) -> (double)((Long)in).longValue()),
        FLOAT_TO_DOUBLE(Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (descriptor, in) -> (double)((Float)in).floatValue()),
        NULL_TO_INT(Type.TypeCode.NULL, Type.TypeCode.INT, (descriptor, in) -> null),
        NULL_TO_LONG(Type.TypeCode.NULL, Type.TypeCode.LONG, (descriptor, in) -> null),
        NULL_TO_FLOAT(Type.TypeCode.NULL, Type.TypeCode.FLOAT, (descriptor, in) -> null),
        NULL_TO_DOUBLE(Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (descriptor, in) -> null),
        NULL_TO_BOOLEAN(Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (descriptor, in) -> null),
        NULL_TO_STRING(Type.TypeCode.NULL, Type.TypeCode.STRING, (descriptor, in) -> null),
        NULL_TO_ARRAY(Type.TypeCode.NULL, Type.TypeCode.ARRAY, (descriptor, in) -> null),
        NULL_TO_RECORD(Type.TypeCode.NULL, Type.TypeCode.RECORD, (descriptor, in) -> null),
        NONE_TO_ARRAY(Type.TypeCode.NONE, Type.TypeCode.ARRAY, (descriptor, in) -> in),
        NULL_TO_ENUM(Type.TypeCode.NULL, Type.TypeCode.ENUM, (descriptor, in) -> null),
        STRING_TO_ENUM(Type.TypeCode.STRING, Type.TypeCode.ENUM, (descriptor, in) -> PhysicalOperator.stringToEnumValue((Descriptors.EnumDescriptor)descriptor, (String)in)),
        STRING_TO_UUID(Type.TypeCode.STRING, Type.TypeCode.UUID, (descriptor, in) -> PhysicalOperator.stringToUuidValue((String)in));

        @Nonnull
        private static final Supplier<BiMap<PhysicalOperator, PPrimitiveCoercionBiFunction.PPhysicalOperator>> protoEnumBiMapSupplier;
        @Nonnull
        private final Type.TypeCode from;
        @Nonnull
        private final Type.TypeCode to;
        @Nonnull
        private final BiFunction<Descriptors.GenericDescriptor, Object, Object> promotionFunction;

        private PhysicalOperator(@Nonnull Type.TypeCode from, Type.TypeCode to, BiFunction<Descriptors.GenericDescriptor, Object, Object> promotionFunction) {
            this.from = from;
            this.to = to;
            this.promotionFunction = promotionFunction;
        }

        @Nonnull
        public Type.TypeCode getFrom() {
            return this.from;
        }

        @Nonnull
        public Type.TypeCode getTo() {
            return this.to;
        }

        @Nonnull
        public BiFunction<Descriptors.GenericDescriptor, Object, Object> getPromotionFunction() {
            return this.promotionFunction;
        }

        public Object apply(@Nullable Descriptors.GenericDescriptor descriptor, @Nullable Object in) {
            return this.promotionFunction.apply(descriptor, in);
        }

        @Nonnull
        public PPrimitiveCoercionBiFunction.PPhysicalOperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            return Objects.requireNonNull((PPrimitiveCoercionBiFunction.PPhysicalOperator)PhysicalOperator.getProtoEnumBiMap().get((Object)this));
        }

        @Nonnull
        public static PhysicalOperator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPrimitiveCoercionBiFunction.PPhysicalOperator physicalOperatorProto) {
            return Objects.requireNonNull((PhysicalOperator)((Object)PhysicalOperator.getProtoEnumBiMap().inverse().get(physicalOperatorProto)));
        }

        @Nonnull
        public static Descriptors.EnumValueDescriptor stringToEnumValue(Descriptors.EnumDescriptor enumDescriptor, String value) {
            Descriptors.EnumValueDescriptor maybeValue = enumDescriptor.findValueByName(value);
            SemanticException.check(maybeValue != null, SemanticException.ErrorCode.INVALID_ENUM_VALUE, value);
            return maybeValue;
        }

        public static UUID stringToUuidValue(String value) {
            try {
                return UUID.fromString(value);
            }
            catch (IllegalArgumentException ex) {
                SemanticException.fail(SemanticException.ErrorCode.INVALID_UUID_VALUE, value);
                return null;
            }
        }

        @Nonnull
        private static BiMap<PhysicalOperator, PPrimitiveCoercionBiFunction.PPhysicalOperator> getProtoEnumBiMap() {
            return protoEnumBiMapSupplier.get();
        }

        static {
            protoEnumBiMapSupplier = Suppliers.memoize(() -> PlanSerialization.protoEnumBiMap(PhysicalOperator.class, PPrimitiveCoercionBiFunction.PPhysicalOperator.class));
        }
    }

    public static class PrimitiveCoercionBiFunction
    implements MessageHelpers.CoercionBiFunction {
        @Nonnull
        private final PhysicalOperator operator;

        private PrimitiveCoercionBiFunction(@Nonnull PhysicalOperator operator) {
            this.operator = operator;
        }

        @Override
        public Object apply(Descriptors.GenericDescriptor targetDescriptor, Object current) {
            return this.operator.apply(targetDescriptor, current);
        }

        public int hashCode() {
            return Objects.hash(this.operator.name());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrimitiveCoercionBiFunction)) {
                return false;
            }
            PrimitiveCoercionBiFunction that = (PrimitiveCoercionBiFunction)o;
            return this.operator == that.operator;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectsPlanHash(hashMode, new Object[]{this.operator});
        }

        @Override
        @Nonnull
        public PPrimitiveCoercionBiFunction toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PPrimitiveCoercionBiFunction.newBuilder().setOperator(this.operator.toProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PCoercionBiFunction toCoercionBiFunctionProto(@Nonnull PlanSerializationContext serializationContext) {
            return PCoercionBiFunction.newBuilder().setPrimitiveCoercionBiFunction(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static PrimitiveCoercionBiFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPrimitiveCoercionBiFunction primitiveCoercionBiFunctionProto) {
            return new PrimitiveCoercionBiFunction(PhysicalOperator.fromProto(serializationContext, Objects.requireNonNull(primitiveCoercionBiFunctionProto.getOperator())));
        }

        public static class Deserializer
        implements PlanDeserializer<PPrimitiveCoercionBiFunction, PrimitiveCoercionBiFunction> {
            @Override
            @Nonnull
            public Class<PPrimitiveCoercionBiFunction> getProtoMessageClass() {
                return PPrimitiveCoercionBiFunction.class;
            }

            @Override
            @Nonnull
            public PrimitiveCoercionBiFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPrimitiveCoercionBiFunction primitiveCoercionBiFunctionProto) {
                return PrimitiveCoercionBiFunction.fromProto(serializationContext, primitiveCoercionBiFunctionProto);
            }
        }
    }

    public static class ArrayCoercionBiFunction
    implements MessageHelpers.CoercionBiFunction {
        @Nonnull
        private final Type.Array fromArrayType;
        @Nonnull
        private final Type.Array toArrayType;
        @Nullable
        private final MessageHelpers.CoercionTrieNode elementsTrie;

        public ArrayCoercionBiFunction(@Nonnull Type.Array fromArrayType, @Nonnull Type.Array toArrayType, @Nullable MessageHelpers.CoercionTrieNode elementsTrie) {
            this.fromArrayType = fromArrayType;
            this.toArrayType = toArrayType;
            this.elementsTrie = elementsTrie;
        }

        @Override
        public Object apply(Descriptors.GenericDescriptor targetDescriptor, Object current) {
            return MessageHelpers.coerceArray(this.toArrayType, this.fromArrayType, targetDescriptor, this.elementsTrie, current);
        }

        public int hashCode() {
            return Objects.hash(this.fromArrayType, this.toArrayType, this.elementsTrie);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ArrayCoercionBiFunction)) {
                return false;
            }
            ArrayCoercionBiFunction that = (ArrayCoercionBiFunction)o;
            return Objects.equals(this.fromArrayType, that.fromArrayType) && Objects.equals(this.toArrayType, that.toArrayType) && Objects.equals(this.elementsTrie, that.elementsTrie);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectsPlanHash(hashMode, this.fromArrayType, this.toArrayType, this.elementsTrie);
        }

        @Override
        @Nonnull
        public PArrayCoercionBiFunction toProto(@Nonnull PlanSerializationContext serializationContext) {
            PArrayCoercionBiFunction.Builder builder = PArrayCoercionBiFunction.newBuilder().setFromArrayType(this.fromArrayType.toTypeProto(serializationContext)).setToArrayType(this.toArrayType.toTypeProto(serializationContext));
            if (this.elementsTrie != null) {
                builder.setElementsTrie(this.elementsTrie.toProto(serializationContext));
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public PCoercionBiFunction toCoercionBiFunctionProto(@Nonnull PlanSerializationContext serializationContext) {
            return PCoercionBiFunction.newBuilder().setArrayCoercionBiFunction(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static ArrayCoercionBiFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PArrayCoercionBiFunction arrayCoercionBiFunctionProto) {
            MessageHelpers.CoercionTrieNode elementsTrie = arrayCoercionBiFunctionProto.hasElementsTrie() ? MessageHelpers.CoercionTrieNode.fromProto(serializationContext, arrayCoercionBiFunctionProto.getElementsTrie()) : null;
            return new ArrayCoercionBiFunction((Type.Array)Type.fromTypeProto(serializationContext, Objects.requireNonNull(arrayCoercionBiFunctionProto.getFromArrayType())), (Type.Array)Type.fromTypeProto(serializationContext, Objects.requireNonNull(arrayCoercionBiFunctionProto.getToArrayType())), elementsTrie);
        }

        public static class Deserializer
        implements PlanDeserializer<PArrayCoercionBiFunction, ArrayCoercionBiFunction> {
            @Override
            @Nonnull
            public Class<PArrayCoercionBiFunction> getProtoMessageClass() {
                return PArrayCoercionBiFunction.class;
            }

            @Override
            @Nonnull
            public ArrayCoercionBiFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PArrayCoercionBiFunction arrayCoercionBiFunctionProto) {
                return ArrayCoercionBiFunction.fromProto(serializationContext, arrayCoercionBiFunctionProto);
            }
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PPromoteValue, PromoteValue> {
        @Override
        @Nonnull
        public Class<PPromoteValue> getProtoMessageClass() {
            return PPromoteValue.class;
        }

        @Override
        @Nonnull
        public PromoteValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPromoteValue promoteValueProto) {
            return PromoteValue.fromProto(serializationContext, promoteValueProto);
        }
    }
}

