/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PQuantifiedObjectValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class QuantifiedObjectValue
extends AbstractValue
implements QuantifiedValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Quantified-Object-Value");
    @Nonnull
    private final CorrelationIdentifier alias;
    @Nonnull
    private final Type resultType;

    private QuantifiedObjectValue(@Nonnull CorrelationIdentifier alias, @Nonnull Type resultType) {
        this.alias = alias;
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nonnull
    public Value rebaseLeaf(@Nonnull CorrelationIdentifier targetAlias) {
        return QuantifiedObjectValue.of(targetAlias, this.resultType);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object obj = context.getBinding(Bindings.Internal.CORRELATION, this.alias);
        if (this.getResultType().isRelation()) {
            return obj;
        }
        QueryResult binding = (QueryResult)obj;
        if (this.resultType.isRecord()) {
            return binding.getDatum() == null ? null : binding.getMessage();
        }
        return binding.getDatum();
    }

    @Override
    @Nonnull
    public CorrelationIdentifier getAlias() {
        return this.alias;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return QuantifiedValue.super.getCorrelatedToWithoutChildren();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, (Object)BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addAliasReference(this.alias));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        if (otherValue instanceof QuantifiedObjectValue) {
            return this.getAlias().equals(((QuantifiedObjectValue)otherValue).getAlias());
        }
        return false;
    }

    @Override
    @Nonnull
    public Value with(@Nonnull Type type) {
        return QuantifiedObjectValue.of(this.getAlias(), type);
    }

    @Override
    @Nonnull
    public PQuantifiedObjectValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PQuantifiedObjectValue.Builder builder = PQuantifiedObjectValue.newBuilder();
        builder.setAlias(this.alias.getId());
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        PQuantifiedObjectValue specificValueProto = this.toProto(serializationContext);
        return PValue.newBuilder().setQuantifiedObjectValue(specificValueProto).build();
    }

    @Nonnull
    public static QuantifiedObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PQuantifiedObjectValue quantifiedObjectValue) {
        return new QuantifiedObjectValue(CorrelationIdentifier.of(Objects.requireNonNull(quantifiedObjectValue.getAlias())), Type.fromTypeProto(serializationContext, Objects.requireNonNull(quantifiedObjectValue.getResultType())));
    }

    @Nonnull
    public static QuantifiedObjectValue of(@Nonnull Quantifier quantifier) {
        return new QuantifiedObjectValue(quantifier.getAlias(), quantifier.getFlowedObjectType());
    }

    @Nonnull
    public static QuantifiedObjectValue of(@Nonnull CorrelationIdentifier alias, @Nonnull Type resultType) {
        return new QuantifiedObjectValue(alias, resultType);
    }

    public static boolean isSimpleQuantifiedObjectValueOver(@Nonnull Value value, @Nonnull CorrelationIdentifier alias) {
        if (!(value instanceof QuantifiedObjectValue)) {
            return false;
        }
        return ((QuantifiedObjectValue)value).getAlias().equals(alias);
    }

    public static class Deserializer
    implements PlanDeserializer<PQuantifiedObjectValue, QuantifiedObjectValue> {
        @Override
        @Nonnull
        public Class<PQuantifiedObjectValue> getProtoMessageClass() {
            return PQuantifiedObjectValue.class;
        }

        @Override
        @Nonnull
        public QuantifiedObjectValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PQuantifiedObjectValue quantifiedObjectValueProto) {
            return QuantifiedObjectValue.fromProto(serializationContext, quantifiedObjectValueProto);
        }
    }
}

