/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PQuantifiedRecordValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class QuantifiedRecordValue
extends AbstractValue
implements QuantifiedValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Quantified-Record-Value");
    @Nonnull
    private final CorrelationIdentifier alias;
    @Nonnull
    private final Type resultType;

    private QuantifiedRecordValue(@Nonnull CorrelationIdentifier alias, @Nonnull Type resultType) {
        this.alias = alias;
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nonnull
    public Value rebaseLeaf(@Nonnull CorrelationIdentifier targetAlias) {
        return QuantifiedRecordValue.of(targetAlias, this.resultType);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        QueryResult binding = (QueryResult)context.getBinding(Bindings.Internal.CORRELATION, this.alias);
        return binding.getQueriedRecord();
    }

    @Override
    @Nonnull
    public CorrelationIdentifier getAlias() {
        return this.alias;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return QuantifiedValue.super.getCorrelatedToWithoutChildren();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, (Object)BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addOpeningSquareBracket().addOptionalWhitespace().addAliasReference(this.alias).addOptionalWhitespace().addClosingSquareBracket());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        if (otherValue instanceof QuantifiedRecordValue) {
            return this.getAlias().equals(((QuantifiedRecordValue)otherValue).getAlias());
        }
        return false;
    }

    @Override
    @Nonnull
    public Value with(@Nonnull Type type) {
        return QuantifiedRecordValue.of(this.getAlias(), type);
    }

    @Override
    @Nonnull
    public PQuantifiedRecordValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PQuantifiedRecordValue.Builder builder = PQuantifiedRecordValue.newBuilder();
        builder.setAlias(this.alias.getId());
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        PQuantifiedRecordValue specificValueProto = this.toProto(serializationContext);
        return PValue.newBuilder().setQuantifiedRecordValue(specificValueProto).build();
    }

    @Nonnull
    public static QuantifiedRecordValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PQuantifiedRecordValue quantifiedRecordValueProto) {
        return new QuantifiedRecordValue(CorrelationIdentifier.of(Objects.requireNonNull(quantifiedRecordValueProto.getAlias())), Type.fromTypeProto(serializationContext, Objects.requireNonNull(quantifiedRecordValueProto.getResultType())));
    }

    @Nonnull
    public static QuantifiedRecordValue of(@Nonnull Quantifier quantifier) {
        return new QuantifiedRecordValue(quantifier.getAlias(), quantifier.getFlowedObjectType());
    }

    @Nonnull
    public static QuantifiedRecordValue of(@Nonnull CorrelationIdentifier alias, @Nonnull Type resultType) {
        return new QuantifiedRecordValue(alias, resultType);
    }

    public static class Deserializer
    implements PlanDeserializer<PQuantifiedRecordValue, QuantifiedRecordValue> {
        @Override
        @Nonnull
        public Class<PQuantifiedRecordValue> getProtoMessageClass() {
            return PQuantifiedRecordValue.class;
        }

        @Override
        @Nonnull
        public QuantifiedRecordValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PQuantifiedRecordValue quantifiedObjectValueProto) {
            return QuantifiedRecordValue.fromProto(serializationContext, quantifiedObjectValueProto);
        }
    }
}

