/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface QuantifiedValue
extends LeafValue {
    @Nonnull
    public CorrelationIdentifier getAlias();

    @Override
    @Nonnull
    default public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return ImmutableSet.of(this.getAlias());
    }

    @Override
    @Nonnull
    default public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return LeafValue.super.equalsWithoutChildren(other).filter(ignored -> this.getAlias().equals(((QuantifiedValue)other).getAlias()));
    }

    @Override
    @Nonnull
    default public Map<Value, Value> pullUp(@Nonnull Iterable<? extends Value> toBePulledUpValues, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull CorrelationIdentifier upperBaseAlias) {
        CorrelationIdentifier alias = this.getAlias();
        boolean areSimpleReferences = Streams.stream(toBePulledUpValues).flatMap(toBePulledUpValue -> toBePulledUpValue.getCorrelatedTo().stream()).noneMatch(a -> !alias.equals(a) && constantAliases.contains(a));
        if (areSimpleReferences) {
            RegularTranslationMap translationMap = TranslationMap.rebaseWithAliasMap(AliasMap.ofAliases(alias, upperBaseAlias));
            ImmutableMap.Builder<Value, Value> translatedMapBuilder = ImmutableMap.builder();
            for (Value value : toBePulledUpValues) {
                translatedMapBuilder.put(value, value.translateCorrelations(translationMap));
            }
            return translatedMapBuilder.build();
        }
        return LeafValue.super.pullUp(toBePulledUpValues, evaluationContext, aliasMap, constantAliases, upperBaseAlias);
    }
}

