/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PQueriedValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class QueriedValue
extends AbstractValue
implements LeafValue,
Value.NonEvaluableValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Queried-Value");
    @Nonnull
    private final Type resultType;
    @Nullable
    private List<String> recordTypeNames;

    public QueriedValue() {
        this(Type.primitiveType(Type.TypeCode.UNKNOWN));
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of();
    }

    public QueriedValue(@Nonnull Type resultType) {
        this.resultType = resultType;
    }

    public QueriedValue(@Nonnull Type resultType, @Nullable Iterable<String> recordTypeNames) {
        this.resultType = resultType;
        this.recordTypeNames = recordTypeNames == null ? null : ImmutableList.copyOf(recordTypeNames);
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Nullable
    public List<String> getRecordTypeNames() {
        return this.recordTypeNames;
    }

    @Override
    public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        return false;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, (Object)BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        if (this.recordTypeNames == null) {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("base"));
        }
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("base", new ExplainTokens().addToStrings(this.recordTypeNames)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PQueriedValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PQueriedValue.Builder builder = PQueriedValue.newBuilder().setResultType(this.resultType.toTypeProto(serializationContext));
        builder.setHasRecordTypeNames(this.recordTypeNames != null);
        if (this.recordTypeNames != null) {
            builder.addAllRecordTypeNames(this.recordTypeNames);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setQueriedValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static QueriedValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PQueriedValue queriedValueProto) {
        ImmutableCollection recordTypeNames;
        Verify.verify(queriedValueProto.hasHasRecordTypeNames());
        if (queriedValueProto.getHasRecordTypeNames()) {
            ImmutableList.Builder recordTypeNamesBuilder = ImmutableList.builder();
            for (int i = 0; i < queriedValueProto.getRecordTypeNamesCount(); ++i) {
                recordTypeNamesBuilder.add(queriedValueProto.getRecordTypeNames(i));
            }
            recordTypeNames = recordTypeNamesBuilder.build();
        } else {
            recordTypeNames = null;
        }
        return new QueriedValue(Type.fromTypeProto(serializationContext, Objects.requireNonNull(queriedValueProto.getResultType())), recordTypeNames);
    }

    public static class Deserializer
    implements PlanDeserializer<PQueriedValue, QueriedValue> {
        @Override
        @Nonnull
        public Class<PQueriedValue> getProtoMessageClass() {
            return PQueriedValue.class;
        }

        @Override
        @Nonnull
        public QueriedValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PQueriedValue queriedValueProto) {
            return QueriedValue.fromProto(serializationContext, queriedValueProto);
        }
    }
}

