/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.planprotos.PRangeValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInTableFunction;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.properties.CardinalitiesProperty;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.CreatesDynamicTypesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RangeValue
extends AbstractValue
implements StreamingValue,
CreatesDynamicTypesValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Range-Value");
    @Nonnull
    private final Value endExclusive;
    @Nonnull
    private final Value beginInclusive;
    @Nonnull
    private final Value step;
    @Nonnull
    private final Value currentRangeValue;

    public RangeValue(@Nonnull Value endExclusive, @Nonnull Value beginInclusive, @Nonnull Value step) {
        this.endExclusive = endExclusive;
        this.beginInclusive = beginInclusive;
        this.step = step;
        this.currentRangeValue = RecordConstructorValue.ofColumns(ImmutableList.of(Column.of(Optional.of("ID"), LiteralValue.ofScalar(-1L))));
    }

    @Override
    @Nonnull
    public Type.Record getResultType() {
        return (Type.Record)this.currentRangeValue.getResultType();
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> evalAsStream(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        long endExclusiveValue = (Long)Verify.verifyNotNull(this.endExclusive.eval(store, context));
        Long beginInclusiveValue = (Long)Verify.verifyNotNull(this.beginInclusive.eval(store, context));
        Long stepValue = (Long)Verify.verifyNotNull(this.step.eval(store, context));
        return new Cursor(store.getExecutor(), endExclusiveValue, beginInclusiveValue, stepValue, rangeValueAsLong -> Objects.requireNonNull((Value)this.currentRangeValue.replace(v -> {
            if (v instanceof LiteralValue) {
                return LiteralValue.ofScalar(rangeValueAsLong);
            }
            return v;
        })).eval(store, context), continuation).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokens endExplainTokens = Iterables.get(explainSuppliers, 0).get().getExplainTokens();
        ExplainTokens beginExplainTokens = Iterables.get(explainSuppliers, 1).get().getExplainTokens();
        ExplainTokens stepExplainTokens = Iterables.get(explainSuppliers, 2).get().getExplainTokens();
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("range", new ExplainTokens().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), beginExplainTokens, endExplainTokens, new ExplainTokens().addKeyword("STEP").addWhitespace().addNested(stepExplainTokens))));
    }

    @Override
    @Nonnull
    public CardinalitiesProperty.Cardinalities getCardinalities() {
        try {
            long beginLong = ((Number)this.beginInclusive.evalWithoutStore(EvaluationContext.EMPTY)).longValue();
            long endLong = ((Number)this.endExclusive.evalWithoutStore(EvaluationContext.EMPTY)).longValue();
            long stepLong = ((Number)this.step.evalWithoutStore(EvaluationContext.EMPTY)).longValue();
            CardinalitiesProperty.Cardinality cardinality = CardinalitiesProperty.Cardinality.ofCardinality(Math.floorDiv(endLong - beginLong, stepLong));
            return new CardinalitiesProperty.Cardinalities(cardinality, cardinality);
        }
        catch (RecordCoreException evalException) {
            return CardinalitiesProperty.Cardinalities.unknownMaxCardinality();
        }
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        throw new IllegalStateException("unable to eval an streaming value with eval()");
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, (Object)BASE_HASH);
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setRangeValue(this.toProto(serializationContext)).build();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
        return PlanHashable.objectsPlanHash(hashMode, BASE_HASH, this.getChildren());
    }

    @Override
    @Nonnull
    public PRangeValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PRangeValue.Builder builder = PRangeValue.newBuilder();
        builder.setEndExclusiveChild(this.endExclusive.toValueProto(serializationContext));
        builder.setBeginInclusiveChild(this.beginInclusive.toValueProto(serializationContext));
        builder.setStepChild(this.step.toValueProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        childrenBuilder.add(this.endExclusive);
        childrenBuilder.add(this.beginInclusive);
        childrenBuilder.add(this.step);
        return childrenBuilder.build();
    }

    @Override
    @Nonnull
    public Value withChildren(Iterable<? extends Value> newChildren) {
        int newChildrenSize = Iterables.size(newChildren);
        Verify.verify(newChildrenSize == 3);
        Value newEndExclusive = Iterables.get(newChildren, 0);
        Value newBeginInclusive = Iterables.get(newChildren, 1);
        Value newStep = Iterables.get(newChildren, 2);
        if (newEndExclusive == this.endExclusive && newBeginInclusive == this.beginInclusive && newStep == this.step) {
            return this;
        }
        return new RangeValue(newEndExclusive, newBeginInclusive, newStep);
    }

    @Nonnull
    public static RangeValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRangeValue rangeValueProto) {
        Value endExclusive = Value.fromValueProto(serializationContext, rangeValueProto.getEndExclusiveChild());
        Value beginInclusive = Value.fromValueProto(serializationContext, rangeValueProto.getBeginInclusiveChild());
        Value step = Value.fromValueProto(serializationContext, rangeValueProto.getStepChild());
        return new RangeValue(endExclusive, beginInclusive, step);
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        if (other == this) {
            return ConstrainedBoolean.alwaysTrue();
        }
        if (!(other instanceof RangeValue)) {
            return ConstrainedBoolean.falseValue();
        }
        RangeValue otherRange = (RangeValue)other;
        return this.beginInclusive.equalsWithoutChildren(otherRange.beginInclusive).composeWithOther(this.endExclusive.equalsWithoutChildren(otherRange.endExclusive)).composeWithOther(this.step.equalsWithoutChildren(otherRange.step));
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    private static void checkValidBoundaryType(@Nonnull Value value) {
        Type type = value.getResultType();
        SemanticException.check(type.isPrimitive(), SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
        Type maxType = Type.maximumType(type, Type.primitiveType(Type.TypeCode.LONG));
        SemanticException.check(maxType != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
        SemanticException.check(value.preOrderStream().filter(Value.NondeterministicValue.class::isInstance).findAny().isEmpty(), SemanticException.ErrorCode.UNSUPPORTED);
    }

    public static class Cursor
    implements RecordCursor<QueryResult> {
        @Nonnull
        private final Executor executor;
        private final long endExclusive;
        private final long step;
        private long nextPosition;
        private boolean closed = false;
        @Nonnull
        private final Function<Long, Object> rangeValueCreator;

        Cursor(@Nonnull Executor executor, long endExclusive, long beginInclusive, long step, @Nonnull Function<Long, Object> rangeValueCreator, @Nullable byte[] continuation) {
            this(executor, endExclusive, step, rangeValueCreator, continuation == null ? beginInclusive : Continuation.from(continuation, endExclusive, step).getNextPosition());
        }

        private Cursor(@Nonnull Executor executor, long endExclusive, long step, @Nonnull Function<Long, Object> rangeValueCreator, long nextPosition) {
            Cursor.checkValidRange(nextPosition, endExclusive, step);
            this.executor = executor;
            this.endExclusive = endExclusive;
            this.step = step;
            this.nextPosition = nextPosition;
            this.rangeValueCreator = rangeValueCreator;
        }

        @Override
        @Nonnull
        public CompletableFuture<RecordCursorResult<QueryResult>> onNext() {
            return CompletableFuture.completedFuture(this.getNext());
        }

        @Override
        @Nonnull
        public RecordCursorResult<QueryResult> getNext() {
            RecordCursorResult<QueryResult> nextResult;
            if (this.nextPosition < this.endExclusive) {
                Continuation continuation = new Continuation(this.endExclusive, this.nextPosition + this.step, this.step);
                nextResult = RecordCursorResult.withNextValue(QueryResult.ofComputed(this.rangeValueCreator.apply(this.nextPosition)), continuation);
                this.nextPosition += this.step;
            } else {
                nextResult = RecordCursorResult.exhausted();
            }
            return nextResult;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean accept(@Nonnull RecordCursorVisitor visitor) {
            visitor.visitEnter(this);
            return visitor.visitLeave(this);
        }

        @Override
        @Nonnull
        public Executor getExecutor() {
            return this.executor;
        }

        private static void checkValidRange(long position, long endExclusive, long step) {
            if (position < 0L) {
                throw new RecordCoreException("only non-negative position is allowed in range", new Object[0]);
            }
            if (endExclusive < 0L) {
                throw new RecordCoreException("only non-negative exclusive end is allowed in range", new Object[0]);
            }
            if (step <= 0L) {
                throw new RecordCoreException("only positive step is allowed in range", new Object[0]);
            }
        }

        private static class Continuation
        implements RecordCursorContinuation {
            private final long endExclusive;
            private final long nextPosition;
            private final long step;

            public Continuation(long endExclusive, long nextPosition, long step) {
                this.nextPosition = nextPosition;
                this.endExclusive = endExclusive;
                this.step = step;
            }

            @Override
            public boolean isEnd() {
                return this.nextPosition >= this.endExclusive + this.step;
            }

            public long getNextPosition() {
                return this.nextPosition;
            }

            @Override
            @Nonnull
            public ByteString toByteString() {
                if (this.isEnd()) {
                    return ByteString.EMPTY;
                }
                RecordCursorProto.RangeCursorContinuation.Builder protoBuilder = RecordCursorProto.RangeCursorContinuation.newBuilder().setNextPosition(this.nextPosition);
                return protoBuilder.build().toByteString();
            }

            @Override
            @Nullable
            public byte[] toBytes() {
                return this.toByteString().toByteArray();
            }

            @Nonnull
            public static Continuation from(@Nonnull RecordCursorProto.RangeCursorContinuation message, long endExclusive, long step) {
                long nextPosition = message.getNextPosition();
                return new Continuation(endExclusive, nextPosition, step);
            }

            @Nonnull
            public static Continuation from(@Nonnull byte[] unparsedContinuationBytes, long endExclusive, long step) {
                try {
                    RecordCursorProto.RangeCursorContinuation parsed = RecordCursorProto.RangeCursorContinuation.parseFrom(unparsedContinuationBytes);
                    return Continuation.from(parsed, endExclusive, step);
                }
                catch (InvalidProtocolBufferException ex) {
                    throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(unparsedContinuationBytes)});
                }
            }
        }
    }

    public static class RangeFn
    extends BuiltInTableFunction {
        @Nonnull
        private static StreamingValue encapsulateInternal(@Nonnull List<? extends Typed> arguments) {
            Value stepMaybe;
            LiteralValue<Long> beginInclusiveMaybe;
            Value endExclusive;
            Verify.verify(!arguments.isEmpty());
            if (arguments.size() == 1) {
                endExclusive = PromoteValue.inject((Value)arguments.get(0), Type.primitiveType(Type.TypeCode.LONG));
                RangeValue.checkValidBoundaryType(endExclusive);
                beginInclusiveMaybe = LiteralValue.ofScalar(0L);
                stepMaybe = LiteralValue.ofScalar(1L);
            } else {
                RangeValue.checkValidBoundaryType((Value)arguments.get(0));
                beginInclusiveMaybe = PromoteValue.inject((Value)arguments.get(0), Type.primitiveType(Type.TypeCode.LONG));
                RangeValue.checkValidBoundaryType((Value)arguments.get(1));
                endExclusive = PromoteValue.inject((Value)arguments.get(1), Type.primitiveType(Type.TypeCode.LONG));
                if (arguments.size() > 2) {
                    RangeValue.checkValidBoundaryType((Value)arguments.get(2));
                    stepMaybe = PromoteValue.inject((Value)arguments.get(2), Type.primitiveType(Type.TypeCode.LONG));
                } else {
                    stepMaybe = LiteralValue.ofScalar(1L);
                }
            }
            return new RangeValue(endExclusive, beginInclusiveMaybe, stepMaybe);
        }

        public RangeFn() {
            super("range", (List<Type>)ImmutableList.of(), (Type)new Type.Any(), (BuiltInFunction<StreamingValue> ignored, List<Typed> arguments) -> RangeFn.encapsulateInternal(arguments));
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PRangeValue, RangeValue> {
        @Override
        @Nonnull
        public Class<PRangeValue> getProtoMessageClass() {
            return PRangeValue.class;
        }

        @Override
        @Nonnull
        public RangeValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRangeValue rangeValueProto) {
            return RangeValue.fromProto(serializationContext, rangeValueProto);
        }
    }
}

