/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PRankValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.WindowedValue;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RankValue
extends WindowedValue
implements Value.IndexOnlyValue {
    private static final String NAME = "RANK";
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("RANK-Value");

    public RankValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRankValue rankValueProto) {
        super(serializationContext, Objects.requireNonNull(rankValueProto.getSuper()));
    }

    public RankValue(@Nonnull Iterable<? extends Value> partitioningValues, @Nonnull Iterable<? extends Value> argumentValues) {
        super(partitioningValues, argumentValues);
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return this.basePlanHash(mode, BASE_HASH, new Object[0]);
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(Type.TypeCode.LONG);
    }

    @Override
    @Nonnull
    public RankValue withChildren(Iterable<? extends Value> newChildren) {
        NonnullPair<List<Value>, List<Value>> childrenPair = this.splitNewChildren(newChildren);
        return new RankValue((Iterable)childrenPair.getKey(), (Iterable)childrenPair.getValue());
    }

    @Override
    @Nonnull
    public PRankValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRankValue.newBuilder().setSuper(this.toWindowedValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setRankValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RankValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRankValue rankValueProto) {
        return new RankValue(serializationContext, rankValueProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PRankValue, RankValue> {
        @Override
        @Nonnull
        public Class<PRankValue> getProtoMessageClass() {
            return PRankValue.class;
        }

        @Override
        @Nonnull
        public RankValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRankValue rankValueProto) {
            return RankValue.fromProto(serializationContext, rankValueProto);
        }
    }
}

