/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.TupleFieldsProto;
import com.apple.foundationdb.record.planprotos.PRecordConstructorValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.NullableArrayTypeUtils;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Accumulator;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.CreatesDynamicTypesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordConstructorValue
extends AbstractValue
implements AggregateValue,
CreatesDynamicTypesValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Constructor-Value");
    @Nonnull
    private final Type.Record resultType;
    @Nonnull
    protected final List<Column<? extends Value>> columns;
    @Nonnull
    private final Supplier<Integer> hashCodeWithoutChildrenSupplier;

    private RecordConstructorValue(@Nonnull Collection<Column<? extends Value>> columns, @Nonnull Type.Record resultType) {
        this.resultType = resultType;
        this.columns = ImmutableList.copyOf(columns);
        this.hashCodeWithoutChildrenSupplier = Suppliers.memoize(this::computeHashCodeWithoutChildren);
    }

    @Nonnull
    public List<Column<? extends Value>> getColumns() {
        return this.columns;
    }

    @Nonnull
    protected List<? extends Value> computeChildren() {
        return this.columns.stream().map(Column::getValue).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public Type.Record getResultType() {
        return this.resultType;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        TypeRepository typeRepository = context.getTypeRepository();
        DynamicMessage.Builder resultMessageBuilder = this.newMessageBuilderForType(typeRepository);
        Descriptors.Descriptor descriptorForType = resultMessageBuilder.getDescriptorForType();
        List<Descriptors.FieldDescriptor> fieldDescriptors = descriptorForType.getFields();
        List<Type.Record.Field> fields = Objects.requireNonNull(this.getResultType().getFields());
        int i = 0;
        for (Value value : this.getChildren()) {
            Type.Record.Field field = fields.get(i);
            Type fieldType = field.getFieldType();
            Object childResult = RecordConstructorValue.deepCopyIfNeeded(typeRepository, fieldType, value.eval(store, context));
            if (childResult != null) {
                Descriptors.FieldDescriptor fieldDescriptor = fieldDescriptors.get(i);
                if (fieldType.isArray() && fieldType.isNullable()) {
                    Descriptors.Descriptor wrappedDescriptor = fieldDescriptor.getMessageType();
                    DynamicMessage.Builder wrapperBuilder = DynamicMessage.newBuilder(wrappedDescriptor);
                    wrapperBuilder.setField(wrappedDescriptor.findFieldByName(NullableArrayTypeUtils.getRepeatedFieldName()), childResult);
                    childResult = wrapperBuilder.build();
                }
                resultMessageBuilder.setField(fieldDescriptor, childResult);
            } else {
                Verify.verify(fieldType.isNullable());
            }
            ++i;
        }
        return resultMessageBuilder.build();
    }

    @Nonnull
    private DynamicMessage.Builder newMessageBuilderForType(@Nonnull TypeRepository typeRepository) {
        return Objects.requireNonNull(typeRepository.newMessageBuilder(this.getResultType()));
    }

    @Nullable
    @VisibleForTesting
    public static Object deepCopyIfNeeded(@Nonnull TypeRepository typeRepository, @Nonnull Type fieldType, @Nullable Object field) {
        if (field == null) {
            return null;
        }
        if (fieldType.isPrimitive()) {
            return RecordConstructorValue.protoObjectForPrimitive(fieldType, field);
        }
        if (fieldType.isUuid()) {
            Verify.verify(field instanceof UUID);
            UUID uuidObject = (UUID)field;
            return TupleFieldsProto.UUID.newBuilder().setMostSignificantBits(uuidObject.getMostSignificantBits()).setLeastSignificantBits(uuidObject.getLeastSignificantBits()).build();
        }
        if (fieldType instanceof Type.Array) {
            List objects = (List)field;
            Type elementType = Verify.verifyNotNull(((Type.Array)fieldType).getElementType());
            if (elementType.isPrimitive()) {
                if (elementType.getTypeCode() == Type.TypeCode.BYTES || elementType.getTypeCode() == Type.TypeCode.VERSION) {
                    ImmutableList.Builder resultBuilder = ImmutableList.builderWithExpectedSize(objects.size());
                    for (Object object : objects) {
                        resultBuilder.add(RecordConstructorValue.protoObjectForPrimitive(elementType, object));
                    }
                    return resultBuilder.build();
                }
                return field;
            }
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            for (Object object : objects) {
                resultBuilder.add(Verify.verifyNotNull(RecordConstructorValue.deepCopyIfNeeded(typeRepository, elementType, object)));
            }
            return resultBuilder.build();
        }
        if (fieldType instanceof Type.Enum) {
            String typeName = typeRepository.getProtoTypeName(fieldType);
            return typeRepository.getEnumValue(typeName, ((Descriptors.EnumValueDescriptor)field).getName());
        }
        Verify.verify(fieldType instanceof Type.Record);
        Message message = (Message)field;
        Descriptors.Descriptor declaredDescriptor = Verify.verifyNotNull(typeRepository.getMessageDescriptor(fieldType));
        return MessageHelpers.deepCopyMessageIfNeeded(declaredDescriptor, message);
    }

    private static Object protoObjectForPrimitive(@Nonnull Type type, @Nonnull Object field) {
        if (type.getTypeCode() == Type.TypeCode.BYTES) {
            if (field instanceof byte[]) {
                return ZeroCopyByteString.wrap((byte[])field);
            }
        } else if (type.getTypeCode() == Type.TypeCode.VERSION) {
            return ZeroCopyByteString.wrap(((FDBRecordVersion)field).toBytes(false));
        }
        return field;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return this.hashCodeWithoutChildrenSupplier.get();
    }

    private int computeHashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, this.columns.stream().map(column -> column.getField().hashCode()).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.columns);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokens arguments = new ExplainTokens();
        int i = 0;
        Iterator<Supplier<ExplainTokensWithPrecedence>> iterator = explainSuppliers.iterator();
        while (iterator.hasNext()) {
            ExplainTokensWithPrecedence child = iterator.next().get();
            Column<? extends Value> column = this.columns.get(i);
            Type.Record.Field field = column.getField();
            if (field.getFieldNameOptional().isPresent()) {
                arguments.addNested(child.getExplainTokens()).addWhitespace().addKeyword("AS").addWhitespace().addToString(field.getFieldName());
            } else {
                arguments.addNested(child.getExplainTokens());
            }
            if (i + 1 < this.columns.size()) {
                arguments.addCommaAndWhiteSpace();
            }
            ++i;
        }
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addOpeningParen().addOptionalWhitespace().addNested(arguments).addOptionalWhitespace().addClosingParen());
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        if (this.hashCodeWithoutChildren() != other.hashCodeWithoutChildren()) {
            return ConstrainedBoolean.falseValue();
        }
        ConstrainedBoolean superEqualsWithoutChildren = super.equalsWithoutChildren(other);
        if (superEqualsWithoutChildren.isFalse()) {
            return ConstrainedBoolean.falseValue();
        }
        List<Column<? extends Value>> otherColumns = ((RecordConstructorValue)other).getColumns();
        Verify.verify(this.columns.size() == otherColumns.size());
        for (int i = 0; i < this.columns.size(); ++i) {
            Column<? extends Value> column = this.columns.get(i);
            Column<? extends Value> otherColumn = otherColumns.get(i);
            if (column.getField().equals(otherColumn.getField())) continue;
            return ConstrainedBoolean.falseValue();
        }
        return superEqualsWithoutChildren;
    }

    @Override
    @Nonnull
    public RecordConstructorValue withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(this.columns.size() == Iterables.size(newChildren));
        ImmutableList<Column<? extends Value>> newColumns = Streams.zip(StreamSupport.stream(newChildren.spliterator(), false), this.columns.stream(), (newChild, column) -> Column.of(column.getField(), newChild)).collect(ImmutableList.toImmutableList());
        return new RecordConstructorValue(newColumns, this.resultType);
    }

    @Override
    @Nullable
    public <M extends Message> Object evalToPartial(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        ArrayList<Object> listOfPartials = Lists.newArrayList();
        for (Value value : this.getChildren()) {
            Verify.verify(value instanceof AggregateValue);
            Object childResultElement = ((AggregateValue)value).evalToPartial(store, context);
            listOfPartials.add(childResultElement);
        }
        return Collections.unmodifiableList(listOfPartials);
    }

    @Override
    @Nonnull
    public Accumulator createAccumulatorWithInitialState(final @Nonnull TypeRepository typeRepository, final @Nullable List<RecordCursorProto.AccumulatorState> initialState) {
        return new Accumulator(){
            @Nonnull
            private final List<Accumulator> childAccumulators;
            {
                this.childAccumulators = this.buildAccumulators(initialState);
            }

            @Override
            public void accumulate(@Nullable Object currentObject) {
                if (currentObject == null) {
                    this.childAccumulators.forEach(childAccumulator -> childAccumulator.accumulate(null));
                } else {
                    Verify.verify(currentObject instanceof Collection);
                    List currentObjectAsList = (List)currentObject;
                    int i = 0;
                    for (Object o : currentObjectAsList) {
                        this.childAccumulators.get(i).accumulate(o);
                        ++i;
                    }
                }
            }

            @Override
            @Nonnull
            public Object finish() {
                DynamicMessage.Builder resultMessageBuilder = RecordConstructorValue.this.newMessageBuilderForType(typeRepository);
                Descriptors.Descriptor descriptorForType = resultMessageBuilder.getDescriptorForType();
                int i = 0;
                List<Type.Record.Field> fields = Objects.requireNonNull(RecordConstructorValue.this.getResultType().getFields());
                for (Accumulator childAccumulator : this.childAccumulators) {
                    Object finalResult = childAccumulator.finish();
                    if (finalResult != null) {
                        resultMessageBuilder.setField(descriptorForType.findFieldByNumber(fields.get(i).getFieldIndex()), finalResult);
                    }
                    ++i;
                }
                return resultMessageBuilder.build();
            }

            @Nonnull
            private List<Accumulator> buildAccumulators(@Nullable List<RecordCursorProto.AccumulatorState> initialState2) {
                ArrayList childrenAsList = new ArrayList();
                RecordConstructorValue.this.getChildren().forEach(childrenAsList::add);
                ImmutableList.Builder childAccumulatorsBuilder = ImmutableList.builder();
                if (initialState2 != null) {
                    Verify.verify(initialState2.size() == childrenAsList.size());
                }
                for (int i = 0; i < childrenAsList.size(); ++i) {
                    Verify.verify(childrenAsList.get(i) instanceof AggregateValue);
                    if (initialState2 == null) {
                        childAccumulatorsBuilder.add(((AggregateValue)childrenAsList.get(i)).createAccumulatorWithInitialState(typeRepository, null));
                        continue;
                    }
                    childAccumulatorsBuilder.add(((AggregateValue)childrenAsList.get(i)).createAccumulatorWithInitialState(typeRepository, List.of(initialState2.get(i))));
                }
                return childAccumulatorsBuilder.build();
            }

            @Override
            @Nonnull
            public List<RecordCursorProto.AccumulatorState> getAccumulatorStates() {
                ArrayList<RecordCursorProto.AccumulatorState> accumulatorStates = new ArrayList<RecordCursorProto.AccumulatorState>();
                for (Accumulator accumulator : this.childAccumulators) {
                    accumulatorStates.addAll(accumulator.getAccumulatorStates());
                }
                return accumulatorStates;
            }
        };
    }

    @Override
    @Nonnull
    public PRecordConstructorValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordConstructorValue.Builder builder = PRecordConstructorValue.newBuilder();
        for (Column<? extends Value> column : this.columns) {
            builder.addColumns(column.toProto(serializationContext));
        }
        builder.setResultType(this.resultType.toTypeProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        PRecordConstructorValue specificValueProto = this.toProto(serializationContext);
        return PValue.newBuilder().setRecordConstructorValue(specificValueProto).build();
    }

    @Nonnull
    public static RecordConstructorValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordConstructorValue recordConstructorValueProto) {
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (int i = 0; i < recordConstructorValueProto.getColumnsCount(); ++i) {
            PRecordConstructorValue.PColumn columnProto = recordConstructorValueProto.getColumns(i);
            columnsBuilder.add(Column.fromProto(serializationContext, columnProto));
        }
        ImmutableCollection columns = columnsBuilder.build();
        return new RecordConstructorValue(columns, (Type.Record)Type.fromTypeProto(serializationContext, Objects.requireNonNull(recordConstructorValueProto.getResultType())));
    }

    @Nonnull
    private static Type.Record computeResultType(@Nonnull Collection<Column<? extends Value>> columns, boolean isNullable) {
        ImmutableList<Type.Record.Field> fields = columns.stream().map(Column::getField).collect(ImmutableList.toImmutableList());
        return Type.Record.fromFields(isNullable, fields);
    }

    @Nonnull
    private static List<Column<? extends Value>> resolveColumns(@Nonnull Type.Record recordType, @Nonnull Collection<Column<? extends Value>> columns) {
        List<Type.Record.Field> fields = recordType.getFields();
        Verify.verify(fields.size() == columns.size());
        ImmutableList.Builder resolvedColumnsBuilder = ImmutableList.builder();
        Iterator<Column<? extends Value>> columnsIterator = columns.iterator();
        for (Type.Record.Field field : fields) {
            Column<? extends Value> column = columnsIterator.next();
            resolvedColumnsBuilder.add(Column.of(field, column.getValue()));
        }
        return resolvedColumnsBuilder.build();
    }

    @Nonnull
    public static RecordConstructorValue ofColumns(@Nonnull Collection<Column<? extends Value>> columns) {
        return RecordConstructorValue.ofColumnsAndResolvedType(columns, RecordConstructorValue.computeResultType(columns, false));
    }

    @Nonnull
    public static RecordConstructorValue ofColumns(@Nonnull Collection<Column<? extends Value>> columns, boolean isNullable) {
        return RecordConstructorValue.ofColumnsAndResolvedType(columns, RecordConstructorValue.computeResultType(columns, isNullable));
    }

    @Nonnull
    public static RecordConstructorValue ofColumnsAndName(@Nonnull Collection<Column<? extends Value>> columns, @Nonnull String name) {
        return RecordConstructorValue.ofColumnsAndResolvedType(columns, RecordConstructorValue.computeResultType(columns, false).withName(name));
    }

    @Nonnull
    private static RecordConstructorValue ofColumnsAndResolvedType(@Nonnull Collection<Column<? extends Value>> columns, @Nonnull Type.Record resolvedResultType) {
        return new RecordConstructorValue(RecordConstructorValue.resolveColumns(resolvedResultType, columns), resolvedResultType);
    }

    @Nonnull
    public static RecordConstructorValue ofUnnamed(@Nonnull Collection<? extends Value> arguments) {
        List columns = arguments.stream().map(Column::unnamedOf).collect(ImmutableList.toImmutableList());
        return RecordConstructorValue.ofColumns(columns);
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordConstructorValue, RecordConstructorValue> {
        @Override
        @Nonnull
        public Class<PRecordConstructorValue> getProtoMessageClass() {
            return PRecordConstructorValue.class;
        }

        @Override
        @Nonnull
        public RecordConstructorValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordConstructorValue recordConstructorValueProto) {
            return RecordConstructorValue.fromProto(serializationContext, recordConstructorValueProto);
        }
    }

    public static class RecordFn
    extends BuiltInFunction<Value> {
        public RecordFn() {
            super("record", ImmutableList.of(), new Type.Any(), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> RecordFn.encapsulateInternal(arguments));
        }

        @Nonnull
        private static Value encapsulateInternal(@Nonnull List<? extends Typed> arguments) {
            List namedArguments = arguments.stream().map(typed -> (Value)typed).map(Column::unnamedOf).collect(ImmutableList.toImmutableList());
            return RecordConstructorValue.ofColumns(namedArguments);
        }
    }
}

