/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PRecordTypeValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordTypeValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("RecordType-Value");
    @Nonnull
    private final Value in;

    public RecordTypeValue(@Nonnull Value in) {
        this.in = in;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object inRecord = this.in.eval(store, context);
        if (!(inRecord instanceof Message)) {
            return null;
        }
        return Objects.requireNonNull(store).getRecordMetaData().getRecordType(((Message)inRecord).getDescriptorForType().getName()).getRecordTypeKey();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.in);
    }

    @Override
    @Nonnull
    public Value withChildren(Iterable<? extends Value> newChildren) {
        return new RecordTypeValue(Iterables.getOnlyElement(newChildren));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, (Object)BASE_HASH);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(Type.TypeCode.LONG);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("recordType", Value.explainFunctionArguments(explainSuppliers)));
    }

    @Override
    @Nonnull
    public PRecordTypeValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordTypeValue.newBuilder().setIn(this.in.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setRecordTypeValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static RecordTypeValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordTypeValue recordTypeValueProto) {
        if (recordTypeValueProto.hasAlias()) {
            return new RecordTypeValue(QuantifiedObjectValue.of(CorrelationIdentifier.of(Objects.requireNonNull(recordTypeValueProto.getAlias())), new Type.AnyRecord(true)));
        }
        return new RecordTypeValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(recordTypeValueProto.getIn())));
    }

    public static class Deserializer
    implements PlanDeserializer<PRecordTypeValue, RecordTypeValue> {
        @Override
        @Nonnull
        public Class<PRecordTypeValue> getProtoMessageClass() {
            return PRecordTypeValue.class;
        }

        @Override
        @Nonnull
        public RecordTypeValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordTypeValue recordTypeValueProto) {
            return RecordTypeValue.fromProto(serializationContext, recordTypeValueProto);
        }
    }
}

