/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PBinaryRelOpValue;
import com.apple.foundationdb.record.planprotos.PRelOpValue;
import com.apple.foundationdb.record.planprotos.PUnaryRelOpValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BooleanValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class RelOpValue
extends AbstractValue
implements BooleanValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Rel-Op-Value");
    @Nonnull
    private final String functionName;
    @Nonnull
    private final Comparisons.Type comparisonType;
    @Nonnull
    private final Iterable<? extends Value> children;
    @Nonnull
    private static final Supplier<Map<UnaryComparisonSignature, UnaryPhysicalOperator>> unaryOperatorMapSupplier = Suppliers.memoize(RelOpValue::computeUnaryOperatorMap);
    @Nonnull
    private static final Supplier<Map<BinaryComparisonSignature, BinaryPhysicalOperator>> binaryOperatorMapSupplier = Suppliers.memoize(RelOpValue::computeBinaryOperatorMap);

    protected RelOpValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRelOpValue relOpValueProto) {
        this(Objects.requireNonNull(relOpValueProto.getFunctionName()), Comparisons.Type.fromProto(serializationContext, Objects.requireNonNull(relOpValueProto.getComparisonType())), relOpValueProto.getChildrenList().stream().map(valueProto -> Value.fromValueProto(serializationContext, valueProto)).collect(ImmutableList.toImmutableList()));
    }

    protected RelOpValue(@Nonnull String functionName, @Nonnull Comparisons.Type comparisonType, @Nonnull Iterable<? extends Value> children) {
        Verify.verify(!Iterables.isEmpty(children));
        this.functionName = functionName;
        this.comparisonType = comparisonType;
        this.children = children;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return this.children;
    }

    @Nonnull
    public String getFunctionName() {
        return this.functionName;
    }

    @Nonnull
    public Comparisons.Type getComparisonType() {
        return this.comparisonType;
    }

    @Override
    public Optional<QueryPredicate> toQueryPredicate(@Nullable TypeRepository typeRepository, @Nonnull Set<CorrelationIdentifier> localAliases) {
        Iterator<? extends Value> it = this.children.iterator();
        int childrenCount = Iterables.size(this.children);
        if (childrenCount == 1) {
            Value child = this.children.iterator().next();
            if (child.getCorrelatedTo().isEmpty() && typeRepository != null) {
                return this.tryBoxSelfAsConstantPredicate(typeRepository);
            }
            return Optional.of(new ValuePredicate(child, new Comparisons.NullComparison(this.comparisonType)));
        }
        if (childrenCount == 2) {
            Value leftChild = it.next();
            Value rightChild = it.next();
            Set<CorrelationIdentifier> leftChildCorrelatedTo = leftChild.getCorrelatedTo();
            Set<CorrelationIdentifier> rightChildCorrelatedTo = rightChild.getCorrelatedTo();
            if (leftChildCorrelatedTo.isEmpty() && rightChildCorrelatedTo.isEmpty() && typeRepository != null) {
                return this.tryBoxSelfAsConstantPredicate(typeRepository);
            }
            if (localAliases.containsAll(rightChildCorrelatedTo)) {
                if (localAliases.stream().noneMatch(leftChildCorrelatedTo::contains)) {
                    return RelOpValue.promoteOperandsAndCreatePredicate(leftChildCorrelatedTo.isEmpty() ? typeRepository : null, rightChild, leftChild, RelOpValue.swapBinaryComparisonOperator(this.comparisonType));
                }
            }
            return RelOpValue.promoteOperandsAndCreatePredicate(rightChildCorrelatedTo.isEmpty() ? typeRepository : null, leftChild, rightChild, this.comparisonType);
        }
        return Optional.empty();
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static Optional<QueryPredicate> promoteOperandsAndCreatePredicate(@Nullable TypeRepository typeRepository, @Nonnull Value leftChild, @Nonnull Value rightChild, @Nonnull Comparisons.Type comparisonType) {
        Type maxtype = Verify.verifyNotNull(Type.maximumType(leftChild.getResultType(), rightChild.getResultType()));
        leftChild = PromoteValue.inject(leftChild, maxtype);
        rightChild = PromoteValue.inject(rightChild, maxtype);
        if (typeRepository != null) {
            Object comparand = rightChild.evalWithoutStore(EvaluationContext.forTypeRepository(typeRepository));
            return comparand == null ? Optional.of(new ConstantPredicate((Boolean)false)) : Optional.of(new ValuePredicate(leftChild, new Comparisons.SimpleComparison(comparisonType, comparand)));
        }
        return Optional.of(new ValuePredicate(leftChild, new Comparisons.ValueComparison(comparisonType, rightChild)));
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private Optional<QueryPredicate> tryBoxSelfAsConstantPredicate(@Nonnull TypeRepository typeRepository) {
        Object constantValue = this.evalWithoutStore(EvaluationContext.forTypeRepository(typeRepository));
        if (constantValue instanceof Boolean) {
            if (((Boolean)constantValue).booleanValue()) {
                return Optional.of(ConstantPredicate.TRUE);
            }
            return Optional.of(ConstantPredicate.FALSE);
        }
        if (constantValue == null) {
            return Optional.of(ConstantPredicate.NULL);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Nonnull
    public PRelOpValue toRelOpValueProto(@Nonnull PlanSerializationContext serializationContext) {
        PRelOpValue.Builder builder = PRelOpValue.newBuilder();
        builder.setFunctionName(this.functionName);
        builder.setComparisonType(this.comparisonType.toProto(serializationContext));
        for (Value value : this.children) {
            builder.addChildren(value.toValueProto(serializationContext));
        }
        return builder.build();
    }

    @Nonnull
    private static Comparisons.Type swapBinaryComparisonOperator(@Nonnull Comparisons.Type type) {
        switch (type) {
            case EQUALS: 
            case NOT_EQUALS: 
            case NOT_DISTINCT_FROM: 
            case IS_DISTINCT_FROM: {
                return type;
            }
            case LESS_THAN: {
                return Comparisons.Type.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUALS: {
                return Comparisons.Type.GREATER_THAN_OR_EQUALS;
            }
            case GREATER_THAN: {
                return Comparisons.Type.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUALS: {
                return Comparisons.Type.LESS_THAN_OR_EQUALS;
            }
        }
        throw new IllegalArgumentException("cannot swap comparison " + String.valueOf((Object)type));
    }

    @Nonnull
    private static Value encapsulate(@Nonnull String functionName, @Nonnull Comparisons.Type comparisonType, @Nonnull List<? extends Typed> arguments) {
        Verify.verify(arguments.size() == 1 || arguments.size() == 2);
        Typed arg0 = arguments.get(0);
        Type res0 = arg0.getResultType();
        SemanticException.check(res0.isPrimitive() || res0.isEnum() || res0.isUuid(), SemanticException.ErrorCode.COMPARAND_TO_COMPARISON_IS_OF_COMPLEX_TYPE);
        if (arguments.size() == 1) {
            UnaryPhysicalOperator physicalOperator = RelOpValue.getUnaryOperatorMap().get(new UnaryComparisonSignature(comparisonType, res0.getTypeCode()));
            Verify.verifyNotNull(physicalOperator, "unable to encapsulate comparison operation due to type mismatch(es)", new Object[0]);
            return new UnaryRelOpValue(functionName, comparisonType, arguments.stream().map(Value.class::cast).collect(Collectors.toList()), physicalOperator);
        }
        Typed arg1 = arguments.get(1);
        Type res1 = arg1.getResultType();
        SemanticException.check(res1.isPrimitive() || res1.isEnum() || res1.isUuid(), SemanticException.ErrorCode.COMPARAND_TO_COMPARISON_IS_OF_COMPLEX_TYPE);
        BinaryPhysicalOperator physicalOperator = RelOpValue.getBinaryOperatorMap().get(new BinaryComparisonSignature(comparisonType, res0.getTypeCode(), res1.getTypeCode()));
        Verify.verifyNotNull(physicalOperator, "unable to encapsulate comparison operation due to type mismatch(es)", new Object[0]);
        return new BinaryRelOpValue(functionName, comparisonType, arguments.stream().map(Value.class::cast).collect(Collectors.toList()), physicalOperator);
    }

    @Nonnull
    private static Map<UnaryComparisonSignature, UnaryPhysicalOperator> computeUnaryOperatorMap() {
        ImmutableMap.Builder<UnaryComparisonSignature, UnaryPhysicalOperator> mapBuilder = ImmutableMap.builder();
        for (UnaryPhysicalOperator operator : UnaryPhysicalOperator.values()) {
            mapBuilder.put(new UnaryComparisonSignature(operator.getType(), operator.getArgType()), operator);
        }
        return mapBuilder.build();
    }

    @Nonnull
    private static Map<UnaryComparisonSignature, UnaryPhysicalOperator> getUnaryOperatorMap() {
        return unaryOperatorMapSupplier.get();
    }

    private static Map<BinaryComparisonSignature, BinaryPhysicalOperator> computeBinaryOperatorMap() {
        ImmutableMap.Builder<BinaryComparisonSignature, BinaryPhysicalOperator> mapBuilder = ImmutableMap.builder();
        for (BinaryPhysicalOperator operator : BinaryPhysicalOperator.values()) {
            mapBuilder.put(new BinaryComparisonSignature(operator.getType(), operator.getLeftArgType(), operator.getRightArgType()), operator);
        }
        return mapBuilder.build();
    }

    @Nonnull
    private static Map<BinaryComparisonSignature, BinaryPhysicalOperator> getBinaryOperatorMap() {
        return binaryOperatorMapSupplier.get();
    }

    static final class UnaryComparisonSignature {
        @Nonnull
        private final Comparisons.Type comparisonType;
        @Nonnull
        private final Type.TypeCode argumentType;

        UnaryComparisonSignature(@Nonnull Comparisons.Type comparisonType, @Nonnull Type.TypeCode argumentType) {
            this.comparisonType = comparisonType;
            this.argumentType = argumentType;
        }

        @Nonnull
        public Comparisons.Type getComparisonType() {
            return this.comparisonType;
        }

        @Nonnull
        public Type.TypeCode getArgumentType() {
            return this.argumentType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnaryComparisonSignature that = (UnaryComparisonSignature)o;
            return this.comparisonType == that.comparisonType && this.argumentType == that.argumentType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.comparisonType, this.argumentType});
        }

        public String toString() {
            return String.valueOf((Object)this.comparisonType) + "(" + String.valueOf((Object)this.argumentType) + ")";
        }
    }

    private static enum UnaryPhysicalOperator {
        IS_NULL_UI(Comparisons.Type.IS_NULL, Type.TypeCode.UNKNOWN, Objects::isNull),
        IS_NULL_II(Comparisons.Type.IS_NULL, Type.TypeCode.INT, Objects::isNull),
        IS_NULL_LI(Comparisons.Type.IS_NULL, Type.TypeCode.LONG, Objects::isNull),
        IS_NULL_FI(Comparisons.Type.IS_NULL, Type.TypeCode.FLOAT, Objects::isNull),
        IS_NULL_DI(Comparisons.Type.IS_NULL, Type.TypeCode.DOUBLE, Objects::isNull),
        IS_NULL_SS(Comparisons.Type.IS_NULL, Type.TypeCode.STRING, Objects::isNull),
        IS_NULL_BI(Comparisons.Type.IS_NULL, Type.TypeCode.BOOLEAN, Objects::isNull),
        IS_NOT_NULL_UI(Comparisons.Type.NOT_NULL, Type.TypeCode.UNKNOWN, Objects::nonNull),
        IS_NOT_NULL_II(Comparisons.Type.NOT_NULL, Type.TypeCode.INT, Objects::nonNull),
        IS_NOT_NULL_LI(Comparisons.Type.NOT_NULL, Type.TypeCode.LONG, Objects::nonNull),
        IS_NOT_NULL_FI(Comparisons.Type.NOT_NULL, Type.TypeCode.FLOAT, Objects::nonNull),
        IS_NOT_NULL_DI(Comparisons.Type.NOT_NULL, Type.TypeCode.DOUBLE, Objects::nonNull),
        IS_NOT_NULL_SS(Comparisons.Type.NOT_NULL, Type.TypeCode.STRING, Objects::nonNull),
        IS_NOT_NULL_BI(Comparisons.Type.NOT_NULL, Type.TypeCode.BOOLEAN, Objects::nonNull),
        IS_NULL_BY(Comparisons.Type.IS_NULL, Type.TypeCode.BYTES, Objects::isNull),
        IS_NOT_NULL_BY(Comparisons.Type.NOT_NULL, Type.TypeCode.BYTES, Objects::nonNull),
        IS_NULL_EI(Comparisons.Type.IS_NULL, Type.TypeCode.ENUM, Objects::isNull),
        IS_NOT_NULL_EI(Comparisons.Type.NOT_NULL, Type.TypeCode.ENUM, Objects::nonNull),
        IS_NULL_ID(Comparisons.Type.IS_NULL, Type.TypeCode.UUID, Objects::isNull),
        IS_NOT_NULL_ID(Comparisons.Type.NOT_NULL, Type.TypeCode.UUID, Objects::nonNull),
        IS_NULL_NT(Comparisons.Type.IS_NULL, Type.TypeCode.NULL, Objects::isNull),
        IS_NOT_NULL_NT(Comparisons.Type.NOT_NULL, Type.TypeCode.NULL, Objects::nonNull);

        @Nonnull
        private static final Supplier<BiMap<UnaryPhysicalOperator, PUnaryRelOpValue.PUnaryPhysicalOperator>> protoEnumBiMapSupplier;
        @Nonnull
        private final Comparisons.Type type;
        @Nonnull
        private final Type.TypeCode argType;
        @Nonnull
        private final UnaryOperator<Object> evaluateFunction;

        private UnaryPhysicalOperator(@Nonnull Comparisons.Type type, Type.TypeCode argType, UnaryOperator<Object> evaluateFunction) {
            this.type = type;
            this.argType = argType;
            this.evaluateFunction = evaluateFunction;
        }

        @Nullable
        public Object eval(@Nullable Object arg1) {
            return this.evaluateFunction.apply(arg1);
        }

        @Nonnull
        public Comparisons.Type getType() {
            return this.type;
        }

        @Nonnull
        public Type.TypeCode getArgType() {
            return this.argType;
        }

        @Nonnull
        public PUnaryRelOpValue.PUnaryPhysicalOperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            return Objects.requireNonNull((PUnaryRelOpValue.PUnaryPhysicalOperator)UnaryPhysicalOperator.getProtoEnumBiMap().get((Object)this));
        }

        @Nonnull
        public static UnaryPhysicalOperator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PUnaryRelOpValue.PUnaryPhysicalOperator unaryPhysicalOperator) {
            return Objects.requireNonNull((UnaryPhysicalOperator)((Object)UnaryPhysicalOperator.getProtoEnumBiMap().inverse().get(unaryPhysicalOperator)));
        }

        @Nonnull
        private static BiMap<UnaryPhysicalOperator, PUnaryRelOpValue.PUnaryPhysicalOperator> getProtoEnumBiMap() {
            return protoEnumBiMapSupplier.get();
        }

        static {
            protoEnumBiMapSupplier = Suppliers.memoize(() -> PlanSerialization.protoEnumBiMap(UnaryPhysicalOperator.class, PUnaryRelOpValue.PUnaryPhysicalOperator.class));
        }
    }

    public static class UnaryRelOpValue
    extends RelOpValue {
        @Nonnull
        private final UnaryPhysicalOperator operator;

        private UnaryRelOpValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PUnaryRelOpValue unaryRelOpValueProto) {
            super(serializationContext, Objects.requireNonNull(unaryRelOpValueProto.getSuper()));
            this.operator = UnaryPhysicalOperator.fromProto(serializationContext, Objects.requireNonNull(unaryRelOpValueProto.getOperator()));
        }

        private UnaryRelOpValue(@Nonnull String functionName, @Nonnull Comparisons.Type comparisonType, @Nonnull Iterable<? extends Value> children, @Nonnull UnaryPhysicalOperator operator) {
            super(functionName, comparisonType, children);
            this.operator = operator;
        }

        @Override
        @Nonnull
        public RelOpValue withChildren(Iterable<? extends Value> newChildren) {
            Verify.verify(Iterables.size(newChildren) == 1);
            return new UnaryRelOpValue(this.getFunctionName(), this.getComparisonType(), newChildren, this.operator);
        }

        @Override
        public int hashCodeWithoutChildren() {
            return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.getComparisonType(), this.operator});
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.getComparisonType(), StreamSupport.stream(this.getChildren().spliterator(), false).toArray(Value[]::new)});
        }

        @Override
        @Nullable
        public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
            Iterator evaluatedChildrenIterator = Streams.stream(this.getChildren()).map(child -> child.eval(store, context)).iterator();
            return this.operator.eval(evaluatedChildrenIterator.next());
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
            ExplainTokensWithPrecedence onlyChild = Iterables.getOnlyElement(explainSuppliers).get();
            return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.UNARY_MINUS_BITWISE_NOT, new ExplainTokens().addToString(this.getFunctionName()).addNested(ExplainTokensWithPrecedence.Precedence.UNARY_MINUS_BITWISE_NOT.parenthesizeChild(onlyChild)));
        }

        @Override
        @Nonnull
        public PUnaryRelOpValue toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PUnaryRelOpValue.newBuilder().setSuper(this.toRelOpValueProto(serializationContext)).setOperator(this.operator.toProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setUnaryRelOpValue(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static UnaryRelOpValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PUnaryRelOpValue unaryRelOpValueProto) {
            return new UnaryRelOpValue(serializationContext, unaryRelOpValueProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PUnaryRelOpValue, UnaryRelOpValue> {
            @Override
            @Nonnull
            public Class<PUnaryRelOpValue> getProtoMessageClass() {
                return PUnaryRelOpValue.class;
            }

            @Override
            @Nonnull
            public UnaryRelOpValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PUnaryRelOpValue unaryRelOpValueProto) {
                return UnaryRelOpValue.fromProto(serializationContext, unaryRelOpValueProto);
            }
        }
    }

    static final class BinaryComparisonSignature {
        @Nonnull
        private final Comparisons.Type comparisonType;
        @Nonnull
        private final Type.TypeCode leftType;
        @Nonnull
        private final Type.TypeCode rightType;

        BinaryComparisonSignature(@Nonnull Comparisons.Type comparisonType, @Nonnull Type.TypeCode leftType, @Nonnull Type.TypeCode rightType) {
            this.comparisonType = comparisonType;
            this.leftType = leftType;
            this.rightType = rightType;
        }

        @Nonnull
        public Comparisons.Type getComparisonType() {
            return this.comparisonType;
        }

        @Nonnull
        public Type.TypeCode getLeftType() {
            return this.leftType;
        }

        @Nonnull
        public Type.TypeCode getRightType() {
            return this.rightType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinaryComparisonSignature that = (BinaryComparisonSignature)o;
            return this.comparisonType == that.comparisonType && this.leftType == that.leftType && this.rightType == that.rightType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.comparisonType, this.leftType, this.rightType});
        }

        public String toString() {
            return String.valueOf((Object)this.comparisonType) + "(" + String.valueOf((Object)this.leftType) + ", " + String.valueOf((Object)this.rightType) + ")";
        }
    }

    private static enum BinaryPhysicalOperator {
        EQ_BU(Comparisons.Type.EQUALS, Type.TypeCode.BOOLEAN, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_BB(Comparisons.Type.EQUALS, Type.TypeCode.BOOLEAN, Type.TypeCode.BOOLEAN, (l, r) -> ((Boolean)l).booleanValue() == ((Boolean)r).booleanValue()),
        EQ_IU(Comparisons.Type.EQUALS, Type.TypeCode.INT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_II(Comparisons.Type.EQUALS, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> ((Integer)l).intValue() == ((Integer)r).intValue()),
        EQ_IL(Comparisons.Type.EQUALS, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() == (Long)r),
        EQ_IF(Comparisons.Type.EQUALS, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> (float)((Integer)l).intValue() == ((Float)r).floatValue()),
        EQ_ID(Comparisons.Type.EQUALS, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() == (Double)r),
        EQ_LU(Comparisons.Type.EQUALS, Type.TypeCode.LONG, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_LI(Comparisons.Type.EQUALS, Type.TypeCode.LONG, Type.TypeCode.INT, (l, r) -> (Long)l == (long)((Integer)r).intValue()),
        EQ_LL(Comparisons.Type.EQUALS, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> ((Long)l).longValue() == ((Long)r).longValue()),
        EQ_LF(Comparisons.Type.EQUALS, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> (float)((Long)l).longValue() == ((Float)r).floatValue()),
        EQ_LD(Comparisons.Type.EQUALS, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() == (Double)r),
        EQ_FU(Comparisons.Type.EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_FI(Comparisons.Type.EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.INT, (l, r) -> ((Float)l).floatValue() == (float)((Integer)r).intValue()),
        EQ_FL(Comparisons.Type.EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.LONG, (l, r) -> ((Float)l).floatValue() == (float)((Long)r).longValue()),
        EQ_FF(Comparisons.Type.EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> ((Float)l).floatValue() == ((Float)r).floatValue()),
        EQ_FD(Comparisons.Type.EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() == (Double)r),
        EQ_DU(Comparisons.Type.EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_DI(Comparisons.Type.EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.INT, (l, r) -> (Double)l == (double)((Integer)r).intValue()),
        EQ_DL(Comparisons.Type.EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, (l, r) -> (Double)l == (double)((Long)r).longValue()),
        EQ_DF(Comparisons.Type.EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, (l, r) -> (Double)l == (double)((Float)r).floatValue()),
        EQ_DD(Comparisons.Type.EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> ((Double)l).doubleValue() == ((Double)r).doubleValue()),
        EQ_SU(Comparisons.Type.EQUALS, Type.TypeCode.STRING, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_SS(Comparisons.Type.EQUALS, Type.TypeCode.STRING, Type.TypeCode.STRING, Object::equals),
        EQ_UU(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_UB(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.BOOLEAN, (l, r) -> null),
        EQ_UI(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.INT, (l, r) -> null),
        EQ_UL(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.LONG, (l, r) -> null),
        EQ_UF(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.FLOAT, (l, r) -> null),
        EQ_UD(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.DOUBLE, (l, r) -> null),
        EQ_US(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.STRING, (l, r) -> null),
        EQ_UV(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.VERSION, (l, r) -> null),
        EQ_VU(Comparisons.Type.EQUALS, Type.TypeCode.VERSION, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_VV(Comparisons.Type.EQUALS, Type.TypeCode.VERSION, Type.TypeCode.VERSION, Object::equals),
        NEQ_BU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.BOOLEAN, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_BB(Comparisons.Type.NOT_EQUALS, Type.TypeCode.BOOLEAN, Type.TypeCode.BOOLEAN, (l, r) -> ((Boolean)l).booleanValue() != ((Boolean)r).booleanValue()),
        NEQ_IU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.INT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_II(Comparisons.Type.NOT_EQUALS, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> ((Integer)l).intValue() != ((Integer)r).intValue()),
        NEQ_IL(Comparisons.Type.NOT_EQUALS, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() != (Long)r),
        NEQ_IF(Comparisons.Type.NOT_EQUALS, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> (float)((Integer)l).intValue() != ((Float)r).floatValue()),
        NEQ_ID(Comparisons.Type.NOT_EQUALS, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() != (Double)r),
        NEQ_LU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.LONG, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_LI(Comparisons.Type.NOT_EQUALS, Type.TypeCode.LONG, Type.TypeCode.INT, (l, r) -> (Long)l != (long)((Integer)r).intValue()),
        NEQ_LL(Comparisons.Type.NOT_EQUALS, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> ((Long)l).longValue() != ((Long)r).longValue()),
        NEQ_LF(Comparisons.Type.NOT_EQUALS, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> (float)((Long)l).longValue() != ((Float)r).floatValue()),
        NEQ_LD(Comparisons.Type.NOT_EQUALS, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() != (Double)r),
        NEQ_FU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_FI(Comparisons.Type.NOT_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.INT, (l, r) -> ((Float)l).floatValue() != (float)((Integer)r).intValue()),
        NEQ_FL(Comparisons.Type.NOT_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.LONG, (l, r) -> ((Float)l).floatValue() != (float)((Long)r).longValue()),
        NEQ_FF(Comparisons.Type.NOT_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> ((Float)l).floatValue() != ((Float)r).floatValue()),
        NEQ_FD(Comparisons.Type.NOT_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() != (Double)r),
        NEQ_DU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_DI(Comparisons.Type.NOT_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.INT, (l, r) -> (Double)l != (double)((Integer)r).intValue()),
        NEQ_DL(Comparisons.Type.NOT_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, (l, r) -> (Double)l != (double)((Long)r).longValue()),
        NEQ_DF(Comparisons.Type.NOT_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, (l, r) -> (Double)l != (double)((Float)r).floatValue()),
        NEQ_DD(Comparisons.Type.NOT_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> ((Double)l).doubleValue() != ((Double)r).doubleValue()),
        NEQ_SU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.STRING, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_SS(Comparisons.Type.NOT_EQUALS, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> !l.equals(r)),
        NEQ_UU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_UB(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.BOOLEAN, (l, r) -> null),
        NEQ_UI(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.INT, (l, r) -> null),
        NEQ_UL(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.LONG, (l, r) -> null),
        NEQ_UF(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.FLOAT, (l, r) -> null),
        NEQ_UD(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.DOUBLE, (l, r) -> null),
        NEQ_US(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.STRING, (l, r) -> null),
        NEQ_UV(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.VERSION, (l, r) -> null),
        NEQ_VU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_VV(Comparisons.Type.NOT_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.VERSION, (l, r) -> !l.equals(r)),
        LT_IU(Comparisons.Type.LESS_THAN, Type.TypeCode.INT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_II(Comparisons.Type.LESS_THAN, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l < (Integer)r),
        LT_IL(Comparisons.Type.LESS_THAN, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() < (Long)r),
        LT_IF(Comparisons.Type.LESS_THAN, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> (float)((Integer)l).intValue() < ((Float)r).floatValue()),
        LT_ID(Comparisons.Type.LESS_THAN, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() < (Double)r),
        LT_LU(Comparisons.Type.LESS_THAN, Type.TypeCode.LONG, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_LI(Comparisons.Type.LESS_THAN, Type.TypeCode.LONG, Type.TypeCode.INT, (l, r) -> (Long)l < (long)((Integer)r).intValue()),
        LT_LL(Comparisons.Type.LESS_THAN, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l < (Long)r),
        LT_LF(Comparisons.Type.LESS_THAN, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> (float)((Long)l).longValue() < ((Float)r).floatValue()),
        LT_LD(Comparisons.Type.LESS_THAN, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() < (Double)r),
        LT_FU(Comparisons.Type.LESS_THAN, Type.TypeCode.FLOAT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_FI(Comparisons.Type.LESS_THAN, Type.TypeCode.FLOAT, Type.TypeCode.INT, (l, r) -> ((Float)l).floatValue() < (float)((Integer)r).intValue()),
        LT_FL(Comparisons.Type.LESS_THAN, Type.TypeCode.FLOAT, Type.TypeCode.LONG, (l, r) -> ((Float)l).floatValue() < (float)((Long)r).longValue()),
        LT_FF(Comparisons.Type.LESS_THAN, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> ((Float)l).floatValue() < ((Float)r).floatValue()),
        LT_FD(Comparisons.Type.LESS_THAN, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() < (Double)r),
        LT_DU(Comparisons.Type.LESS_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_DI(Comparisons.Type.LESS_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.INT, (l, r) -> (Double)l < (double)((Integer)r).intValue()),
        LT_DL(Comparisons.Type.LESS_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, (l, r) -> (Double)l < (double)((Long)r).longValue()),
        LT_DF(Comparisons.Type.LESS_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, (l, r) -> (Double)l < (double)((Float)r).floatValue()),
        LT_DD(Comparisons.Type.LESS_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l < (Double)r),
        LT_SU(Comparisons.Type.LESS_THAN, Type.TypeCode.STRING, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_SS(Comparisons.Type.LESS_THAN, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> ((String)l).compareTo((String)r) < 0),
        LT_UU(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_UB(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.BOOLEAN, (l, r) -> null),
        LT_UI(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.INT, (l, r) -> null),
        LT_UL(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.LONG, (l, r) -> null),
        LT_UF(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.FLOAT, (l, r) -> null),
        LT_UD(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.DOUBLE, (l, r) -> null),
        LT_US(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.STRING, (l, r) -> null),
        LT_UV(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.VERSION, (l, r) -> null),
        LT_VU(Comparisons.Type.LESS_THAN, Type.TypeCode.VERSION, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_VV(Comparisons.Type.LESS_THAN, Type.TypeCode.VERSION, Type.TypeCode.VERSION, (l, r) -> ((FDBRecordVersion)l).compareTo((FDBRecordVersion)r) < 0),
        LTE_IU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_II(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l <= (Integer)r),
        LTE_IL(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() <= (Long)r),
        LTE_IF(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> (float)((Integer)l).intValue() <= ((Float)r).floatValue()),
        LTE_ID(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() <= (Double)r),
        LTE_LU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_LI(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.INT, (l, r) -> (Long)l <= (long)((Integer)r).intValue()),
        LTE_LL(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l <= (Long)r),
        LTE_LF(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> (float)((Long)l).longValue() <= ((Float)r).floatValue()),
        LTE_LD(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() <= (Double)r),
        LTE_FU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_FI(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.INT, (l, r) -> ((Float)l).floatValue() <= (float)((Integer)r).intValue()),
        LTE_FL(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.LONG, (l, r) -> ((Float)l).floatValue() <= (float)((Long)r).longValue()),
        LTE_FF(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> ((Float)l).floatValue() <= ((Float)r).floatValue()),
        LTE_FD(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() <= (Double)r),
        LTE_DU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_DI(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.INT, (l, r) -> (Double)l <= (double)((Integer)r).intValue()),
        LTE_DL(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, (l, r) -> (Double)l <= (double)((Long)r).longValue()),
        LTE_DF(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, (l, r) -> (Double)l <= (double)((Float)r).floatValue()),
        LTE_DD(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l <= (Double)r),
        LTE_SU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_SS(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> ((String)l).compareTo((String)r) <= 0),
        LTE_UU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_UB(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.BOOLEAN, (l, r) -> null),
        LTE_UI(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.INT, (l, r) -> null),
        LTE_UL(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.LONG, (l, r) -> null),
        LTE_UF(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.FLOAT, (l, r) -> null),
        LTE_UD(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.DOUBLE, (l, r) -> null),
        LTE_US(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.STRING, (l, r) -> null),
        LTE_UV(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.VERSION, (l, r) -> null),
        LTE_VU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_VV(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.VERSION, (l, r) -> ((FDBRecordVersion)l).compareTo((FDBRecordVersion)r) <= 0),
        GT_IU(Comparisons.Type.GREATER_THAN, Type.TypeCode.INT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_II(Comparisons.Type.GREATER_THAN, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l > (Integer)r),
        GT_IL(Comparisons.Type.GREATER_THAN, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() > (Long)r),
        GT_IF(Comparisons.Type.GREATER_THAN, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> (float)((Integer)l).intValue() > ((Float)r).floatValue()),
        GT_ID(Comparisons.Type.GREATER_THAN, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() > (Double)r),
        GT_LU(Comparisons.Type.GREATER_THAN, Type.TypeCode.LONG, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_LI(Comparisons.Type.GREATER_THAN, Type.TypeCode.LONG, Type.TypeCode.INT, (l, r) -> (Long)l > (long)((Integer)r).intValue()),
        GT_LL(Comparisons.Type.GREATER_THAN, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l > (Long)r),
        GT_LF(Comparisons.Type.GREATER_THAN, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> (float)((Long)l).longValue() > ((Float)r).floatValue()),
        GT_LD(Comparisons.Type.GREATER_THAN, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() > (Double)r),
        GT_FU(Comparisons.Type.GREATER_THAN, Type.TypeCode.FLOAT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_FI(Comparisons.Type.GREATER_THAN, Type.TypeCode.FLOAT, Type.TypeCode.INT, (l, r) -> ((Float)l).floatValue() > (float)((Integer)r).intValue()),
        GT_FL(Comparisons.Type.GREATER_THAN, Type.TypeCode.FLOAT, Type.TypeCode.LONG, (l, r) -> ((Float)l).floatValue() > (float)((Long)r).longValue()),
        GT_FF(Comparisons.Type.GREATER_THAN, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> ((Float)l).floatValue() > ((Float)r).floatValue()),
        GT_FD(Comparisons.Type.GREATER_THAN, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() > (Double)r),
        GT_DU(Comparisons.Type.GREATER_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_DI(Comparisons.Type.GREATER_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.INT, (l, r) -> (Double)l > (double)((Integer)r).intValue()),
        GT_DL(Comparisons.Type.GREATER_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, (l, r) -> (Double)l > (double)((Long)r).longValue()),
        GT_DF(Comparisons.Type.GREATER_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, (l, r) -> (Double)l > (double)((Float)r).floatValue()),
        GT_DD(Comparisons.Type.GREATER_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l > (Double)r),
        GT_SU(Comparisons.Type.GREATER_THAN, Type.TypeCode.STRING, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_SS(Comparisons.Type.GREATER_THAN, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> ((String)l).compareTo((String)r) > 0),
        GT_UU(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_UB(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.BOOLEAN, (l, r) -> null),
        GT_UI(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.INT, (l, r) -> null),
        GT_UL(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.LONG, (l, r) -> null),
        GT_UF(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.FLOAT, (l, r) -> null),
        GT_UD(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.DOUBLE, (l, r) -> null),
        GT_US(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.STRING, (l, r) -> null),
        GT_UV(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.VERSION, (l, r) -> null),
        GT_VU(Comparisons.Type.GREATER_THAN, Type.TypeCode.VERSION, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_VV(Comparisons.Type.GREATER_THAN, Type.TypeCode.VERSION, Type.TypeCode.VERSION, (l, r) -> ((FDBRecordVersion)l).compareTo((FDBRecordVersion)r) > 0),
        GTE_IU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_II(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> (Integer)l >= (Integer)r),
        GTE_IL(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() >= (Long)r),
        GTE_IF(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> (float)((Integer)l).intValue() >= ((Float)r).floatValue()),
        GTE_ID(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() >= (Double)r),
        GTE_LU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_LI(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.INT, (l, r) -> (Long)l >= (long)((Integer)r).intValue()),
        GTE_LL(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> (Long)l >= (Long)r),
        GTE_LF(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> (float)((Long)l).longValue() >= ((Float)r).floatValue()),
        GTE_LD(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() >= (Double)r),
        GTE_FU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_FI(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.INT, (l, r) -> ((Float)l).floatValue() >= (float)((Integer)r).intValue()),
        GTE_FL(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.LONG, (l, r) -> ((Float)l).floatValue() >= (float)((Long)r).longValue()),
        GTE_FF(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> ((Float)l).floatValue() >= ((Float)r).floatValue()),
        GTE_FD(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() >= (Double)r),
        GTE_DU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_DI(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.INT, (l, r) -> (Double)l >= (double)((Integer)r).intValue()),
        GTE_DL(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, (l, r) -> (Double)l >= (double)((Long)r).longValue()),
        GTE_DF(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, (l, r) -> (Double)l >= (double)((Float)r).floatValue()),
        GTE_DD(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> (Double)l >= (Double)r),
        GTE_SU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_SS(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> ((String)l).compareTo((String)r) >= 0),
        GTE_UU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_UB(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.BOOLEAN, (l, r) -> null),
        GTE_UI(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.INT, (l, r) -> null),
        GTE_UL(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.LONG, (l, r) -> null),
        GTE_UF(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.FLOAT, (l, r) -> null),
        GTE_UD(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.DOUBLE, (l, r) -> null),
        GTE_US(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.STRING, (l, r) -> null),
        GTE_UV(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.VERSION, (l, r) -> null),
        GTE_VU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_VV(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.VERSION, (l, r) -> ((FDBRecordVersion)l).compareTo((FDBRecordVersion)r) >= 0),
        EQ_BYU(Comparisons.Type.EQUALS, Type.TypeCode.BYTES, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_BYBY(Comparisons.Type.EQUALS, Type.TypeCode.BYTES, Type.TypeCode.BYTES, (l, r) -> Comparisons.evalComparison(Comparisons.Type.EQUALS, l, r)),
        EQ_UBY(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.BYTES, (l, r) -> null),
        NEQ_BYU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_BYBY(Comparisons.Type.NOT_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.BYTES, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_EQUALS, l, r)),
        NEQ_UBY(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.BYTES, (l, r) -> null),
        LT_BYU(Comparisons.Type.LESS_THAN, Type.TypeCode.BYTES, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_BYBY(Comparisons.Type.LESS_THAN, Type.TypeCode.BYTES, Type.TypeCode.BYTES, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN, l, r)),
        LTE_BYU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_BYBY(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.BYTES, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, l, r)),
        GT_BYU(Comparisons.Type.GREATER_THAN, Type.TypeCode.BYTES, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_BYBY(Comparisons.Type.GREATER_THAN, Type.TypeCode.BYTES, Type.TypeCode.BYTES, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN, l, r)),
        GTE_BYU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_BYBY(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.BYTES, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, l, r)),
        EQ_EE(Comparisons.Type.EQUALS, Type.TypeCode.ENUM, Type.TypeCode.ENUM, (l, r) -> Comparisons.evalComparison(Comparisons.Type.EQUALS, l, r)),
        EQ_ES(Comparisons.Type.EQUALS, Type.TypeCode.ENUM, Type.TypeCode.STRING, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)l).getType(), (String)r);
            return Comparisons.evalComparison(Comparisons.Type.EQUALS, l, otherValue);
        }),
        EQ_SE(Comparisons.Type.EQUALS, Type.TypeCode.STRING, Type.TypeCode.ENUM, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)r).getType(), (String)l);
            return Comparisons.evalComparison(Comparisons.Type.EQUALS, otherValue, r);
        }),
        EQ_EU(Comparisons.Type.EQUALS, Type.TypeCode.ENUM, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_UE(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.ENUM, (l, r) -> null),
        NEQ_EE(Comparisons.Type.NOT_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.ENUM, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_EQUALS, l, r)),
        NEQ_ES(Comparisons.Type.NOT_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.STRING, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)l).getType(), (String)r);
            return Comparisons.evalComparison(Comparisons.Type.NOT_EQUALS, l, otherValue);
        }),
        NEQ_SE(Comparisons.Type.NOT_EQUALS, Type.TypeCode.STRING, Type.TypeCode.ENUM, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)r).getType(), (String)l);
            return Comparisons.evalComparison(Comparisons.Type.EQUALS, otherValue, r);
        }),
        NEQ_EU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_UE(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.ENUM, (l, r) -> null),
        LT_EE(Comparisons.Type.LESS_THAN, Type.TypeCode.ENUM, Type.TypeCode.ENUM, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN, l, r)),
        LT_ES(Comparisons.Type.LESS_THAN, Type.TypeCode.ENUM, Type.TypeCode.STRING, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)l).getType(), (String)r);
            return Comparisons.evalComparison(Comparisons.Type.LESS_THAN, l, otherValue);
        }),
        LT_SE(Comparisons.Type.LESS_THAN, Type.TypeCode.STRING, Type.TypeCode.ENUM, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)r).getType(), (String)l);
            return Comparisons.evalComparison(Comparisons.Type.LESS_THAN, otherValue, r);
        }),
        LT_EU(Comparisons.Type.LESS_THAN, Type.TypeCode.ENUM, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_UE(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.ENUM, (l, r) -> null),
        LTE_EE(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.ENUM, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, l, r)),
        LTE_ES(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.STRING, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)l).getType(), (String)r);
            return Comparisons.evalComparison(Comparisons.Type.LESS_THAN, l, otherValue);
        }),
        LTE_SE(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.ENUM, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)r).getType(), (String)l);
            return Comparisons.evalComparison(Comparisons.Type.LESS_THAN, otherValue, r);
        }),
        LTE_EU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_UE(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.ENUM, (l, r) -> null),
        GT_EE(Comparisons.Type.GREATER_THAN, Type.TypeCode.ENUM, Type.TypeCode.ENUM, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN, l, r)),
        GT_ES(Comparisons.Type.GREATER_THAN, Type.TypeCode.ENUM, Type.TypeCode.STRING, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)l).getType(), (String)r);
            return Comparisons.evalComparison(Comparisons.Type.GREATER_THAN, l, otherValue);
        }),
        GT_SE(Comparisons.Type.GREATER_THAN, Type.TypeCode.STRING, Type.TypeCode.ENUM, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)r).getType(), (String)l);
            return Comparisons.evalComparison(Comparisons.Type.GREATER_THAN, otherValue, r);
        }),
        GT_EU(Comparisons.Type.GREATER_THAN, Type.TypeCode.ENUM, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_UE(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.ENUM, (l, r) -> null),
        GTE_EE(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.ENUM, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, l, r)),
        GTE_ES(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.STRING, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)l).getType(), (String)r);
            return Comparisons.evalComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, l, otherValue);
        }),
        GTE_SE(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.ENUM, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)r).getType(), (String)l);
            return Comparisons.evalComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, otherValue, r);
        }),
        GTE_EU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_UE(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.ENUM, (l, r) -> null),
        EQ_IDID(Comparisons.Type.EQUALS, Type.TypeCode.UUID, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.EQUALS, l, r)),
        EQ_IDS(Comparisons.Type.EQUALS, Type.TypeCode.UUID, Type.TypeCode.STRING, (l, r) -> Comparisons.evalComparison(Comparisons.Type.EQUALS, l, PromoteValue.PhysicalOperator.stringToUuidValue((String)r))),
        EQ_SID(Comparisons.Type.EQUALS, Type.TypeCode.STRING, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.EQUALS, PromoteValue.PhysicalOperator.stringToUuidValue((String)l), r)),
        EQ_UID(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.UUID, (l, r) -> null),
        EQ_IDU(Comparisons.Type.EQUALS, Type.TypeCode.UUID, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_IDID(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UUID, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_EQUALS, l, r)),
        NEQ_IDS(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UUID, Type.TypeCode.STRING, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_EQUALS, l, PromoteValue.PhysicalOperator.stringToUuidValue((String)r))),
        NEQ_SID(Comparisons.Type.NOT_EQUALS, Type.TypeCode.STRING, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_EQUALS, PromoteValue.PhysicalOperator.stringToUuidValue((String)l), r)),
        NEQ_UID(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.UUID, (l, r) -> null),
        NEQ_IDU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UUID, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_IDID(Comparisons.Type.LESS_THAN, Type.TypeCode.UUID, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN, l, r)),
        LT_IDS(Comparisons.Type.LESS_THAN, Type.TypeCode.UUID, Type.TypeCode.STRING, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN, l, PromoteValue.PhysicalOperator.stringToUuidValue((String)r))),
        LT_SID(Comparisons.Type.LESS_THAN, Type.TypeCode.STRING, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN, PromoteValue.PhysicalOperator.stringToUuidValue((String)l), r)),
        LT_UID(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.UUID, (l, r) -> null),
        LT_IDU(Comparisons.Type.LESS_THAN, Type.TypeCode.UUID, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_IDID(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UUID, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, l, r)),
        LTE_IDS(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UUID, Type.TypeCode.STRING, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, l, PromoteValue.PhysicalOperator.stringToUuidValue((String)r))),
        LTE_SID(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, PromoteValue.PhysicalOperator.stringToUuidValue((String)l), r)),
        LTE_UID(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.UUID, (l, r) -> null),
        LTE_IDU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UUID, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_IDID(Comparisons.Type.GREATER_THAN, Type.TypeCode.UUID, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN, l, r)),
        GT_IDS(Comparisons.Type.GREATER_THAN, Type.TypeCode.UUID, Type.TypeCode.STRING, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN, l, PromoteValue.PhysicalOperator.stringToUuidValue((String)r))),
        GT_SID(Comparisons.Type.GREATER_THAN, Type.TypeCode.STRING, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN, PromoteValue.PhysicalOperator.stringToUuidValue((String)l), r)),
        GT_UID(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.UUID, (l, r) -> null),
        GT_IDU(Comparisons.Type.GREATER_THAN, Type.TypeCode.UUID, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_IDID(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UUID, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, l, r)),
        GTE_IDS(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UUID, Type.TypeCode.STRING, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, l, PromoteValue.PhysicalOperator.stringToUuidValue((String)r))),
        GTE_SID(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, PromoteValue.PhysicalOperator.stringToUuidValue((String)l), r)),
        GTE_UID(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.UUID, (l, r) -> null),
        GTE_IDU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UUID, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_BN(Comparisons.Type.EQUALS, Type.TypeCode.BOOLEAN, Type.TypeCode.NULL, (l, r) -> null),
        EQ_IN(Comparisons.Type.EQUALS, Type.TypeCode.INT, Type.TypeCode.NULL, (l, r) -> null),
        EQ_LN(Comparisons.Type.EQUALS, Type.TypeCode.LONG, Type.TypeCode.NULL, (l, r) -> null),
        EQ_FN(Comparisons.Type.EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.NULL, (l, r) -> null),
        EQ_DN(Comparisons.Type.EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.NULL, (l, r) -> null),
        EQ_SN(Comparisons.Type.EQUALS, Type.TypeCode.STRING, Type.TypeCode.NULL, (l, r) -> null),
        EQ_NN(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.NULL, (l, r) -> null),
        EQ_NU(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.UNKNOWN, (l, r) -> null),
        EQ_UN(Comparisons.Type.EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.NULL, (l, r) -> null),
        EQ_NB(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (l, r) -> null),
        EQ_NI(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.INT, (l, r) -> null),
        EQ_NL(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.LONG, (l, r) -> null),
        EQ_NF(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.FLOAT, (l, r) -> null),
        EQ_ND(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (l, r) -> null),
        EQ_NS(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.STRING, (l, r) -> null),
        EQ_NV(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.VERSION, (l, r) -> null),
        EQ_VN(Comparisons.Type.EQUALS, Type.TypeCode.VERSION, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_BN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.BOOLEAN, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_IN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.INT, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_LN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.LONG, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_FN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_DN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_SN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.STRING, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_NN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_UN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_NU(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.UNKNOWN, (l, r) -> null),
        NEQ_NB(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (l, r) -> null),
        NEQ_NI(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.INT, (l, r) -> null),
        NEQ_NL(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.LONG, (l, r) -> null),
        NEQ_NF(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.FLOAT, (l, r) -> null),
        NEQ_ND(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (l, r) -> null),
        NEQ_NS(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.STRING, (l, r) -> null),
        NEQ_NV(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.VERSION, (l, r) -> null),
        NEQ_VN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.NULL, (l, r) -> null),
        LT_IN(Comparisons.Type.LESS_THAN, Type.TypeCode.INT, Type.TypeCode.NULL, (l, r) -> null),
        LT_LN(Comparisons.Type.LESS_THAN, Type.TypeCode.LONG, Type.TypeCode.NULL, (l, r) -> null),
        LT_FN(Comparisons.Type.LESS_THAN, Type.TypeCode.FLOAT, Type.TypeCode.NULL, (l, r) -> null),
        LT_DN(Comparisons.Type.LESS_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.NULL, (l, r) -> null),
        LT_SN(Comparisons.Type.LESS_THAN, Type.TypeCode.STRING, Type.TypeCode.NULL, (l, r) -> null),
        LT_NN(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.NULL, (l, r) -> null),
        LT_UN(Comparisons.Type.LESS_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.NULL, (l, r) -> null),
        LT_NU(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LT_NB(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (l, r) -> null),
        LT_NI(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.INT, (l, r) -> null),
        LT_NL(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.LONG, (l, r) -> null),
        LT_NF(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.FLOAT, (l, r) -> null),
        LT_ND(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (l, r) -> null),
        LT_NS(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.STRING, (l, r) -> null),
        LT_NV(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.VERSION, (l, r) -> null),
        LT_VN(Comparisons.Type.LESS_THAN, Type.TypeCode.VERSION, Type.TypeCode.NULL, (l, r) -> null),
        LTE_IN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.NULL, (l, r) -> null),
        LTE_LN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.NULL, (l, r) -> null),
        LTE_FN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.NULL, (l, r) -> null),
        LTE_DN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.NULL, (l, r) -> null),
        LTE_SN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.NULL, (l, r) -> null),
        LTE_NN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.NULL, (l, r) -> null),
        LTE_UN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.NULL, (l, r) -> null),
        LTE_NU(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.UNKNOWN, (l, r) -> null),
        LTE_NB(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (l, r) -> null),
        LTE_NI(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.INT, (l, r) -> null),
        LTE_NL(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.LONG, (l, r) -> null),
        LTE_NF(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.FLOAT, (l, r) -> null),
        LTE_ND(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (l, r) -> null),
        LTE_NS(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.STRING, (l, r) -> null),
        LTE_NV(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.VERSION, (l, r) -> null),
        LTE_VN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.NULL, (l, r) -> null),
        GT_IN(Comparisons.Type.GREATER_THAN, Type.TypeCode.INT, Type.TypeCode.NULL, (l, r) -> null),
        GT_LN(Comparisons.Type.GREATER_THAN, Type.TypeCode.LONG, Type.TypeCode.NULL, (l, r) -> null),
        GT_FN(Comparisons.Type.GREATER_THAN, Type.TypeCode.FLOAT, Type.TypeCode.NULL, (l, r) -> null),
        GT_DN(Comparisons.Type.GREATER_THAN, Type.TypeCode.DOUBLE, Type.TypeCode.NULL, (l, r) -> null),
        GT_SN(Comparisons.Type.GREATER_THAN, Type.TypeCode.STRING, Type.TypeCode.NULL, (l, r) -> null),
        GT_NN(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.NULL, (l, r) -> null),
        GT_UN(Comparisons.Type.GREATER_THAN, Type.TypeCode.UNKNOWN, Type.TypeCode.NULL, (l, r) -> null),
        GT_NU(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GT_NB(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (l, r) -> null),
        GT_NI(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.INT, (l, r) -> null),
        GT_NL(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.LONG, (l, r) -> null),
        GT_NF(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.FLOAT, (l, r) -> null),
        GT_ND(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (l, r) -> null),
        GT_NS(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.STRING, (l, r) -> null),
        GT_NV(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.VERSION, (l, r) -> null),
        GT_VN(Comparisons.Type.GREATER_THAN, Type.TypeCode.VERSION, Type.TypeCode.NULL, (l, r) -> null),
        GTE_IN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.INT, Type.TypeCode.NULL, (l, r) -> null),
        GTE_LN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.LONG, Type.TypeCode.NULL, (l, r) -> null),
        GTE_FN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.FLOAT, Type.TypeCode.NULL, (l, r) -> null),
        GTE_DN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.DOUBLE, Type.TypeCode.NULL, (l, r) -> null),
        GTE_SN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.STRING, Type.TypeCode.NULL, (l, r) -> null),
        GTE_NN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.NULL, (l, r) -> null),
        GTE_NU(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.UNKNOWN, (l, r) -> null),
        GTE_UN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UNKNOWN, Type.TypeCode.NULL, (l, r) -> null),
        GTE_NB(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (l, r) -> null),
        GTE_NI(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.INT, (l, r) -> null),
        GTE_NL(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.LONG, (l, r) -> null),
        GTE_NF(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.FLOAT, (l, r) -> null),
        GTE_ND(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (l, r) -> null),
        GTE_NS(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.STRING, (l, r) -> null),
        GTE_NV(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.VERSION, (l, r) -> null),
        GTE_VN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.VERSION, Type.TypeCode.NULL, (l, r) -> null),
        EQ_BYN(Comparisons.Type.EQUALS, Type.TypeCode.BYTES, Type.TypeCode.NULL, (l, r) -> null),
        EQ_NBY(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.BYTES, (l, r) -> null),
        NEQ_BYN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_NBY(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.BYTES, (l, r) -> null),
        LT_BYN(Comparisons.Type.LESS_THAN, Type.TypeCode.BYTES, Type.TypeCode.NULL, (l, r) -> null),
        LTE_BYN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.NULL, (l, r) -> null),
        GT_BYN(Comparisons.Type.GREATER_THAN, Type.TypeCode.BYTES, Type.TypeCode.NULL, (l, r) -> null),
        GTE_BYN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.BYTES, Type.TypeCode.NULL, (l, r) -> null),
        EQ_EN(Comparisons.Type.EQUALS, Type.TypeCode.ENUM, Type.TypeCode.NULL, (l, r) -> null),
        EQ_NE(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.ENUM, (l, r) -> null),
        NEQ_EN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_NE(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.ENUM, (l, r) -> null),
        LT_EN(Comparisons.Type.LESS_THAN, Type.TypeCode.ENUM, Type.TypeCode.NULL, (l, r) -> null),
        LT_NE(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.ENUM, (l, r) -> null),
        LTE_EN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.NULL, (l, r) -> null),
        LTE_NE(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.ENUM, (l, r) -> null),
        GT_EN(Comparisons.Type.GREATER_THAN, Type.TypeCode.ENUM, Type.TypeCode.NULL, (l, r) -> null),
        GT_NE(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.ENUM, (l, r) -> null),
        GTE_EN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.ENUM, Type.TypeCode.NULL, (l, r) -> null),
        GTE_NE(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.ENUM, (l, r) -> null),
        EQ_NID(Comparisons.Type.EQUALS, Type.TypeCode.NULL, Type.TypeCode.UUID, (l, r) -> null),
        EQ_IDN(Comparisons.Type.EQUALS, Type.TypeCode.UUID, Type.TypeCode.NULL, (l, r) -> null),
        NEQ_NID(Comparisons.Type.NOT_EQUALS, Type.TypeCode.NULL, Type.TypeCode.UUID, (l, r) -> null),
        NEQ_IDN(Comparisons.Type.NOT_EQUALS, Type.TypeCode.UUID, Type.TypeCode.NULL, (l, r) -> null),
        LT_NID(Comparisons.Type.LESS_THAN, Type.TypeCode.NULL, Type.TypeCode.UUID, (l, r) -> null),
        LT_IDN(Comparisons.Type.LESS_THAN, Type.TypeCode.UUID, Type.TypeCode.NULL, (l, r) -> null),
        LTE_NID(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.UUID, (l, r) -> null),
        LTE_IDN(Comparisons.Type.LESS_THAN_OR_EQUALS, Type.TypeCode.UUID, Type.TypeCode.NULL, (l, r) -> null),
        GT_NID(Comparisons.Type.GREATER_THAN, Type.TypeCode.NULL, Type.TypeCode.UUID, (l, r) -> null),
        GT_IDN(Comparisons.Type.GREATER_THAN, Type.TypeCode.UUID, Type.TypeCode.NULL, (l, r) -> null),
        GTE_NID(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.NULL, Type.TypeCode.UUID, (l, r) -> null),
        GTE_IDN(Comparisons.Type.GREATER_THAN_OR_EQUALS, Type.TypeCode.UUID, Type.TypeCode.NULL, (l, r) -> null),
        IS_DISTINCT_FROM_BN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.BOOLEAN, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_BB(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.BOOLEAN, Type.TypeCode.BOOLEAN, (l, r) -> ((Boolean)l).booleanValue() != ((Boolean)r).booleanValue()),
        IS_DISTINCT_FROM_IN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_II(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> ((Integer)l).intValue() != ((Integer)r).intValue()),
        IS_DISTINCT_FROM_IL(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() != (Long)r),
        IS_DISTINCT_FROM_IF(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> (float)((Integer)l).intValue() != ((Float)r).floatValue()),
        IS_DISTINCT_FROM_ID(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() != (Double)r),
        IS_DISTINCT_FROM_LN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_LI(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.INT, (l, r) -> (Long)l != (long)((Integer)r).intValue()),
        IS_DISTINCT_FROM_LL(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> ((Long)l).longValue() != ((Long)r).longValue()),
        IS_DISTINCT_FROM_LF(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> (float)((Long)l).longValue() != ((Float)r).floatValue()),
        IS_DISTINCT_FROM_LD(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() != (Double)r),
        IS_DISTINCT_FROM_FN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_FI(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.INT, (l, r) -> ((Float)l).floatValue() != (float)((Integer)r).intValue()),
        IS_DISTINCT_FROM_FL(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.LONG, (l, r) -> ((Float)l).floatValue() != (float)((Long)r).longValue()),
        IS_DISTINCT_FROM_FF(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> ((Float)l).floatValue() != ((Float)r).floatValue()),
        IS_DISTINCT_FROM_FD(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() != (Double)r),
        IS_DISTINCT_FROM_DN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_DI(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.INT, (l, r) -> (Double)l != (double)((Integer)r).intValue()),
        IS_DISTINCT_FROM_DL(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, (l, r) -> (Double)l != (double)((Long)r).longValue()),
        IS_DISTINCT_FROM_DF(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, (l, r) -> (Double)l != (double)((Float)r).floatValue()),
        IS_DISTINCT_FROM_DD(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> ((Double)l).doubleValue() != ((Double)r).doubleValue()),
        IS_DISTINCT_FROM_SN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.STRING, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_SS(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.STRING, Type.TypeCode.STRING, (l, r) -> !l.equals(r)),
        IS_DISTINCT_FROM_NB(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_NI(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.INT, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_NL(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.LONG, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_NF(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.FLOAT, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_ND(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_NS(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.STRING, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_NV(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.VERSION, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_VN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.VERSION, Type.TypeCode.NULL, (l, r) -> null),
        IS_DISTINCT_FROM_VV(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.VERSION, Type.TypeCode.VERSION, (l, r) -> !l.equals(r)),
        IS_DISTINCT_FROM_BYN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.BYTES, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_BYBY(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.BYTES, Type.TypeCode.BYTES, (l, r) -> Comparisons.evalComparison(Comparisons.Type.IS_DISTINCT_FROM, l, r)),
        IS_DISTINCT_FROM_NBY(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.BYTES, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_EE(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.ENUM, Type.TypeCode.ENUM, (l, r) -> Comparisons.evalComparison(Comparisons.Type.IS_DISTINCT_FROM, l, r)),
        IS_DISTINCT_FROM_ES(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.ENUM, Type.TypeCode.STRING, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)l).getType(), (String)r);
            return Comparisons.evalComparison(Comparisons.Type.IS_DISTINCT_FROM, l, otherValue);
        }),
        IS_DISTINCT_FROM_SE(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.STRING, Type.TypeCode.ENUM, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)r).getType(), (String)l);
            return Comparisons.evalComparison(Comparisons.Type.EQUALS, otherValue, r);
        }),
        IS_DISTINCT_FROM_EN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.ENUM, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_NE(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.ENUM, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_IDID(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.UUID, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.IS_DISTINCT_FROM, l, r)),
        IS_DISTINCT_FROM_IDS(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.UUID, Type.TypeCode.STRING, (l, r) -> Comparisons.evalComparison(Comparisons.Type.IS_DISTINCT_FROM, l, PromoteValue.PhysicalOperator.stringToUuidValue((String)r))),
        IS_DISTINCT_FROM_SID(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.STRING, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.IS_DISTINCT_FROM, PromoteValue.PhysicalOperator.stringToUuidValue((String)l), r)),
        IS_DISTINCT_FROM_NID(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.UUID, (l, r) -> Objects.nonNull(r)),
        IS_DISTINCT_FROM_IDN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.UUID, Type.TypeCode.NULL, (l, r) -> Objects.nonNull(l)),
        IS_DISTINCT_FROM_NN(Comparisons.Type.IS_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.NULL, (l, r) -> false),
        NOT_DISTINCT_FROM_BN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.BOOLEAN, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_BB(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.BOOLEAN, Type.TypeCode.BOOLEAN, (l, r) -> ((Boolean)l).booleanValue() == ((Boolean)r).booleanValue()),
        NOT_DISTINCT_FROM_IN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_II(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.INT, (l, r) -> ((Integer)l).intValue() == ((Integer)r).intValue()),
        NOT_DISTINCT_FROM_IL(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.LONG, (l, r) -> (long)((Integer)l).intValue() == (Long)r),
        NOT_DISTINCT_FROM_IF(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.FLOAT, (l, r) -> (float)((Integer)l).intValue() == ((Float)r).floatValue()),
        NOT_DISTINCT_FROM_ID(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.INT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Integer)l).intValue() == (Double)r),
        NOT_DISTINCT_FROM_LN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_LI(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.INT, (l, r) -> (Long)l == (long)((Integer)r).intValue()),
        NOT_DISTINCT_FROM_LL(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.LONG, (l, r) -> ((Long)l).longValue() == ((Long)r).longValue()),
        NOT_DISTINCT_FROM_LF(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.FLOAT, (l, r) -> (float)((Long)l).longValue() == ((Float)r).floatValue()),
        NOT_DISTINCT_FROM_LD(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.LONG, Type.TypeCode.DOUBLE, (l, r) -> (double)((Long)l).longValue() == (Double)r),
        NOT_DISTINCT_FROM_FN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_FI(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.INT, (l, r) -> ((Float)l).floatValue() == (float)((Integer)r).intValue()),
        NOT_DISTINCT_FROM_FL(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.LONG, (l, r) -> ((Float)l).floatValue() == (float)((Long)r).longValue()),
        NOT_DISTINCT_FROM_FF(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.FLOAT, (l, r) -> ((Float)l).floatValue() == ((Float)r).floatValue()),
        NOT_DISTINCT_FROM_FD(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.FLOAT, Type.TypeCode.DOUBLE, (l, r) -> (double)((Float)l).floatValue() == (Double)r),
        NOT_DISTINCT_FROM_DN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_DI(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.INT, (l, r) -> (Double)l == (double)((Integer)r).intValue()),
        NOT_DISTINCT_FROM_DL(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.LONG, (l, r) -> (Double)l == (double)((Long)r).longValue()),
        NOT_DISTINCT_FROM_DF(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.FLOAT, (l, r) -> (Double)l == (double)((Float)r).floatValue()),
        NOT_DISTINCT_FROM_DD(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.DOUBLE, Type.TypeCode.DOUBLE, (l, r) -> ((Double)l).doubleValue() == ((Double)r).doubleValue()),
        NOT_DISTINCT_FROM_SN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.STRING, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_SS(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.STRING, Type.TypeCode.STRING, Object::equals),
        NOT_DISTINCT_FROM_NB(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.BOOLEAN, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_NI(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.INT, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_NL(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.LONG, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_NF(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.FLOAT, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_ND(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.DOUBLE, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_NS(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.STRING, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_NV(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.VERSION, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_VN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.VERSION, Type.TypeCode.NULL, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_VV(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.VERSION, Type.TypeCode.VERSION, Object::equals),
        NOT_DISTINCT_FROM_BYN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.BYTES, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_BYBY(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.BYTES, Type.TypeCode.BYTES, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_DISTINCT_FROM, l, r)),
        NOT_DISTINCT_FROM_NBY(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.BYTES, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_EE(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.ENUM, Type.TypeCode.ENUM, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_DISTINCT_FROM, l, r)),
        NOT_DISTINCT_FROM_ES(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.ENUM, Type.TypeCode.STRING, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)l).getType(), (String)r);
            return Comparisons.evalComparison(Comparisons.Type.NOT_DISTINCT_FROM, l, otherValue);
        }),
        NOT_DISTINCT_FROM_SE(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.STRING, Type.TypeCode.ENUM, (l, r) -> {
            Descriptors.EnumValueDescriptor otherValue = PromoteValue.PhysicalOperator.stringToEnumValue(((Descriptors.EnumValueDescriptor)r).getType(), (String)l);
            return Comparisons.evalComparison(Comparisons.Type.NOT_DISTINCT_FROM, otherValue, r);
        }),
        NOT_DISTINCT_FROM_EN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.ENUM, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_NE(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.ENUM, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_IDID(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.UUID, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_DISTINCT_FROM, l, r)),
        NOT_DISTINCT_FROM_IDS(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.UUID, Type.TypeCode.STRING, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_DISTINCT_FROM, l, PromoteValue.PhysicalOperator.stringToUuidValue((String)r))),
        NOT_DISTINCT_FROM_SID(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.STRING, Type.TypeCode.UUID, (l, r) -> Comparisons.evalComparison(Comparisons.Type.NOT_DISTINCT_FROM, PromoteValue.PhysicalOperator.stringToUuidValue((String)l), r)),
        NOT_DISTINCT_FROM_NID(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.UUID, (l, r) -> Objects.isNull(r)),
        NOT_DISTINCT_FROM_IDN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.UUID, Type.TypeCode.NULL, (l, r) -> Objects.isNull(l)),
        NOT_DISTINCT_FROM_NN(Comparisons.Type.NOT_DISTINCT_FROM, Type.TypeCode.NULL, Type.TypeCode.NULL, (l, r) -> true);

        @Nonnull
        private static final Supplier<BiMap<BinaryPhysicalOperator, PBinaryRelOpValue.PBinaryPhysicalOperator>> protoEnumBiMapSupplier;
        @Nonnull
        private final Comparisons.Type type;
        @Nonnull
        private final Type.TypeCode leftArgType;
        @Nonnull
        private final Type.TypeCode rightArgType;
        @Nonnull
        private final BinaryOperator<Object> evaluateFunction;

        private BinaryPhysicalOperator(@Nonnull Comparisons.Type type, @Nonnull Type.TypeCode leftArgType, Type.TypeCode rightArgType, BinaryOperator<Object> evaluateFunction) {
            this.type = type;
            this.leftArgType = leftArgType;
            this.rightArgType = rightArgType;
            this.evaluateFunction = evaluateFunction;
        }

        @Nullable
        public Object eval(@Nullable Object arg1, @Nullable Object arg2) {
            if (arg1 == null || arg2 == null) {
                if (this.type == Comparisons.Type.IS_DISTINCT_FROM) {
                    return arg1 != null || arg2 != null;
                }
                if (this.type == Comparisons.Type.NOT_DISTINCT_FROM) {
                    return arg1 == null && arg2 == null;
                }
                return null;
            }
            return this.evaluateFunction.apply(arg1, arg2);
        }

        @Nonnull
        public Comparisons.Type getType() {
            return this.type;
        }

        @Nonnull
        public Type.TypeCode getLeftArgType() {
            return this.leftArgType;
        }

        @Nonnull
        public Type.TypeCode getRightArgType() {
            return this.rightArgType;
        }

        @Nonnull
        public PBinaryRelOpValue.PBinaryPhysicalOperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            return Objects.requireNonNull((PBinaryRelOpValue.PBinaryPhysicalOperator)BinaryPhysicalOperator.getProtoEnumBiMap().get((Object)this));
        }

        @Nonnull
        public static BinaryPhysicalOperator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PBinaryRelOpValue.PBinaryPhysicalOperator binaryPhysicalOperatorProto) {
            return Objects.requireNonNull((BinaryPhysicalOperator)((Object)BinaryPhysicalOperator.getProtoEnumBiMap().inverse().get(binaryPhysicalOperatorProto)));
        }

        @Nonnull
        private static BiMap<BinaryPhysicalOperator, PBinaryRelOpValue.PBinaryPhysicalOperator> getProtoEnumBiMap() {
            return protoEnumBiMapSupplier.get();
        }

        static {
            protoEnumBiMapSupplier = Suppliers.memoize(() -> PlanSerialization.protoEnumBiMap(BinaryPhysicalOperator.class, PBinaryRelOpValue.PBinaryPhysicalOperator.class));
        }
    }

    public static class BinaryRelOpValue
    extends RelOpValue {
        @Nonnull
        private final BinaryPhysicalOperator operator;

        private BinaryRelOpValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PBinaryRelOpValue binaryRelOpValueProto) {
            super(serializationContext, Objects.requireNonNull(binaryRelOpValueProto.getSuper()));
            this.operator = BinaryPhysicalOperator.fromProto(serializationContext, Objects.requireNonNull(binaryRelOpValueProto.getOperator()));
        }

        private BinaryRelOpValue(@Nonnull String functionName, @Nonnull Comparisons.Type comparisonType, @Nonnull Iterable<? extends Value> children, @Nonnull BinaryPhysicalOperator operator) {
            super(functionName, comparisonType, children);
            this.operator = operator;
        }

        @Override
        @Nonnull
        public RelOpValue withChildren(Iterable<? extends Value> newChildren) {
            Verify.verify(Iterables.size(newChildren) == 2);
            return new BinaryRelOpValue(this.getFunctionName(), this.getComparisonType(), newChildren, this.operator);
        }

        @Override
        public int hashCodeWithoutChildren() {
            return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.getComparisonType(), this.operator});
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.getComparisonType(), StreamSupport.stream(this.getChildren().spliterator(), false).toArray(Value[]::new)});
        }

        @Override
        @Nullable
        public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
            Iterator evaluatedChildrenIterator = Streams.stream(this.getChildren()).map(child -> child.eval(store, context)).iterator();
            return this.operator.eval(evaluatedChildrenIterator.next(), evaluatedChildrenIterator.next());
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
            ExplainTokensWithPrecedence left = Iterables.get(explainSuppliers, 0).get();
            ExplainTokensWithPrecedence right = Iterables.get(explainSuppliers, 1).get();
            return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.COMPARISONS, ExplainTokensWithPrecedence.Precedence.COMPARISONS.parenthesizeChild(left).addWhitespace().addToString(this.getFunctionName()).addWhitespace().addNested(ExplainTokensWithPrecedence.Precedence.COMPARISONS.parenthesizeChild(right)));
        }

        @Override
        @Nonnull
        public PBinaryRelOpValue toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PBinaryRelOpValue.newBuilder().setSuper(this.toRelOpValueProto(serializationContext)).setOperator(this.operator.toProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValue.newBuilder().setBinaryRelOpValue(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static BinaryRelOpValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PBinaryRelOpValue binaryRelOpValueProto) {
            return new BinaryRelOpValue(serializationContext, binaryRelOpValueProto);
        }

        public static class Deserializer
        implements PlanDeserializer<PBinaryRelOpValue, BinaryRelOpValue> {
            @Override
            @Nonnull
            public Class<PBinaryRelOpValue> getProtoMessageClass() {
                return PBinaryRelOpValue.class;
            }

            @Override
            @Nonnull
            public BinaryRelOpValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PBinaryRelOpValue binaryRelOpValueProto) {
                return BinaryRelOpValue.fromProto(serializationContext, binaryRelOpValueProto);
            }
        }
    }

    public static class NotDistinctFromFn
    extends BuiltInFunction<Value> {
        public NotDistinctFromFn() {
            super("notDistinctFrom", List.of(new Type.Any(), new Type.Any()), NotDistinctFromFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.NOT_DISTINCT_FROM, arguments);
        }
    }

    public static class IsDistinctFromFn
    extends BuiltInFunction<Value> {
        public IsDistinctFromFn() {
            super("isDistinctFrom", List.of(new Type.Any(), new Type.Any()), IsDistinctFromFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.IS_DISTINCT_FROM, arguments);
        }
    }

    public static class NotNullFn
    extends BuiltInFunction<Value> {
        public NotNullFn() {
            super("notNull", List.of(new Type.Any()), NotNullFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.NOT_NULL, arguments);
        }
    }

    public static class IsNullFn
    extends BuiltInFunction<Value> {
        public IsNullFn() {
            super("isNull", List.of(new Type.Any()), IsNullFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.IS_NULL, arguments);
        }
    }

    public static class GteFn
    extends BuiltInFunction<Value> {
        public GteFn() {
            super("gte", List.of(new Type.Any(), new Type.Any()), GteFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.GREATER_THAN_OR_EQUALS, arguments);
        }
    }

    public static class GtFn
    extends BuiltInFunction<Value> {
        public GtFn() {
            super("gt", List.of(new Type.Any(), new Type.Any()), GtFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.GREATER_THAN, arguments);
        }
    }

    public static class LteFn
    extends BuiltInFunction<Value> {
        public LteFn() {
            super("lte", List.of(new Type.Any(), new Type.Any()), LteFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.LESS_THAN_OR_EQUALS, arguments);
        }
    }

    public static class LtFn
    extends BuiltInFunction<Value> {
        public LtFn() {
            super("lt", List.of(new Type.Any(), new Type.Any()), LtFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.LESS_THAN, arguments);
        }
    }

    public static class NotEqualsFn
    extends BuiltInFunction<Value> {
        public NotEqualsFn() {
            super("notEquals", List.of(new Type.Any(), new Type.Any()), NotEqualsFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.NOT_EQUALS, arguments);
        }
    }

    public static class EqualsFn
    extends BuiltInFunction<Value> {
        public EqualsFn() {
            super("equals", List.of(new Type.Any(), new Type.Any()), EqualsFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
            return RelOpValue.encapsulate(builtInFunction.getFunctionName(), Comparisons.Type.EQUALS, arguments);
        }
    }
}

