/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PSubscriptValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SubscriptValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Subscript-Value");
    @Nonnull
    private final Value indexValue;
    @Nonnull
    private final Value sourceValue;
    @Nonnull
    private final Type type;

    public SubscriptValue(@Nonnull Value indexValue, @Nonnull Value sourceValue) {
        this.indexValue = indexValue;
        this.sourceValue = sourceValue;
        this.type = Verify.verifyNotNull(((Type.Array)sourceValue.getResultType()).getElementType()).nullable();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return List.of(this.indexValue, this.sourceValue);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ExplainTokensWithPrecedence indexValueExplain = Iterables.get(explainSuppliers, 0).get();
        ExplainTokensWithPrecedence sourceValueExplain = Iterables.get(explainSuppliers, 1).get();
        return ExplainTokensWithPrecedence.of(sourceValueExplain.getExplainTokens().addOpeningSquareBracket().addOptionalWhitespace().addNested(indexValueExplain.getExplainTokens()).addClosingAngledBracket());
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object index = this.indexValue.eval(store, context);
        if (index == null) {
            return null;
        }
        Object source = this.sourceValue.eval(store, context);
        if (source == null) {
            return null;
        }
        List sourceAsList = (List)source;
        int adjustedIndex = (Integer)index - 1;
        if (adjustedIndex < 0 || adjustedIndex >= sourceAsList.size()) {
            return null;
        }
        return sourceAsList.get(adjustedIndex);
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.type;
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setSubscriptValue(this.toProto(serializationContext)).build();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
        return PlanHashable.objectsPlanHash(hashMode, BASE_HASH);
    }

    @Override
    @Nonnull
    public PSubscriptValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PSubscriptValue.newBuilder().setIndex(this.indexValue.toValueProto(serializationContext)).setSource(this.sourceValue.toValueProto(serializationContext)).build();
    }

    @Nonnull
    public static SubscriptValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSubscriptValue subscriptValueProto) {
        return new SubscriptValue(Value.fromValueProto(serializationContext, subscriptValueProto.getIndex()), Value.fromValueProto(serializationContext, subscriptValueProto.getSource()));
    }

    @Override
    @Nonnull
    public Value withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(Iterables.size(newChildren) == 2);
        Value newIndexValue = Iterables.get(newChildren, 0);
        Value newSourceValue = Iterables.get(newChildren, 1);
        if (this.indexValue == newIndexValue && newSourceValue == this.sourceValue) {
            return this;
        }
        return new SubscriptValue(newIndexValue, newSourceValue);
    }

    public static class SubscriptValueFn
    extends BuiltInFunction<Value> {
        public SubscriptValueFn() {
            super("subscript", List.of(Type.primitiveType(Type.TypeCode.INT), Type.any()), Type.any(), SubscriptValueFn::encapsulate);
        }

        private static Value encapsulate(@Nonnull BuiltInFunction<Value> ignored, @Nonnull List<? extends Typed> arguments) {
            Verify.verify(arguments.size() == 2);
            Value indexValue = (Value)arguments.get(0);
            Type indexMaxType = Type.maximumType(indexValue.getResultType(), Type.primitiveType(Type.TypeCode.INT));
            SemanticException.check(indexMaxType != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            indexValue = PromoteValue.inject(indexValue, indexMaxType);
            Value sourceValue = (Value)arguments.get(1);
            Verify.verify(sourceValue.getResultType().isArray());
            return new SubscriptValue(indexValue, sourceValue);
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PSubscriptValue, SubscriptValue> {
        @Override
        @Nonnull
        public Class<PSubscriptValue> getProtoMessageClass() {
            return PSubscriptValue.class;
        }

        @Override
        @Nonnull
        public SubscriptValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSubscriptValue subscriptValueProto) {
            return SubscriptValue.fromProto(serializationContext, subscriptValueProto);
        }
    }
}

