/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.planprotos.PToOrderedBytesValue;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FromOrderedBytesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.OrderedBytesHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.ValueWithChild;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.tuple.TupleOrdering;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ToOrderedBytesValue
extends AbstractValue
implements ValueWithChild,
Value.InvertableValue<FromOrderedBytesValue>,
Ordering.OrderPreservingValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("To-Ordered-Bytes-Value");
    @Nonnull
    private final Value child;
    @Nonnull
    private final TupleOrdering.Direction direction;

    public ToOrderedBytesValue(@Nonnull Value child, @Nonnull TupleOrdering.Direction direction) {
        this.child = child;
        this.direction = direction;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.getChild());
    }

    @Override
    @Nonnull
    public Value getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(Type.TypeCode.BYTES);
    }

    @Nonnull
    public TupleOrdering.Direction getDirection() {
        return this.direction;
    }

    @Override
    @Nonnull
    public ValueWithChild withNewChild(@Nonnull Value rebasedChild) {
        return new ToOrderedBytesValue(rebasedChild, this.direction);
    }

    @Override
    public Optional<FromOrderedBytesValue> createInverseValueMaybe(@Nonnull Value newChildValue) {
        return Optional.of(new FromOrderedBytesValue(newChildValue, this.getDirection(), this.child.getResultType()));
    }

    @Override
    @Nonnull
    public Ordering.OrderPreservingKind getOrderPreservingKind() {
        switch (this.getDirection()) {
            case ASC_NULLS_FIRST: 
            case ASC_NULLS_LAST: {
                return Ordering.OrderPreservingKind.DIRECT_ORDER_PRESERVING;
            }
            case DESC_NULLS_FIRST: 
            case DESC_NULLS_LAST: {
                return Ordering.OrderPreservingKind.INVERSE_ORDER_PRESERVING;
            }
        }
        throw new RecordCoreException("unexpected enum", new Object[0]);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Object result = this.child.eval(store, context);
        return ZeroCopyByteString.wrap(TupleOrdering.pack(Key.Evaluated.scalar(result).toTuple(), this.direction));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.direction});
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.child, this.direction});
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("to_ordered_bytes", Value.explainFunctionArguments(explainSuppliers).addCommaAndWhiteSpace().addToString((Object)this.getDirection())));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.direction == ((ToOrderedBytesValue)other).getDirection());
    }

    @Override
    @Nonnull
    public PToOrderedBytesValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PToOrderedBytesValue.newBuilder().setChild(this.child.toValueProto(serializationContext)).setDirection(OrderedBytesHelpers.toDirectionProto(this.direction)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setToOrderedBytesValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ToOrderedBytesValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PToOrderedBytesValue toOrderedBytesValueProto) {
        return new ToOrderedBytesValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(toOrderedBytesValueProto.getChild())), OrderedBytesHelpers.fromDirectionProto(Objects.requireNonNull(toOrderedBytesValueProto.getDirection())));
    }

    public static class Deserializer
    implements PlanDeserializer<PToOrderedBytesValue, ToOrderedBytesValue> {
        @Override
        @Nonnull
        public Class<PToOrderedBytesValue> getProtoMessageClass() {
            return PToOrderedBytesValue.class;
        }

        @Override
        @Nonnull
        public ToOrderedBytesValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PToOrderedBytesValue toOrderedBytesValueProto) {
            return ToOrderedBytesValue.fromProto(serializationContext, toOrderedBytesValueProto);
        }
    }

    public static class ToOrderedBytesDescNullsLastFn
    extends BuiltInFunction<Value> {
        public ToOrderedBytesDescNullsLastFn() {
            super("TO_ORDERED_BYTES_" + String.valueOf((Object)TupleOrdering.Direction.DESC_NULLS_LAST), ImmutableList.of(Type.any()), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> new ToOrderedBytesValue((Value)arguments.get(0), TupleOrdering.Direction.DESC_NULLS_LAST));
        }
    }

    public static class ToOrderedBytesDescNullsFirstFn
    extends BuiltInFunction<Value> {
        public ToOrderedBytesDescNullsFirstFn() {
            super("TO_ORDERED_BYTES_" + String.valueOf((Object)TupleOrdering.Direction.DESC_NULLS_FIRST), ImmutableList.of(Type.any()), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> new ToOrderedBytesValue((Value)arguments.get(0), TupleOrdering.Direction.DESC_NULLS_FIRST));
        }
    }

    public static class ToOrderedBytesAscNullsLastFn
    extends BuiltInFunction<Value> {
        public ToOrderedBytesAscNullsLastFn() {
            super("TO_ORDERED_BYTES_" + String.valueOf((Object)TupleOrdering.Direction.ASC_NULLS_LAST), ImmutableList.of(Type.any()), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> new ToOrderedBytesValue((Value)arguments.get(0), TupleOrdering.Direction.ASC_NULLS_LAST));
        }
    }

    public static class ToOrderedBytesAscNullsFirstFn
    extends BuiltInFunction<Value> {
        public ToOrderedBytesAscNullsFirstFn() {
            super("TO_ORDERED_BYTES_" + String.valueOf((Object)TupleOrdering.Direction.ASC_NULLS_FIRST), ImmutableList.of(Type.any()), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> new ToOrderedBytesValue((Value)arguments.get(0), TupleOrdering.Direction.ASC_NULLS_FIRST));
        }
    }
}

