/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.UdfValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class UdfFunction
extends BuiltInFunction<Value> {
    public UdfFunction() {
        super("", List.of(), (BuiltInFunction<T> builtInFunction, List<Typed> arguments) -> null);
    }

    @Override
    @Nonnull
    public abstract List<Type> getParameterTypes();

    @Override
    @Nonnull
    public final String getFunctionName() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    protected abstract UdfValue newCallsite(@Nonnull List<Value> var1);

    @Override
    @Nonnull
    public final Typed encapsulate(@Nonnull List<? extends Typed> arguments) {
        arguments.forEach(argument -> Verify.verify(argument instanceof Value));
        List<Type> parameterTypes = this.getParameterTypes();
        if (arguments.size() != parameterTypes.size()) {
            String udfName = this.getFunctionName();
            throw new RecordCoreException("attempt to call " + udfName + " with incorrect number of parameters", new Object[0]);
        }
        ImmutableList.Builder promotedArgumentsList = ImmutableList.builder();
        for (int i = 0; i < arguments.size(); ++i) {
            Typed argument2 = arguments.get(i);
            Type parameter = parameterTypes.get(i);
            Type maxType = Type.maximumType(argument2.getResultType(), parameter);
            SemanticException.check(maxType != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
            if (!argument2.getResultType().equals(maxType)) {
                promotedArgumentsList.add(PromoteValue.inject((Value)argument2, maxType));
                continue;
            }
            promotedArgumentsList.add((Value)argument2);
        }
        return this.newCallsite((List<Value>)((Object)promotedArgumentsList.build()));
    }
}

