/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.protobuf.Message;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class UdfValue
extends AbstractValue {
    @Nonnull
    private final Iterable<? extends Value> children;
    @Nonnull
    private final Type resultType;

    public UdfValue(@Nonnull Iterable<? extends Value> children, @Nonnull Type resultType) {
        this.children = children;
        this.resultType = resultType;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashKind) {
        return PlanHashable.objectsPlanHash(hashKind, this.getClass().getCanonicalName(), this.children);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return this.children;
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.call(StreamSupport.stream(this.children.spliterator(), false).map(c -> c.eval(store, context)).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public abstract Value withChildren(Iterable<? extends Value> var1);

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall(this.getClass().getSimpleName(), Value.explainFunctionArguments(explainSuppliers)));
    }

    @Nullable
    public abstract Object call(@Nonnull List<Object> var1);

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, this.getClass().getCanonicalName());
    }
}

