/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Constrained;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Narrowable;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.ScalarTranslationVisitor;
import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.apple.foundationdb.record.query.plan.cascades.UsesValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.CreatesDynamicTypesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexEntryObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractValueRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ComparisonCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultValueSimplificationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ExtractFromIndexKeyValueRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.OrderingValueComputationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.PullUpValueRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.Simplification;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Functions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.primitives.ImmutableIntArray;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public interface Value
extends Correlated<Value>,
TreeLike<Value>,
UsesValueEquivalence<Value>,
PlanHashable,
Typed,
Narrowable<Value>,
PlanSerializable {
    @Override
    @Nonnull
    default public Value getThis() {
        return this;
    }

    @Override
    @Nonnull
    default public Type getResultType() {
        return Type.primitiveType(Type.TypeCode.UNKNOWN);
    }

    @Nonnull
    default public Set<Type> getDynamicTypes() {
        return this.fold(p -> {
            if (p instanceof CreatesDynamicTypesValue) {
                return ImmutableSet.of(p.getResultType());
            }
            return ImmutableSet.of();
        }, (thisTypes, childTypeSets) -> {
            ImmutableSet.Builder nestedBuilder = ImmutableSet.builder();
            for (Set childTypes : childTypeSets) {
                nestedBuilder.addAll((Iterable)childTypes);
            }
            nestedBuilder.addAll((Iterable)thisTypes);
            return nestedBuilder.build();
        });
    }

    @Nonnull
    default public ExplainTokensWithPrecedence explain() {
        ImmutableList<Supplier<ExplainTokensWithPrecedence>> explainFunctions = Streams.stream(this.getChildren()).map(child -> child::explain).collect(ImmutableList.toImmutableList());
        return this.explain(explainFunctions);
    }

    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isConstant() {
        if (!this.getCorrelatedTo().isEmpty()) return false;
        if (!this.preOrderStream().filter(NondeterministicValue.class::isInstance).findAny().isEmpty()) return false;
        return true;
    }

    @Nullable
    default public Object evalWithoutStore(@Nonnull EvaluationContext context) {
        return this.eval(null, context);
    }

    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2);

    @Nonnull
    default public ValuePredicate withComparison(@Nonnull Comparisons.Comparison comparison) {
        return new ValuePredicate(this, comparison);
    }

    @Nonnull
    default public Placeholder asPlaceholder(@Nonnull CorrelationIdentifier parameterAlias) {
        return Placeholder.newInstanceWithoutRanges(this, parameterAlias);
    }

    default public boolean isFunctionallyDependentOn(@Nonnull Value otherValue) {
        if (!(otherValue instanceof QuantifiedValue)) {
            return false;
        }
        return this.preOrderStream().filter(value -> value instanceof QuantifiedValue).allMatch(quantifiedValue -> quantifiedValue.isFunctionallyDependentOn(otherValue));
    }

    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren();

    @Override
    @Nonnull
    default public Value rebase(@Nonnull AliasMap aliasMap) {
        return this.translateCorrelations(TranslationMap.rebaseWithAliasMap(aliasMap));
    }

    @Nonnull
    default public Value translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplify) {
        Value newValue = this.translateCorrelations(translationMap);
        return shouldSimplify ? newValue.simplify(EvaluationContext.empty(), AliasMap.emptyMap(), newValue.getCorrelatedTo()) : newValue;
    }

    @Nonnull
    default public Value translateCorrelations(@Nonnull TranslationMap translationMap) {
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        return (Value)this.replaceLeavesMaybe(value -> {
            if (value instanceof LeafValue) {
                LeafValue leafValue = (LeafValue)value;
                Set<CorrelationIdentifier> correlatedTo = value.getCorrelatedTo();
                if (correlatedTo.isEmpty()) {
                    return leafValue;
                }
                Verify.verify(correlatedTo.size() == 1);
                CorrelationIdentifier sourceAlias = Iterables.getOnlyElement(correlatedTo);
                return translationMap.containsSourceAlias(sourceAlias) ? translationMap.applyTranslationFunction(sourceAlias, leafValue) : leafValue;
            }
            Verify.verify(value.getCorrelatedTo().isEmpty());
            return value;
        }, false).orElseThrow(() -> new RecordCoreException("unable to map tree", new Object[0]));
    }

    @Nonnull
    default public <V extends Value> V narrow(@Nonnull Class<V> narrowedClass) {
        return (V)((Value)narrowedClass.cast(this));
    }

    public int hashCodeWithoutChildren();

    @Override
    default public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Value)) {
            return false;
        }
        return this.semanticEquals(other, ValueEquivalence.fromAliasMap(aliasMap)).isTrue();
    }

    @Override
    @Nonnull
    default public ConstrainedBoolean semanticEquals(@Nullable Object other, @Nonnull ValueEquivalence valueEquivalence) {
        if (this == other) {
            return ConstrainedBoolean.alwaysTrue();
        }
        if (!(other instanceof Value)) {
            return ConstrainedBoolean.falseValue();
        }
        ConstrainedBoolean thisOther = this.semanticEqualsTyped((Value)other, valueEquivalence);
        Debugger.sanityCheck(() -> {
            Optional<ValueEquivalence> inverseValueEquivalenceMaybe = valueEquivalence.inverseMaybe();
            Verify.verify(inverseValueEquivalenceMaybe.isPresent());
            ConstrainedBoolean otherThis = ((Value)other).semanticEqualsTyped(this, inverseValueEquivalenceMaybe.get());
            Verify.verify(thisOther.isTrue() == otherThis.isTrue());
        });
        if (thisOther.isFalse()) {
            return valueEquivalence.isDefinedEqual(this, (Value)other);
        }
        return thisOther;
    }

    @Override
    @Nonnull
    default public ConstrainedBoolean semanticEqualsTyped(@Nonnull Value other, @Nonnull ValueEquivalence valueEquivalence) {
        ConstrainedBoolean equalsWithoutChildren = this.equalsWithoutChildren(other);
        if (equalsWithoutChildren.isFalse()) {
            return ConstrainedBoolean.falseValue();
        }
        ConstrainedBoolean constraint = equalsWithoutChildren;
        Iterator children = this.getChildren().iterator();
        Iterator otherChildren = other.getChildren().iterator();
        while (children.hasNext()) {
            if (!otherChildren.hasNext()) {
                return ConstrainedBoolean.falseValue();
            }
            ConstrainedBoolean isChildEquals = ((Value)children.next()).semanticEquals(otherChildren.next(), valueEquivalence);
            if (isChildEquals.isFalse()) {
                return ConstrainedBoolean.falseValue();
            }
            constraint = constraint.composeWithOther(isChildEquals);
        }
        if (otherChildren.hasNext()) {
            return ConstrainedBoolean.falseValue();
        }
        return constraint;
    }

    @Nonnull
    default public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        if (this == other) {
            return ConstrainedBoolean.alwaysTrue();
        }
        return other.getClass() == this.getClass() ? ConstrainedBoolean.alwaysTrue() : ConstrainedBoolean.falseValue();
    }

    default public boolean canResultInType(@Nonnull Type type) {
        return false;
    }

    @Nonnull
    default public Value with(@Nonnull Type type) {
        throw new RecordCoreException("cannot promote to type", new Object[0]);
    }

    @Nonnull
    default public Optional<Value> overrideTypeMaybe(@Nonnull Type type) {
        if (this.canResultInType(type)) {
            return Optional.of(this.with(type));
        }
        return Optional.empty();
    }

    @Nonnull
    default public Value simplify(@Nonnull AbstractValueRuleSet<Value, ValueSimplificationRuleCall> ruleSet, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        return Simplification.simplify(this, evaluationContext, aliasMap, constantAliases, ruleSet).getUnconstrained();
    }

    @Nonnull
    default public Value simplify(@Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        return this.simplify(evaluationContext, aliasMap, constantAliases, DefaultValueSimplificationRuleSet.instance());
    }

    @Nonnull
    default public Value simplify(@Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull AbstractValueRuleSet<Value, ValueSimplificationRuleCall> ruleSet) {
        return Simplification.simplify(this, evaluationContext, aliasMap, constantAliases, ruleSet).getUnconstrained();
    }

    @Nonnull
    default public Map<Value, Value> pullUp(@Nonnull Iterable<? extends Value> toBePulledUpValues, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull CorrelationIdentifier upperBaseAlias) {
        NonnullPair<Constrained<Value>, Map<Value, ValueCompensation>> resultPair = Simplification.compute(this, evaluationContext, toBePulledUpValues, aliasMap, constantAliases, PullUpValueRuleSet.ofPullUpValueRules());
        if (resultPair == null) {
            return ImmutableMap.of();
        }
        Map<Value, ValueCompensation> matchedValuesMap = resultPair.getRight();
        ImmutableMap.Builder<Value, Value> resultsMapBuilder = ImmutableMap.builder();
        for (Value value : toBePulledUpValues) {
            ValueCompensation compensation = matchedValuesMap.get(value);
            if (compensation == null) continue;
            resultsMapBuilder.put(value, compensation.compensate(QuantifiedObjectValue.of(upperBaseAlias, this.getResultType())));
        }
        return resultsMapBuilder.buildKeepingLast();
    }

    @Nonnull
    default public List<Value> pushDown(@Nonnull Iterable<? extends Value> toBePushedDownValues, @Nonnull AbstractValueRuleSet<Value, ValueSimplificationRuleCall> simplificationRuleSet, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull CorrelationIdentifier upperBaseAlias) {
        return Streams.stream(toBePushedDownValues).map(toBePushedDownValue -> toBePushedDownValue.replaceLeavesMaybe(value -> {
            if (value instanceof QuantifiedObjectValue && ((QuantifiedObjectValue)value).getAlias().equals(upperBaseAlias)) {
                return this;
            }
            return value;
        })).map(valueOptional -> (Value)valueOptional.orElseThrow(() -> new RecordCoreException("unexpected empty optional", new Object[0]))).map(composedValue -> composedValue.simplify(simplificationRuleSet, evaluationContext, aliasMap, constantAliases)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    default public Optional<NonnullPair<FieldValue, Value>> extractFromIndexEntryMaybe(@Nonnull Value baseValue, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull IndexKeyValueToPartialRecord.TupleSource source, @Nonnull ImmutableIntArray ordinalPath) {
        NonnullPair<Constrained<Value>, Map<Value, ValueCompensation>> resultPair = Simplification.compute(this, evaluationContext, baseValue, aliasMap, constantAliases, ExtractFromIndexKeyValueRuleSet.ofIndexKeyToPartialRecordValueRules());
        if (resultPair == null) {
            return Optional.empty();
        }
        Map<Value, ValueCompensation> matchedValuesMap = resultPair.getRight();
        if (matchedValuesMap.size() != 1) {
            return Optional.empty();
        }
        Map.Entry<Value, ValueCompensation> matchedEntry = Iterables.getOnlyElement(matchedValuesMap.entrySet());
        Value matchedValue = matchedEntry.getKey();
        ValueCompensation matchedValueCompensation = matchedEntry.getValue();
        Verify.verify(matchedValue instanceof FieldValue);
        return Optional.of(NonnullPair.of((FieldValue)matchedValue, matchedValueCompensation.compensate(new IndexEntryObjectValue(Quantifier.current(), source, ordinalPath, this.getResultType()))));
    }

    @Nonnull
    default public <O extends OrderingPart.SortOrder, P extends OrderingPart<O>> P deriveOrderingPart(@Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull OrderingPart.OrderingPartCreator<O, P> orderingPartCreator, @Nonnull OrderingValueComputationRuleSet<O, P> ruleSet) {
        NonnullPair<Constrained<Value>, P> resultPair = Objects.requireNonNull(Simplification.compute(this, evaluationContext, orderingPartCreator, aliasMap, constantAliases, ruleSet));
        return (P)((OrderingPart)resultPair.getValue());
    }

    @Nonnull
    default public Optional<NonnullPair<ComparisonCompensation, QueryPlanConstraint>> matchAndCompensateComparisonMaybe(@Nonnull Value candidateValue, @Nonnull ValueEquivalence valueEquivalence) {
        return Optional.ofNullable(candidateValue.foldNullable(Functions.identity(), (otherCurrent, childrenResults) -> {
            if (Streams.stream(childrenResults).allMatch(Objects::isNull)) {
                ConstrainedBoolean semanticEquals = this.semanticEquals(otherCurrent, valueEquivalence);
                if (semanticEquals.isTrue()) {
                    return NonnullPair.of(ComparisonCompensation.noCompensation(), semanticEquals.getConstraint());
                }
                return null;
            }
            if (Iterables.size(childrenResults) == 1 && otherCurrent instanceof InvertableValue) {
                InvertableValue otherInvertableValue = (InvertableValue)otherCurrent;
                NonnullPair childPair = (NonnullPair)Iterables.getOnlyElement(childrenResults);
                ComparisonCompensation.NestedInvertableComparisonCompensation compensation = new ComparisonCompensation.NestedInvertableComparisonCompensation(otherInvertableValue, childPair);
                return NonnullPair.of(compensation, (QueryPlanConstraint)childPair.getRight());
            }
            return null;
        }));
    }

    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext var1);

    @Nonnull
    public static Value fromValueProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PValue valueProto) {
        return (Value)PlanSerialization.dispatchFromProtoContainer(serializationContext, valueProto);
    }

    public static List<Value> fromKeyExpressions(@Nonnull Collection<? extends KeyExpression> expressions, @Nonnull Quantifier quantifier) {
        return Value.fromKeyExpressions(expressions, quantifier.getAlias(), quantifier.getFlowedObjectType());
    }

    public static List<Value> fromKeyExpressions(@Nonnull Collection<? extends KeyExpression> expressions, @Nonnull CorrelationIdentifier alias, @Nonnull Type inputType) {
        return expressions.stream().map(keyExpression -> new ScalarTranslationVisitor((KeyExpression)keyExpression).toResultValue(alias, inputType)).collect(ImmutableList.toImmutableList());
    }

    public static ExplainTokens explainFunctionArguments(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return new ExplainTokens().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), () -> Streams.stream(explainSuppliers).map(explainSupplier -> ((ExplainTokensWithPrecedence)explainSupplier.get()).getExplainTokens()).iterator());
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static interface NondeterministicValue
    extends Value {
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static interface InvertableValue<V extends Value>
    extends Value {
        public Optional<V> createInverseValueMaybe(@Nonnull Value var1);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static interface IndexOnlyValue
    extends Value {
        @Override
        @Nullable
        default public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
            throw new RecordCoreException("value is index-only and cannot be evaluated", new Object[0]);
        }
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static interface RangeMatchableValue
    extends Value {
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static interface NonEvaluableValue
    extends Value {
        @Override
        @Nullable
        default public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
            throw new RecordCoreException("value cannot be evaluated", new Object[0]);
        }
    }
}

