/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractValueRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class Values {
    @Nonnull
    public static List<Value> deconstructRecord(@Nonnull Value recordValue) {
        Type resultType = recordValue.getResultType();
        Verify.verify(resultType.isRecord());
        Verify.verify(resultType instanceof Type.Record);
        Type.Record resultRecordType = (Type.Record)resultType;
        if (recordValue instanceof RecordConstructorValue) {
            RecordConstructorValue recordConstructorValue = (RecordConstructorValue)recordValue;
            ImmutableList<Value> children = ImmutableList.copyOf(recordConstructorValue.getChildren());
            Verify.verify(Objects.requireNonNull(resultRecordType.getFields()).size() == children.size());
            return children;
        }
        List<Type.Record.Field> fields = Objects.requireNonNull(resultRecordType.getFields());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < fields.size(); ++i) {
            resultBuilder.add(FieldValue.ofOrdinalNumberAndFuseIfPossible(recordValue, i));
        }
        return resultBuilder.build();
    }

    @Nonnull
    public static List<Value> simplify(@Nonnull Iterable<Value> values, @Nonnull AbstractValueRuleSet<Value, ValueSimplificationRuleCall> ruleSet, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        return Streams.stream(values).map(value -> value.simplify(ruleSet, evaluationContext, aliasMap, constantAliases)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static List<Value> primitiveAccessorsForType(@Nonnull Type type, @Nonnull Supplier<Value> baseValueSupplier) {
        if (type.getTypeCode() != Type.TypeCode.RECORD) {
            SemanticException.check(type.isPrimitive() || type.isEnum(), SemanticException.ErrorCode.ORDERING_IS_OF_INCOMPATIBLE_TYPE);
            return ImmutableList.of(baseValueSupplier.get());
        }
        ImmutableList.Builder orderingValuesBuilder = ImmutableList.builder();
        Type.Record recordType = (Type.Record)type;
        List<Type.Record.Field> fields = recordType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Type.Record.Field field = fields.get(i);
            FieldValue.FieldPath singleStepPath = FieldValue.FieldPath.ofSingle(FieldValue.ResolvedAccessor.of(field.getFieldNameOptional().orElse(null), i, field.getFieldType()));
            Values.primitiveAccessorsForType(field.getFieldType(), () -> FieldValue.ofFieldsAndFuseIfPossible((Value)baseValueSupplier.get(), singleStepPath)).forEach(orderingValuesBuilder::add);
        }
        return orderingValuesBuilder.build();
    }

    @Nonnull
    public static Optional<Value> collapseSimpleSelectMaybe(@Nonnull RecordConstructorValue recordConstructorValue) {
        if (Iterables.isEmpty(recordConstructorValue.getChildren()) || StreamSupport.stream(recordConstructorValue.getChildren().spliterator(), false).anyMatch(v -> !(v instanceof FieldValue))) {
            return Optional.empty();
        }
        Iterator<? extends Value> fieldValues = recordConstructorValue.getChildren().iterator();
        Value commonChildValue = null;
        int i = 0;
        while (fieldValues.hasNext()) {
            Value childValue;
            FieldValue fieldValue = (FieldValue)fieldValues.next();
            FieldValue.FieldPath fieldPath = fieldValue.getFieldPath();
            if (fieldPath.getLastFieldAccessor().getOrdinal() != i) {
                return Optional.empty();
            }
            if (fieldPath.size() > 1) {
                childValue = FieldValue.ofFields(fieldValue.getChild(), fieldPath.getFieldPrefix());
            } else {
                Verify.verify(fieldPath.size() == 1);
                childValue = fieldValue.getChild();
            }
            if (commonChildValue == null) {
                commonChildValue = childValue;
                if (!recordConstructorValue.getResultType().equals(commonChildValue.getResultType())) {
                    return Optional.empty();
                }
            } else if (!commonChildValue.equals(childValue)) {
                return Optional.empty();
            }
            ++i;
        }
        return Optional.of(Objects.requireNonNull(commonChildValue));
    }
}

