/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.planprotos.PVariadicFunctionValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class VariadicFunctionValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Variadic-Function-Value");
    @Nonnull
    private final PhysicalOperator operator;
    @Nonnull
    private final List<Value> children;
    @Nonnull
    private static final Supplier<Map<NonnullPair<ComparisonFunction, Type.TypeCode>, PhysicalOperator>> operatorMapSupplier = Suppliers.memoize(VariadicFunctionValue::computeOperatorMap);

    public VariadicFunctionValue(@Nonnull PhysicalOperator operator, @Nonnull List<Value> children) {
        this.operator = operator;
        this.children = ImmutableList.copyOf(children);
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.operator.eval(this.children.stream().map(c -> c.eval(store, context)).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.children.get(0).getResultType();
    }

    @Nonnull
    public ComparisonFunction getComparisonFunction() {
        return this.operator.getComparisonFunction();
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return this.children;
    }

    @Override
    @Nonnull
    public VariadicFunctionValue withChildren(Iterable<? extends Value> newChildren) {
        Verify.verify(Iterables.size(newChildren) >= 2);
        return new VariadicFunctionValue(this.operator, ImmutableList.copyOf(newChildren));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, new Object[]{BASE_HASH, this.operator});
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.operator, this.children});
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall(this.operator.name().toLowerCase(Locale.ROOT), Value.explainFunctionArguments(explainSuppliers)));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PVariadicFunctionValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        PVariadicFunctionValue.Builder builder = PVariadicFunctionValue.newBuilder();
        builder.setOperator(this.operator.toProto(serializationContext));
        for (Value child : this.children) {
            builder.addChildren(child.toValueProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setVariadicFunctionValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static VariadicFunctionValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PVariadicFunctionValue variadicFunctionValueProto) {
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (int i = 0; i < variadicFunctionValueProto.getChildrenCount(); ++i) {
            Value child = Value.fromValueProto(serializationContext, variadicFunctionValueProto.getChildren(i));
            childrenBuilder.add(child);
        }
        return new VariadicFunctionValue(PhysicalOperator.fromProto(serializationContext, Objects.requireNonNull(variadicFunctionValueProto.getOperator())), (List<Value>)((Object)childrenBuilder.build()));
    }

    @Nonnull
    private static Map<NonnullPair<ComparisonFunction, Type.TypeCode>, PhysicalOperator> getOperatorMap() {
        return operatorMapSupplier.get();
    }

    @Nonnull
    private static Value encapsulate(@Nonnull BuiltInFunction<Value> builtInFunction, @Nonnull List<? extends Typed> arguments) {
        Verify.verify(arguments.size() >= 2);
        Type resultType = null;
        for (Typed typed : arguments) {
            Type argType = typed.getResultType();
            Verify.verify(argType == Type.NULL || !argType.isUnresolved());
            if (resultType == null) {
                resultType = argType;
                continue;
            }
            SemanticException.check((resultType = Type.maximumType(resultType, argType)) != null, SemanticException.ErrorCode.INCOMPATIBLE_TYPE);
        }
        PhysicalOperator physicalOperator = VariadicFunctionValue.getOperatorMap().get(NonnullPair.of(((ComparisonFn)builtInFunction).getComparisonFunction(), resultType.getTypeCode()));
        SemanticException.check(physicalOperator != null, SemanticException.ErrorCode.FUNCTION_UNDEFINED_FOR_GIVEN_ARGUMENT_TYPES);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Typed typed : arguments) {
            builder.add(PromoteValue.inject((Value)typed, resultType));
        }
        return new VariadicFunctionValue(physicalOperator, (List<Value>)((Object)builder.build()));
    }

    private static Map<NonnullPair<ComparisonFunction, Type.TypeCode>, PhysicalOperator> computeOperatorMap() {
        ImmutableMap.Builder<NonnullPair<ComparisonFunction, Type.TypeCode>, PhysicalOperator> mapBuilder = ImmutableMap.builder();
        for (PhysicalOperator operator : PhysicalOperator.values()) {
            mapBuilder.put(NonnullPair.of(operator.getComparisonFunction(), operator.getResultType()), operator);
        }
        return mapBuilder.build();
    }

    @VisibleForTesting
    public static enum PhysicalOperator {
        GREATEST_INT(ComparisonFunction.GREATEST, Type.TypeCode.INT, args -> {
            int max = Integer.MIN_VALUE;
            for (Object i : args) {
                if (i == null) {
                    return null;
                }
                if ((Integer)i <= max) continue;
                max = (Integer)i;
            }
            return max;
        }),
        GREATEST_LONG(ComparisonFunction.GREATEST, Type.TypeCode.LONG, args -> {
            long max = Long.MIN_VALUE;
            for (Object l : args) {
                if (l == null) {
                    return null;
                }
                if ((Long)l <= max) continue;
                max = (Long)l;
            }
            return max;
        }),
        GREATEST_BOOLEAN(ComparisonFunction.GREATEST, Type.TypeCode.BOOLEAN, args -> {
            boolean max = false;
            for (Object b : args) {
                if (b == null) {
                    return null;
                }
                if (!((Boolean)b).booleanValue()) continue;
                max = true;
            }
            return max;
        }),
        GREATEST_STRING(ComparisonFunction.GREATEST, Type.TypeCode.STRING, args -> {
            String max = (String)args.get(0);
            for (Object s2 : args) {
                if (s2 == null) {
                    return null;
                }
                if (((String)s2).compareTo(max) <= 0) continue;
                max = (String)s2;
            }
            return max;
        }),
        GREATEST_FLOAT(ComparisonFunction.GREATEST, Type.TypeCode.FLOAT, args -> {
            float max = Float.MIN_VALUE;
            for (Object f : args) {
                if (f == null) {
                    return null;
                }
                if (!(((Float)f).floatValue() > max)) continue;
                max = ((Float)f).floatValue();
            }
            return Float.valueOf(max);
        }),
        GREATEST_DOUBLE(ComparisonFunction.GREATEST, Type.TypeCode.DOUBLE, args -> {
            double max = Double.MIN_VALUE;
            for (Object d : args) {
                if (d == null) {
                    return null;
                }
                if (!((Double)d > max)) continue;
                max = (Double)d;
            }
            return max;
        }),
        LEAST_INT(ComparisonFunction.LEAST, Type.TypeCode.INT, args -> {
            int min2 = Integer.MAX_VALUE;
            for (Object i : args) {
                if (i == null) {
                    return null;
                }
                if ((Integer)i >= min2) continue;
                min2 = (Integer)i;
            }
            return min2;
        }),
        LEAST_LONG(ComparisonFunction.LEAST, Type.TypeCode.LONG, args -> {
            long min2 = Long.MAX_VALUE;
            for (Object l : args) {
                if (l == null) {
                    return null;
                }
                if ((Long)l >= min2) continue;
                min2 = (Long)l;
            }
            return min2;
        }),
        LEAST_BOOLEAN(ComparisonFunction.LEAST, Type.TypeCode.BOOLEAN, args -> {
            boolean min2 = true;
            for (Object b : args) {
                if (b == null) {
                    return null;
                }
                if (((Boolean)b).booleanValue()) continue;
                min2 = false;
            }
            return min2;
        }),
        LEAST_STRING(ComparisonFunction.LEAST, Type.TypeCode.STRING, args -> {
            String min2 = (String)args.get(0);
            for (Object s2 : args) {
                if (s2 == null) {
                    return null;
                }
                if (((String)s2).compareTo(min2) >= 0) continue;
                min2 = (String)s2;
            }
            return min2;
        }),
        LEAST_FLOAT(ComparisonFunction.LEAST, Type.TypeCode.FLOAT, args -> {
            float min2 = Float.MAX_VALUE;
            for (Object f : args) {
                if (f == null) {
                    return null;
                }
                if (!(((Float)f).floatValue() < min2)) continue;
                min2 = ((Float)f).floatValue();
            }
            return Float.valueOf(min2);
        }),
        LEAST_DOUBLE(ComparisonFunction.LEAST, Type.TypeCode.DOUBLE, args -> {
            double min2 = Double.MAX_VALUE;
            for (Object d : args) {
                if (d == null) {
                    return null;
                }
                if (!((Double)d < min2)) continue;
                min2 = (Double)d;
            }
            return min2;
        }),
        COALESCE_INT(ComparisonFunction.COALESCE, Type.TypeCode.INT, PhysicalOperator::coalesce),
        COALESCE_LONG(ComparisonFunction.COALESCE, Type.TypeCode.LONG, PhysicalOperator::coalesce),
        COALESCE_BOOLEAN(ComparisonFunction.COALESCE, Type.TypeCode.BOOLEAN, PhysicalOperator::coalesce),
        COALESCE_STRING(ComparisonFunction.COALESCE, Type.TypeCode.STRING, PhysicalOperator::coalesce),
        COALESCE_FLOAT(ComparisonFunction.COALESCE, Type.TypeCode.FLOAT, PhysicalOperator::coalesce),
        COALESCE_DOUBLE(ComparisonFunction.COALESCE, Type.TypeCode.DOUBLE, PhysicalOperator::coalesce),
        COALESCE_RECORD(ComparisonFunction.COALESCE, Type.TypeCode.RECORD, PhysicalOperator::coalesce),
        COALESCE_ARRAY(ComparisonFunction.COALESCE, Type.TypeCode.ARRAY, PhysicalOperator::coalesce);

        @Nonnull
        private static final Supplier<BiMap<PhysicalOperator, PVariadicFunctionValue.PPhysicalOperator>> protoEnumBiMapSupplier;
        @Nonnull
        private final ComparisonFunction comparisonFunction;
        @Nonnull
        private final Type.TypeCode type;
        @Nonnull
        private final transient Function<List<Object>, Object> evaluateFunction;

        private PhysicalOperator(@Nonnull ComparisonFunction comparisonFunction, Type.TypeCode type, Function<List<Object>, Object> evaluateFunction) {
            this.comparisonFunction = comparisonFunction;
            this.type = type;
            this.evaluateFunction = evaluateFunction;
        }

        @Nonnull
        public ComparisonFunction getComparisonFunction() {
            return this.comparisonFunction;
        }

        @Nonnull
        public Type.TypeCode getResultType() {
            return this.type;
        }

        @Nullable
        public Object eval(List<Object> args) {
            return this.evaluateFunction.apply(args);
        }

        @Nonnull
        public PVariadicFunctionValue.PPhysicalOperator toProto(@Nonnull PlanSerializationContext serializationContext) {
            return Objects.requireNonNull((PVariadicFunctionValue.PPhysicalOperator)PhysicalOperator.getProtoEnumBiMap().get((Object)this));
        }

        @Nonnull
        public static PhysicalOperator fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PVariadicFunctionValue.PPhysicalOperator physicalOperatorProto) {
            return Objects.requireNonNull((PhysicalOperator)((Object)PhysicalOperator.getProtoEnumBiMap().inverse().get(physicalOperatorProto)));
        }

        @Nonnull
        private static BiMap<PhysicalOperator, PVariadicFunctionValue.PPhysicalOperator> getProtoEnumBiMap() {
            return protoEnumBiMapSupplier.get();
        }

        private static Object coalesce(List<Object> args) {
            for (Object i : args) {
                if (i == null) continue;
                return i;
            }
            return null;
        }

        static {
            protoEnumBiMapSupplier = Suppliers.memoize(() -> PlanSerialization.protoEnumBiMap(PhysicalOperator.class, PVariadicFunctionValue.PPhysicalOperator.class));
        }
    }

    public static enum ComparisonFunction {
        GREATEST,
        LEAST,
        COALESCE;

    }

    private static class ComparisonFn
    extends BuiltInFunction<Value> {
        private final ComparisonFunction comparisonFunction;

        public ComparisonFn(String name, ComparisonFunction comparisonFunction) {
            super(name, ImmutableList.of(), new Type.Any(), (BuiltInFunction<T> x$0, List<Typed> x$1) -> VariadicFunctionValue.encapsulate(x$0, x$1));
            this.comparisonFunction = comparisonFunction;
        }

        public ComparisonFunction getComparisonFunction() {
            return this.comparisonFunction;
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PVariadicFunctionValue, VariadicFunctionValue> {
        @Override
        @Nonnull
        public Class<PVariadicFunctionValue> getProtoMessageClass() {
            return PVariadicFunctionValue.class;
        }

        @Override
        @Nonnull
        public VariadicFunctionValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PVariadicFunctionValue variadicFunctionValueProto) {
            return VariadicFunctionValue.fromProto(serializationContext, variadicFunctionValueProto);
        }
    }

    public static class CoalesceFn
    extends ComparisonFn {
        public CoalesceFn() {
            super("coalesce", ComparisonFunction.COALESCE);
        }
    }

    public static class LeastFn
    extends ComparisonFn {
        public LeastFn() {
            super("least", ComparisonFunction.LEAST);
        }
    }

    public static class GreatestFn
    extends ComparisonFn {
        public GreatestFn() {
            super("greatest", ComparisonFunction.GREATEST);
        }
    }
}

