/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.planprotos.PVersionValue;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedRecordValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class VersionValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Version-Value");
    @Nonnull
    private final Value childValue;

    public VersionValue(@Nonnull Value childValue) {
        this.childValue = childValue;
    }

    @Override
    @Nullable
    public <M extends Message> Object eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        FDBQueriedRecord child = (FDBQueriedRecord)Objects.requireNonNull(this.childValue.eval(store, context));
        return child.getVersion();
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return Type.primitiveType(Type.TypeCode.VERSION);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ImmutableList.of(this.childValue);
    }

    @Override
    @Nonnull
    public VersionValue withChildren(@Nonnull Iterable<? extends Value> newChildren) {
        Value newChild = Iterables.getOnlyElement(newChildren);
        if (newChild == this.getChildQuantifiedRecordValue()) {
            return this;
        }
        if (newChild instanceof QuantifiedObjectValue) {
            QuantifiedObjectValue newChildQuantifiedObjectValue = (QuantifiedObjectValue)newChild;
            return new VersionValue(QuantifiedRecordValue.of(newChildQuantifiedObjectValue.getAlias(), newChildQuantifiedObjectValue.getResultType()));
        }
        return new VersionValue(newChild);
    }

    @Nonnull
    public QuantifiedRecordValue getChildQuantifiedRecordValue() {
        return (QuantifiedRecordValue)this.childValue;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("version", Iterables.getOnlyElement(explainSuppliers).get().getExplainTokens()));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.planHash(mode, BASE_HASH);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public PVersionValue toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PVersionValue.newBuilder().setChild(this.childValue.toValueProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValue.newBuilder().setVersionValue(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static VersionValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PVersionValue versionValueProto) {
        if (versionValueProto.hasChild()) {
            return new VersionValue(Value.fromValueProto(serializationContext, Objects.requireNonNull(versionValueProto).getChild()));
        }
        Verify.verify(versionValueProto.hasBaseAlias());
        return new VersionValue(QuantifiedRecordValue.of(CorrelationIdentifier.of(Objects.requireNonNull(versionValueProto.getBaseAlias())), new Type.AnyRecord(false)));
    }

    @Nonnull
    private static Value encapsulate(@Nonnull List<? extends Typed> arguments) {
        QuantifiedRecordValue childQuantifiedRecordValue = (QuantifiedRecordValue)Iterables.getOnlyElement(arguments);
        return new VersionValue(childQuantifiedRecordValue);
    }

    public static class VersionFn
    extends BuiltInFunction<Value> {
        public VersionFn() {
            super("version", List.of(Type.any()), (BuiltInFunction<T> ignored, List<Typed> arguments) -> VersionValue.encapsulate(arguments));
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PVersionValue, VersionValue> {
        @Override
        @Nonnull
        public Class<PVersionValue> getProtoMessageClass() {
            return PVersionValue.class;
        }

        @Override
        @Nonnull
        public VersionValue fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PVersionValue versionValueProto) {
            return VersionValue.fromProto(serializationContext, versionValueProto);
        }
    }
}

