/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PWindowedValue;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class WindowedValue
extends AbstractValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Windowed-Value");
    @Nonnull
    private final List<Value> partitioningValues;
    @Nonnull
    private final List<Value> argumentValues;

    protected WindowedValue(@Nonnull PlanSerializationContext serializationContext, @Nonnull PWindowedValue windowedValueProto) {
        this(windowedValueProto.getPartitioningValuesList().stream().map(valueProto -> Value.fromValueProto(serializationContext, valueProto)).collect(ImmutableList.toImmutableList()), windowedValueProto.getArgumentValuesList().stream().map(valueProto -> Value.fromValueProto(serializationContext, valueProto)).collect(ImmutableList.toImmutableList()));
    }

    protected WindowedValue(@Nonnull Iterable<? extends Value> partitioningValues, @Nonnull Iterable<? extends Value> argumentValues) {
        Preconditions.checkArgument(!Iterables.isEmpty(argumentValues));
        this.partitioningValues = ImmutableList.copyOf(partitioningValues);
        this.argumentValues = ImmutableList.copyOf(argumentValues);
    }

    @Nonnull
    public List<Value> getPartitioningValues() {
        return this.partitioningValues;
    }

    @Nonnull
    public List<Value> getArgumentValues() {
        return this.argumentValues;
    }

    @Override
    @Nonnull
    protected Iterable<? extends Value> computeChildren() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.partitioningValues)).addAll(this.argumentValues)).build();
    }

    @Nonnull
    protected NonnullPair<List<Value>, List<Value>> splitNewChildren(@Nonnull Iterable<? extends Value> newChildren) {
        Iterator<? extends Value> newChildrenIterator = newChildren.iterator();
        ImmutableList<? extends Value> newPartitioningValues = ImmutableList.copyOf(Iterators.limit(newChildrenIterator, this.partitioningValues.size()));
        ImmutableList<? extends Value> newArgumentValues = ImmutableList.copyOf(newChildrenIterator);
        return NonnullPair.of(newPartitioningValues, newArgumentValues);
    }

    @Nonnull
    public abstract String getName();

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, this.getName());
    }

    protected int basePlanHash(@Nonnull PlanHashable.PlanHashMode mode, ObjectPlanHash baseHash, Object ... hashables) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, baseHash, this.getName(), this.partitioningValues, this.argumentValues, hashables);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        ImmutableList.Builder partitioningBuilder = ImmutableList.builder();
        Iterator<Supplier<ExplainTokensWithPrecedence>> iterator = explainSuppliers.iterator();
        for (int i = 0; i < this.partitioningValues.size(); ++i) {
            partitioningBuilder.add(iterator.next().get().getExplainTokens());
        }
        ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
        while (iterator.hasNext()) {
            argumentsBuilder.add(iterator.next().get().getExplainTokens());
        }
        ExplainTokens allArgumentsExplainTokens = new ExplainTokens().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), argumentsBuilder.build());
        ImmutableCollection partitioning = partitioningBuilder.build();
        if (!partitioning.isEmpty()) {
            allArgumentsExplainTokens.addWhitespace().addKeyword("PARTITION").addWhitespace().addKeyword("BY").addWhitespace().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), partitioning);
        }
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall(this.getName(), allArgumentsExplainTokens));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull Value other) {
        return super.equalsWithoutChildren(other).filter(ignored -> this.getName().equals(((WindowedValue)other).getName()));
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Nonnull
    PWindowedValue toWindowedValueProto(@Nonnull PlanSerializationContext serializationContext) {
        PWindowedValue.Builder builder = PWindowedValue.newBuilder();
        for (Value partitioningValue : this.partitioningValues) {
            builder.addPartitioningValues(partitioningValue.toValueProto(serializationContext));
        }
        for (Value argumentValue : this.argumentValues) {
            builder.addArgumentValues(argumentValue.toValueProto(serializationContext));
        }
        return builder.build();
    }
}

