/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class AbstractRuleCall<RESULT, CALL extends AbstractRuleCall<RESULT, CALL, BASE>, BASE>
implements PlannerRuleCall {
    @Nonnull
    private final PlannerRule<CALL, ? extends BASE> rule;
    @Nonnull
    private final BASE root;
    @Nonnull
    private final BASE current;
    @Nonnull
    private final EvaluationContext evaluationContext;
    @Nonnull
    private final PlannerBindings bindings;
    @Nonnull
    private final AliasMap equivalenceMap;
    @Nonnull
    private final Set<CorrelationIdentifier> constantAliases;
    @Nonnull
    private QueryPlanConstraint resultQueryPlanConstraint;
    @Nonnull
    private final LinkedIdentitySet<RESULT> results;
    private boolean shouldReExplore;
    @Nonnull
    private final Function<BASE, QueryPlanConstraint> retrieveQueryPlanConstraintFunction;

    public AbstractRuleCall(@Nonnull PlannerRule<CALL, ? extends BASE> rule, @Nonnull BASE root, @Nonnull BASE current, @Nonnull EvaluationContext evaluationContext, @Nonnull PlannerBindings bindings, @Nonnull AliasMap equivalenceMap, @Nonnull Set<CorrelationIdentifier> constantAliases, @Nonnull Function<BASE, QueryPlanConstraint> retrieveQueryPlanConstraintFunction) {
        this.rule = rule;
        this.root = root;
        this.current = current;
        this.evaluationContext = evaluationContext;
        this.bindings = bindings;
        this.equivalenceMap = equivalenceMap;
        this.resultQueryPlanConstraint = QueryPlanConstraint.noConstraint();
        this.results = new LinkedIdentitySet();
        this.constantAliases = ImmutableSet.copyOf(constantAliases);
        this.shouldReExplore = false;
        this.retrieveQueryPlanConstraintFunction = retrieveQueryPlanConstraintFunction;
    }

    @Nonnull
    public BASE getRoot() {
        return this.root;
    }

    @Nonnull
    public BASE getCurrent() {
        return this.current;
    }

    @Override
    @Nonnull
    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    @Nonnull
    protected Function<BASE, QueryPlanConstraint> getRetrieveQueryPlanConstraintFunction() {
        return this.retrieveQueryPlanConstraintFunction;
    }

    @Nonnull
    public QueryPlanConstraint getQueryPlanConstraint(@Nonnull BASE base) {
        QueryPlanConstraint constraintFromFunction = this.retrieveQueryPlanConstraintFunction.apply(base);
        return constraintFromFunction == null ? QueryPlanConstraint.noConstraint() : constraintFromFunction;
    }

    public boolean isRoot() {
        return this.root == this.current;
    }

    @Nonnull
    public PlannerRule<CALL, ? extends BASE> getRule() {
        return this.rule;
    }

    @Override
    @Nonnull
    public PlannerBindings getBindings() {
        return this.bindings;
    }

    @Nonnull
    public AliasMap getEquivalenceMap() {
        return this.equivalenceMap;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getConstantAliases() {
        return this.constantAliases;
    }

    public void yieldResult(@Nonnull RESULT value) {
        this.yieldResult(value, QueryPlanConstraint.noConstraint());
    }

    public void yieldResult(@Nonnull RESULT value, @Nonnull QueryPlanConstraint additionalQueryPlanConstraint) {
        if (value == this.current) {
            return;
        }
        this.composeAdditionalConstraint(additionalQueryPlanConstraint);
        this.results.add(value);
    }

    protected void composeAdditionalConstraint(@Nonnull QueryPlanConstraint additionalQueryPlanConstraint) {
        if (this.resultQueryPlanConstraint.isConstrained()) {
            this.resultQueryPlanConstraint = this.resultQueryPlanConstraint.compose(additionalQueryPlanConstraint);
        }
    }

    public void yieldResultAndReExplore(@Nonnull RESULT value) {
        this.yieldResultAndReExplore(value, QueryPlanConstraint.noConstraint());
    }

    public void yieldResultAndReExplore(@Nonnull RESULT value, @Nonnull QueryPlanConstraint additionalQueryPlanConstraint) {
        Verify.verify(value != this.current);
        this.composeAdditionalConstraint(additionalQueryPlanConstraint);
        this.results.add(value);
        this.shouldReExplore = true;
    }

    @Nonnull
    public QueryPlanConstraint getResultQueryPlanConstraint() {
        return this.resultQueryPlanConstraint;
    }

    @Nonnull
    public Collection<RESULT> getResults() {
        return Collections.unmodifiableCollection(this.results);
    }

    public boolean shouldReExplore() {
        return this.shouldReExplore;
    }

    @Nonnull
    public YieldResultBuilder yieldResultBuilder() {
        return new YieldResultBuilder();
    }

    public final class YieldResultBuilder {
        @Nonnull
        private final List<BASE> bases = Lists.newArrayList();

        @SafeVarargs
        public final YieldResultBuilder addConstraintsFrom(BASE ... additionalBases) {
            for (Object additionalBase : additionalBases) {
                this.bases.add(additionalBase);
            }
            return this;
        }

        public YieldResultBuilder addConstraintsFrom(@Nonnull Iterable<? extends BASE> additionalBases) {
            Streams.stream(additionalBases).forEach(this.bases::add);
            return this;
        }

        public void yieldResult(@Nonnull RESULT value) {
            AbstractRuleCall.this.yieldResult(value, this.computeConstraintFromBases());
        }

        public void yieldResultAndReExplore(@Nonnull RESULT value) {
            AbstractRuleCall.this.yieldResultAndReExplore(value, this.computeConstraintFromBases());
        }

        @Nonnull
        private QueryPlanConstraint computeConstraintFromBases() {
            return this.bases.stream().map(AbstractRuleCall.this::getQueryPlanConstraint).reduce(QueryPlanConstraint::compose).orElse(QueryPlanConstraint.noConstraint());
        }
    }
}

