/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRuleCall;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class AbstractRuleSet<CALL extends PlannerRuleCall, BASE> {
    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private final Multimap<Class<?>, PlannerRule<CALL, ? extends BASE>> ruleIndex = MultimapBuilder.hashKeys().arrayListValues().build();
    @Nonnull
    private final List<PlannerRule<CALL, ? extends BASE>> alwaysRules = new ArrayList<PlannerRule<CALL, ? extends BASE>>();
    @Nonnull
    private final SetMultimap<PlannerRule<CALL, ? extends BASE>, PlannerRule<CALL, ? extends BASE>> dependsOn = MultimapBuilder.hashKeys().hashSetValues().build();
    @Nonnull
    private final LoadingCache<Class<? extends BASE>, List<PlannerRule<CALL, ? extends BASE>>> rulesCache;

    @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    protected AbstractRuleSet(@Nonnull Set<? extends PlannerRule<CALL, ? extends BASE>> rules, @Nonnull SetMultimap<? extends PlannerRule<CALL, ? extends BASE>, ? extends PlannerRule<CALL, ? extends BASE>> dependencies) {
        for (PlannerRule<CALL, BASE> rule : rules) {
            Optional<Class<?>> root = rule.getRootOperator();
            if (root.isPresent()) {
                this.ruleIndex.put(root.get(), rule);
                continue;
            }
            this.alwaysRules.add(rule);
        }
        this.dependsOn.putAll(dependencies);
        this.rulesCache = CacheBuilder.newBuilder().maximumSize(100L).build(new CacheLoader<Class<? extends BASE>, List<PlannerRule<CALL, ? extends BASE>>>(){

            @Override
            @Nonnull
            public List<PlannerRule<CALL, ? extends BASE>> load(@Nonnull Class<? extends BASE> key) {
                ImmutableCollection applicableRules = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builderWithExpectedSize(AbstractRuleSet.this.ruleIndex.size() + AbstractRuleSet.this.alwaysRules.size()).addAll((Iterable)AbstractRuleSet.this.ruleIndex.get(key))).addAll((Iterable)AbstractRuleSet.this.alwaysRules)).build();
                if (applicableRules.isEmpty()) {
                    return ImmutableList.of();
                }
                return TopologicalSort.anyTopologicalOrderPermutation(PartiallyOrderedSet.of(applicableRules, AbstractRuleSet.this.dependsOn)).orElseThrow(() -> new RecordCoreException("circular dependency among simplification rules", new Object[0]));
            }
        });
    }

    @Nonnull
    public Stream<? extends PlannerRule<CALL, ? extends BASE>> getRules(@Nonnull BASE value) {
        return this.getRules(value, r -> true);
    }

    @Nonnull
    public Stream<? extends PlannerRule<CALL, ? extends BASE>> getRules(@Nonnull BASE value, @Nonnull Predicate<PlannerRule<CALL, ? extends BASE>> rulePredicate) {
        try {
            return this.rulesCache.get(value.getClass()).stream().filter(rulePredicate);
        }
        catch (ExecutionException ee) {
            throw new RecordCoreException(ee.getCause());
        }
    }
}

