/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface ComparisonCompensation {
    public static final ComparisonCompensation NO_COMPENSATION = new ComparisonCompensation(){

        @Override
        @Nonnull
        public Value applyToValue(@Nonnull Value value) {
            return value;
        }

        @Override
        @Nonnull
        public Optional<Value> unapplyMaybe(@Nonnull Value value) {
            return Optional.of(value);
        }

        @Override
        public Optional<Comparisons.Comparison> applyToComparisonMaybe(@Nonnull Comparisons.Comparison comparison) {
            return Optional.of(comparison);
        }
    };

    @Nonnull
    public Value applyToValue(@Nonnull Value var1);

    @Nonnull
    public Optional<Value> unapplyMaybe(@Nonnull Value var1);

    public Optional<Comparisons.Comparison> applyToComparisonMaybe(@Nonnull Comparisons.Comparison var1);

    @Nonnull
    public static ComparisonCompensation noCompensation() {
        return NO_COMPENSATION;
    }

    public static class NestedInvertableComparisonCompensation
    implements ComparisonCompensation {
        @Nonnull
        private final Value.InvertableValue<?> otherCurrent;
        @Nonnull
        private final NonnullPair<ComparisonCompensation, QueryPlanConstraint> childResult;

        public NestedInvertableComparisonCompensation(@Nonnull Value.InvertableValue<?> otherCurrent, @Nonnull NonnullPair<ComparisonCompensation, QueryPlanConstraint> childResult) {
            this.otherCurrent = otherCurrent;
            this.childResult = childResult;
        }

        @Override
        @Nonnull
        public Value applyToValue(@Nonnull Value value) {
            ComparisonCompensation childCompensation = this.childResult.getLeft();
            return this.otherCurrent.withChildren(ImmutableList.of(childCompensation.applyToValue(value)));
        }

        @Override
        @Nonnull
        public Optional<Value> unapplyMaybe(@Nonnull Value value) {
            ConstrainedBoolean equalsWithoutChildren = this.otherCurrent.equalsWithoutChildren(value);
            if (equalsWithoutChildren.isTrue() && equalsWithoutChildren.getConstraint().getPredicate().isTautology()) {
                ComparisonCompensation nestedComparisonCompensation = this.childResult.getLeft();
                return nestedComparisonCompensation.unapplyMaybe((Value)Iterables.getOnlyElement(value.getChildren()));
            }
            return Optional.empty();
        }

        @Override
        public Optional<Comparisons.Comparison> applyToComparisonMaybe(@Nonnull Comparisons.Comparison comparison) {
            Verify.verify(comparison instanceof Comparisons.ValueComparison || comparison instanceof Comparisons.SimpleComparison);
            ComparisonCompensation childCompensation = this.childResult.getLeft();
            Optional<Comparisons.Comparison> compensatedChildrenComparisonOptional = childCompensation.applyToComparisonMaybe(comparison);
            return compensatedChildrenComparisonOptional.flatMap(compensatedChildrenComparison -> {
                Ordering.OrderPreservingKind orderPreservingKind = this.otherCurrent instanceof Ordering.OrderPreservingValue ? ((Ordering.OrderPreservingValue)((Object)this.otherCurrent)).getOrderPreservingKind() : Ordering.OrderPreservingKind.NOT_ORDER_PRESERVING;
                return NestedInvertableComparisonCompensation.adjustComparisonTypeMaybe(compensatedChildrenComparison.getType(), orderPreservingKind).map(adjustedComparisonType -> comparison.withType((Comparisons.Type)((Object)((Object)adjustedComparisonType))).withValue(this.otherCurrent.withChildren(ImmutableList.of(Objects.requireNonNull(comparison.getValue())))));
            });
        }

        @Nonnull
        private static Optional<Comparisons.Type> adjustComparisonTypeMaybe(@Nonnull Comparisons.Type comparisonType, @Nonnull Ordering.OrderPreservingKind orderPreservingKind) {
            if (comparisonType.isEquality()) {
                return Optional.of(comparisonType);
            }
            switch (orderPreservingKind) {
                case NOT_ORDER_PRESERVING: {
                    return Optional.empty();
                }
                case DIRECT_ORDER_PRESERVING: {
                    switch (comparisonType) {
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUALS: 
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUALS: {
                            return Optional.of(comparisonType);
                        }
                    }
                    return Optional.empty();
                }
                case INVERSE_ORDER_PRESERVING: {
                    switch (comparisonType) {
                        case LESS_THAN: {
                            return Optional.of(Comparisons.Type.GREATER_THAN);
                        }
                        case LESS_THAN_OR_EQUALS: {
                            return Optional.of(Comparisons.Type.GREATER_THAN_OR_EQUALS);
                        }
                        case GREATER_THAN: {
                            return Optional.of(Comparisons.Type.LESS_THAN);
                        }
                        case GREATER_THAN_OR_EQUALS: {
                            return Optional.of(Comparisons.Type.LESS_THAN_OR_EQUALS);
                        }
                    }
                    return Optional.empty();
                }
            }
            throw new RecordCoreException("unknown order preserving enum", new Object[0]);
        }
    }
}

