/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.FieldValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class CompensateRecordConstructorRule
extends ValueComputationRule<Iterable<? extends Value>, Map<Value, ValueCompensation>, RecordConstructorValue> {
    @Nonnull
    private static final BindingMatcher<RecordConstructorValue> rootMatcher = ValueMatchers.recordConstructorValue(MultiMatcher.all(ValueMatchers.anyValue()));

    public CompensateRecordConstructorRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<Iterable<? extends Value>, Map<Value, ValueCompensation>> call) {
        ValueCompensation matchedCompensation;
        PlannerBindings bindings = call.getBindings();
        RecordConstructorValue recordConstructorValue = bindings.get(rootMatcher);
        LinkedIdentityMap<Value, ValueCompensation> resultingMatchedValuesMap = new LinkedIdentityMap<Value, ValueCompensation>();
        NonnullPair<Value, Map<Value, ValueCompensation>> recordConstructorValueResult = call.getResult(recordConstructorValue);
        ValueCompensation valueCompensation = matchedCompensation = recordConstructorValueResult == null ? null : (ValueCompensation)((Map)recordConstructorValueResult.getValue()).get(recordConstructorValue);
        if (matchedCompensation != null) {
            resultingMatchedValuesMap.put(recordConstructorValue, matchedCompensation);
        } else {
            for (int i = 0; i < recordConstructorValue.getColumns().size(); ++i) {
                Column<? extends Value> column = recordConstructorValue.getColumns().get(i);
                NonnullPair<Value, Map<Value, ValueCompensation>> childResultPair = call.getResult(column.getValue());
                if (childResultPair == null) continue;
                for (Map.Entry<Value, ValueCompensation> childValueEntry : childResultPair.getRight().entrySet()) {
                    Value argumentValue = childValueEntry.getKey();
                    ValueCompensation argumentValueCompensation = childValueEntry.getValue();
                    Type.Record.Field field = column.getField();
                    resultingMatchedValuesMap.putIfAbsent(argumentValue, new FieldValueCompensation(FieldValue.FieldPath.ofSingle(field.getFieldNameOptional().orElse(null), field.getFieldType(), i), argumentValueCompensation));
                }
            }
        }
        call.yieldValue(recordConstructorValue, resultingMatchedValuesMap);
    }
}

