/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.ToOrderedBytesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class CompensateToOrderedBytesValueRule
extends ValueComputationRule<Value, Map<Value, ValueCompensation>, ToOrderedBytesValue> {
    @Nonnull
    private static final BindingMatcher<Value> childFieldMatcher = ValueMatchers.anyValue();
    @Nonnull
    private static final BindingMatcher<ToOrderedBytesValue> rootMatcher = ValueMatchers.toOrderedBytesValue(childFieldMatcher);

    public CompensateToOrderedBytesValueRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.of(ToOrderedBytesValue.class);
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<Value, Map<Value, ValueCompensation>> call) {
        Map<Value, ValueCompensation> childMatchedValuesMap;
        Map<Value, ValueCompensation> matchedValuesMap;
        PlannerBindings bindings = call.getBindings();
        ToOrderedBytesValue rootValue = bindings.get(rootMatcher);
        Value childValue = bindings.get(childFieldMatcher);
        NonnullPair<Value, Map<Value, ValueCompensation>> resultPair = call.getResult(rootValue);
        Map<Value, ValueCompensation> map = matchedValuesMap = resultPair == null ? null : resultPair.getRight();
        if (matchedValuesMap != null && !matchedValuesMap.isEmpty()) {
            return;
        }
        NonnullPair<Value, Map<Value, ValueCompensation>> childResultPair = call.getResult(childValue);
        Map<Value, ValueCompensation> map2 = childMatchedValuesMap = childResultPair == null ? null : childResultPair.getRight();
        if (childMatchedValuesMap == null || childMatchedValuesMap.size() != 1) {
            return;
        }
        Map.Entry<Value, ValueCompensation> childEntry = Iterables.getOnlyElement(childMatchedValuesMap.entrySet());
        LinkedIdentityMap<Value, ValueCompensation> newMatchedValuesMap = new LinkedIdentityMap<Value, ValueCompensation>();
        Value matchedValue = childEntry.getKey();
        ValueCompensation matchedValueCompensation = childEntry.getValue();
        newMatchedValuesMap.put(matchedValue, value -> matchedValueCompensation.compensate(rootValue.createInverseValueMaybe(value).orElseThrow(() -> new RecordCoreException("method is not implemented", new Object[0]))));
        call.yieldValue(rootValue, newMatchedValuesMap);
    }
}

