/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.base.Verify;
import java.util.Collection;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ComposeFieldValueOverFieldValueRule
extends ValueSimplificationRule<FieldValue> {
    @Nonnull
    private static final BindingMatcher<Value> innerChildMatcher = ValueMatchers.anyValue();
    @Nonnull
    private static final CollectionMatcher<Integer> innerFieldPathOrdinalsMatcher = MultiMatcher.all(PrimitiveMatchers.anyObject());
    @Nonnull
    private static final CollectionMatcher<Type> innerFieldPathTypesMatcher = MultiMatcher.all(PrimitiveMatchers.anyObject());
    @Nonnull
    private static final BindingMatcher<FieldValue> innerFieldValueMatcher = ValueMatchers.fieldValueWithFieldPath(innerChildMatcher, innerFieldPathOrdinalsMatcher, innerFieldPathTypesMatcher);
    @Nonnull
    private static final CollectionMatcher<Integer> outerFieldPathOrdinalsMatcher = MultiMatcher.all(PrimitiveMatchers.anyObject());
    @Nonnull
    private static final CollectionMatcher<Type> outerFieldPathTypesMatcher = MultiMatcher.all(PrimitiveMatchers.anyObject());
    @Nonnull
    private static final BindingMatcher<FieldValue> rootMatcher = ValueMatchers.fieldValueWithFieldPath(innerFieldValueMatcher, outerFieldPathOrdinalsMatcher, outerFieldPathTypesMatcher);

    public ComposeFieldValueOverFieldValueRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Value grandChild = bindings.get(innerChildMatcher);
        Collection innerFieldPathOrdinals = (Collection)((Object)bindings.get(innerFieldPathOrdinalsMatcher));
        Collection innerFieldPathTypes = (Collection)((Object)bindings.get(innerFieldPathTypesMatcher));
        Verify.verify(!innerFieldPathOrdinals.isEmpty());
        Verify.verify(!innerFieldPathTypes.isEmpty());
        FieldValue outer = bindings.get(rootMatcher);
        Value child = outer.getChild();
        Collection outerFieldPathOrdinals = (Collection)((Object)bindings.get(outerFieldPathOrdinalsMatcher));
        Collection outerFieldPathTypes = (Collection)((Object)bindings.get(outerFieldPathTypesMatcher));
        Verify.verify(child instanceof FieldValue);
        Verify.verify(!outerFieldPathOrdinals.isEmpty());
        Verify.verify(!outerFieldPathTypes.isEmpty());
        call.yieldResultBuilder().addConstraintsFrom(outer, child).yieldResult(FieldValue.ofFields(grandChild, ((FieldValue)child).getFieldPath().withSuffix(outer.getFieldPath())));
    }
}

