/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ComposeFieldValueOverRecordConstructorRule
extends ValueSimplificationRule<FieldValue> {
    @Nonnull
    private static final BindingMatcher<RecordConstructorValue> recordConstructorMatcher = ValueMatchers.recordConstructorValue(MultiMatcher.all(ValueMatchers.anyValue()));
    @Nonnull
    private static final CollectionMatcher<Integer> fieldPathOrdinalsMatcher = MultiMatcher.all(PrimitiveMatchers.anyObject());
    @Nonnull
    private static final CollectionMatcher<Type> fieldPathTypesMatcher = MultiMatcher.all(PrimitiveMatchers.anyObject());
    @Nonnull
    private static final BindingMatcher<FieldValue> rootMatcher = ValueMatchers.fieldValueWithFieldPath(recordConstructorMatcher, fieldPathOrdinalsMatcher, fieldPathTypesMatcher);

    public ComposeFieldValueOverRecordConstructorRule() {
        super(rootMatcher);
    }

    @Override
    @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Collection fieldPathOrdinals = (Collection)((Object)bindings.get(fieldPathOrdinalsMatcher));
        Verify.verify(!fieldPathOrdinals.isEmpty());
        Collection fieldPathTypes = (Collection)((Object)bindings.get(fieldPathTypesMatcher));
        Verify.verify(!fieldPathTypes.isEmpty());
        RecordConstructorValue recordConstructor = bindings.get(recordConstructorMatcher);
        Integer firstFieldOrdinal = Objects.requireNonNull(Iterables.getFirst(fieldPathOrdinals, null));
        Type fieldFieldType = Objects.requireNonNull(Iterables.getFirst(fieldPathTypes, null));
        Column<? extends Value> column = ComposeFieldValueOverRecordConstructorRule.findColumn(recordConstructor, firstFieldOrdinal, fieldFieldType);
        FieldValue root = bindings.get(rootMatcher);
        AbstractRuleCall.YieldResultBuilder yieldResultBuilder = call.yieldResultBuilder().addConstraintsFrom(root, recordConstructor);
        if (fieldPathOrdinals.size() == 1) {
            yieldResultBuilder.yieldResult(column.getValue());
        } else {
            yieldResultBuilder.yieldResult(FieldValue.ofFields(column.getValue(), root.getFieldPath().subList(1)));
        }
    }

    @Nonnull
    private static Column<? extends Value> findColumn(@Nonnull RecordConstructorValue recordConstructorValue, int fieldOrdinal, @Nonnull Type fieldType) {
        Column<? extends Value> result = recordConstructorValue.getColumns().get(fieldOrdinal);
        Verify.verify(result.getField().getFieldType().equals(fieldType));
        return result;
    }
}

