/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.ToOrderedBytesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.tuple.TupleOrdering;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ComputeToOrderedBytesValueRule<O extends OrderingPart.SortOrder, P extends OrderingPart<O>>
extends ValueComputationRule<OrderingPart.OrderingPartCreator<O, P>, P, ToOrderedBytesValue> {
    @Nonnull
    private static final CollectionMatcher<Value> childrenMatcher = MultiMatcher.all(ValueMatchers.anyValue());
    @Nonnull
    private static final BindingMatcher<ToOrderedBytesValue> rootMatcher = ValueMatchers.toOrderedBytesValue(childrenMatcher);
    @Nonnull
    private final Function<TupleOrdering.Direction, O> directionToSortOrderFunction;

    public ComputeToOrderedBytesValueRule(@Nonnull Function<TupleOrdering.Direction, O> directionToSortOrderFunction) {
        super(rootMatcher);
        this.directionToSortOrderFunction = directionToSortOrderFunction;
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<OrderingPart.OrderingPartCreator<O, P>, P> call) {
        PlannerBindings bindings = call.getBindings();
        ToOrderedBytesValue toOrderedBytesValue = bindings.get(rootMatcher);
        Collection childrenCollection = (Collection)((Object)bindings.get(childrenMatcher));
        Value onlyChild = (Value)Iterables.getOnlyElement(childrenCollection);
        OrderingPart.OrderingPartCreator<OrderingPart.SortOrder, P> orderingPartCreator = Objects.requireNonNull(call.getArgument());
        call.yieldValue(toOrderedBytesValue, orderingPartCreator.create(onlyChild, (OrderingPart.SortOrder)this.directionToSortOrderFunction.apply(toOrderedBytesValue.getDirection())));
    }
}

