/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class DefaultOrderingPartRule<O extends OrderingPart.SortOrder, P extends OrderingPart<O>>
extends ValueComputationRule<OrderingPart.OrderingPartCreator<O, P>, P, Value> {
    @Nonnull
    private static final BindingMatcher<Value> rootMatcher = ValueMatchers.anyValue();
    @Nonnull
    private final O sortOrder;

    public DefaultOrderingPartRule(@Nonnull O sortOrder) {
        super(rootMatcher);
        this.sortOrder = sortOrder;
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<OrderingPart.OrderingPartCreator<O, P>, P> call) {
        PlannerBindings bindings = call.getBindings();
        Value value = bindings.get(rootMatcher);
        OrderingPart.OrderingPartCreator<O, P> orderingPartCreator = Objects.requireNonNull(call.getArgument());
        NonnullPair<Value, P> result = call.getResult(value);
        if (result == null) {
            call.yieldValue(value, orderingPartCreator.create(value, this.sortOrder));
        }
    }
}

