/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NullValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.base.Verify;
import javax.annotation.Nonnull;

public class DereferenceConstantObjectValueRule
extends ValueSimplificationRule<ConstantObjectValue> {
    @Nonnull
    private static final BindingMatcher<ConstantObjectValue> rootMatcher = ValueMatchers.anyConstantObjectValue();

    public DereferenceConstantObjectValueRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        ConstantObjectValue constantObjectValue = call.getBindings().get(rootMatcher);
        EvaluationContext evaluationContext = call.getEvaluationContext();
        if (!evaluationContext.containsConstantBinding(constantObjectValue.getAlias(), constantObjectValue.getConstantId())) {
            return;
        }
        Object plainValue = constantObjectValue.evalWithoutStore(evaluationContext);
        if (plainValue == null) {
            Verify.verify(constantObjectValue.getResultType().isNullable());
            call.yieldResult(new NullValue(constantObjectValue.getResultType()));
            return;
        }
        Type nonNullType = constantObjectValue.getResultType().withNullability(false);
        if (constantObjectValue.getResultType().getTypeCode() == Type.TypeCode.BOOLEAN) {
            Verify.verify(plainValue instanceof Boolean);
            Value result = LiteralValue.ofScalar(plainValue).with(nonNullType);
            call.yieldResult(result);
            return;
        }
        constantObjectValue.overrideTypeMaybe(nonNullType).ifPresent(call::yieldResult);
    }
}

