/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.ArithmeticValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.AbstractRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class EliminateArithmeticValueWithConstantRule
extends ValueSimplificationRule<ArithmeticValue> {
    @Nonnull
    private static final CollectionMatcher<Value> childrenMatcher = MultiMatcher.all(ValueMatchers.anyValue());
    @Nonnull
    private static final BindingMatcher<ArithmeticValue> rootMatcher = ValueMatchers.arithmeticValue(childrenMatcher);

    public EliminateArithmeticValueWithConstantRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        ArithmeticValue arithmeticValue = bindings.get(rootMatcher);
        if (!call.isRoot()) {
            return;
        }
        switch (arithmeticValue.getLogicalOperator()) {
            case ADD: 
            case SUB: {
                break;
            }
            default: {
                return;
            }
        }
        Collection childrenCollection = (Collection)((Object)bindings.get(childrenMatcher));
        if (childrenCollection.size() != 2) {
            return;
        }
        ImmutableList children = ImmutableList.copyOf(childrenCollection);
        Set<CorrelationIdentifier> constantAliases = call.getConstantAliases();
        if (constantAliases.containsAll(arithmeticValue.getCorrelatedTo())) {
            return;
        }
        AbstractRuleCall.YieldResultBuilder yieldBuilder = call.yieldResultBuilder();
        if (constantAliases.containsAll(((Value)children.get(0)).getCorrelatedTo())) {
            yieldBuilder.addConstraintsFrom(arithmeticValue, (Value)children.get(0)).yieldResult((Value)children.get(1));
        } else if (constantAliases.containsAll(((Value)children.get(1)).getCorrelatedTo())) {
            yieldBuilder.addConstraintsFrom(arithmeticValue, (Value)children.get(1)).yieldResult((Value)children.get(0));
        }
    }
}

