/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NullValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.VariadicFunctionValue;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

public class EvaluateConstantCoalesceRule
extends ValueSimplificationRule<VariadicFunctionValue> {
    @Nonnull
    private static final BindingMatcher<VariadicFunctionValue> rootMatcher = ValueMatchers.coalesceFunction();

    public EvaluateConstantCoalesceRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        VariadicFunctionValue variadicFunctionValue = call.getBindings().get(rootMatcher);
        ImmutableList.Builder newChildrenBuilder = ImmutableList.builder();
        boolean yieldsNewCoalesce = false;
        boolean removeRedundantNulls = false;
        boolean seenOnlyConstantsSoFar = true;
        boolean onlyNulls = true;
        for (Value value : variadicFunctionValue.getChildren()) {
            if (EvaluateConstantCoalesceRule.cannotFold(value)) {
                onlyNulls = false;
                removeRedundantNulls = true;
                seenOnlyConstantsSoFar = false;
            } else if (value instanceof NullValue) {
                if (removeRedundantNulls) {
                    yieldsNewCoalesce = true;
                    continue;
                }
            } else {
                onlyNulls = false;
                if (seenOnlyConstantsSoFar) {
                    call.yieldResult(value);
                    return;
                }
            }
            newChildrenBuilder.add(value);
        }
        if (onlyNulls) {
            call.yieldResult(new NullValue(variadicFunctionValue.getResultType()));
            return;
        }
        if (!yieldsNewCoalesce) {
            return;
        }
        ImmutableCollection newChildren = newChildrenBuilder.build();
        Verify.verify(!newChildren.isEmpty());
        if (newChildren.size() == 1) {
            call.yieldResult((Value)newChildren.get(0));
        } else {
            call.yieldResult(variadicFunctionValue.withChildren((Iterable)newChildren));
        }
    }

    private static boolean cannotFold(@Nonnull Value value) {
        return !(value instanceof NullValue) && (!value.getResultType().isNotNullable() || !(value instanceof LiteralValue));
    }
}

