/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.NullValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.base.Verify;
import javax.annotation.Nonnull;

public class EvaluateConstantPromotionRule
extends ValueSimplificationRule<PromoteValue> {
    @Nonnull
    private static final BindingMatcher<PromoteValue> rootMatcher = ValueMatchers.anyPromoteValue();

    public EvaluateConstantPromotionRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        PromoteValue promoteValue = call.getBindings().get(rootMatcher);
        Value childValue = promoteValue.getChild();
        if (childValue instanceof NullValue) {
            call.yieldResult(childValue.with(promoteValue.getResultType()));
            return;
        }
        if (childValue.getResultType().nullable().equals(promoteValue.getResultType().nullable())) {
            Verify.verify(childValue.getResultType().isNullable() != promoteValue.getResultType().isNullable());
            if (childValue.getResultType().isNotNullable()) {
                call.yieldResult(childValue);
            } else {
                childValue.overrideTypeMaybe(promoteValue.getResultType()).ifPresent(call::yieldResult);
            }
        }
    }
}

