/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ExpandFusedFieldValueRule
extends ValueSimplificationRule<FieldValue> {
    @Nonnull
    private static final BindingMatcher<FieldValue> rootMatcher = ValueMatchers.anyFieldValue();

    public ExpandFusedFieldValueRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        Verify.verify(call.isRoot());
        PlannerBindings bindings = call.getBindings();
        FieldValue fieldValue = bindings.get(rootMatcher);
        FieldValue.FieldPath fieldPath = fieldValue.getFieldPath();
        if (fieldPath.size() < 2) {
            return;
        }
        FieldValue.ResolvedAccessor lastAccessor = fieldPath.getLastFieldAccessor();
        FieldValue expandedFieldValue = FieldValue.ofFields(FieldValue.ofFields(fieldValue.getChild(), fieldPath.getFieldPrefix()), new FieldValue.FieldPath(ImmutableList.of(lastAccessor)));
        call.yieldResultBuilder().addConstraintsFrom(fieldValue).yieldResultAndReExplore(expandedFieldValue);
    }
}

