/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.NotMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ExpandRecordRule
extends ValueSimplificationRule<Value> {
    @Nonnull
    private static final BindingMatcher<Value> rootMatcher = ValueMatchers.anyValue().where(NotMatcher.not(ValueMatchers.recordConstructorValue(MultiMatcher.all(ValueMatchers.anyValue()))));

    public ExpandRecordRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        Verify.verify(call.isRoot());
        PlannerBindings bindings = call.getBindings();
        Value value = bindings.get(rootMatcher);
        if (value instanceof FieldValue && ((FieldValue)value).getFieldPath().size() > 1) {
            return;
        }
        Type originalResultType = value.getResultType();
        if (!originalResultType.isRecord()) {
            return;
        }
        Verify.verify(originalResultType instanceof Type.Record);
        Type.Record resultRecordType = (Type.Record)originalResultType;
        List<Type.Record.Field> fields = Objects.requireNonNull(resultRecordType.getFields());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < fields.size(); ++i) {
            Type.Record.Field field = fields.get(i);
            resultBuilder.add(Column.of(field, FieldValue.ofOrdinalNumberAndFuseIfPossible(value, i)));
        }
        RecordConstructorValue resultValue = RecordConstructorValue.ofColumns(resultBuilder.build(), originalResultType.isNullable());
        Verify.verify(originalResultType.isNullable() == resultValue.getResultType().isNullable());
        call.yieldResultBuilder().addConstraintsFrom(value).yieldResultAndReExplore(resultValue);
    }
}

