/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import javax.annotation.Nonnull;

public class FieldValueCompensation
implements ValueCompensation {
    @Nonnull
    private final FieldValue.FieldPath fieldPath;
    @Nonnull
    private final ValueCompensation downstreamCompensation;

    public FieldValueCompensation(@Nonnull FieldValue.FieldPath fieldPath) {
        this(fieldPath, ValueCompensation.noCompensation());
    }

    public FieldValueCompensation(@Nonnull FieldValue.FieldPath fieldPath, @Nonnull ValueCompensation downstreamCompensation) {
        this.fieldPath = fieldPath;
        this.downstreamCompensation = downstreamCompensation;
    }

    @Nonnull
    public FieldValue.FieldPath getFieldPath() {
        return this.fieldPath;
    }

    @Override
    @Nonnull
    public Value compensate(@Nonnull Value value) {
        return this.downstreamCompensation.compensate(FieldValue.ofFieldsAndFuseIfPossible(value, this.fieldPath));
    }

    public ValueCompensation withSuffix(@Nonnull FieldValue.FieldPath suffixFieldPath) {
        if (suffixFieldPath.isEmpty()) {
            return this.downstreamCompensation;
        }
        return new FieldValueCompensation(suffixFieldPath, this.downstreamCompensation);
    }
}

