/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class FoldConstantRule
extends ValueSimplificationRule<Value> {
    @Nonnull
    private static final BindingMatcher<Value> rootMatcher = ValueMatchers.anyValue();

    public FoldConstantRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        Value root = bindings.get(rootMatcher);
        if (root instanceof ConstantValue) {
            return;
        }
        Set<CorrelationIdentifier> constantAliases = call.getConstantAliases();
        if (constantAliases.containsAll(root.getCorrelatedTo())) {
            ImmutableList.Builder newChildren = ImmutableList.builder();
            for (Value child : root.getChildren()) {
                if (child instanceof ConstantValue) {
                    newChildren.add(((ConstantValue)child).getValue());
                    continue;
                }
                newChildren.add(child);
            }
            call.yieldResultBuilder().addConstraintsFrom(root).addConstraintsFrom(root.getChildren()).yieldResult(new ConstantValue((Value)root.withChildren(newChildren.build())));
        }
    }
}

