/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueSimplificationRuleCall;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LiftConstructorRule
extends ValueSimplificationRule<RecordConstructorValue> {
    @Nonnull
    private static final BindingMatcher<RecordConstructorValue> innerRecordMatcher = ValueMatchers.recordConstructorValue(MultiMatcher.all(ValueMatchers.anyValue()));
    @Nonnull
    private static final BindingMatcher<RecordConstructorValue> rootMatcher = ValueMatchers.recordConstructorValue(AnyMatcher.any(innerRecordMatcher));

    public LiftConstructorRule() {
        super(rootMatcher);
    }

    @Override
    public void onMatch(@Nonnull ValueSimplificationRuleCall call) {
        PlannerBindings bindings = call.getBindings();
        RecordConstructorValue outerRecordConstructorValue = bindings.get(rootMatcher);
        RecordConstructorValue innerRecordConstructorValue = bindings.get(innerRecordMatcher);
        if (!call.isRoot()) {
            return;
        }
        List<Column<? extends Value>> outerColumns = outerRecordConstructorValue.getColumns();
        List<Column<? extends Value>> innerColumns = innerRecordConstructorValue.getColumns();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (Column<? extends Value> column : outerColumns) {
            if (column.getValue() == innerRecordConstructorValue) {
                innerColumns.forEach(innerColumn -> columnsBuilder.add(Column.unnamedOf(innerColumn.getValue())));
                continue;
            }
            columnsBuilder.add(Column.unnamedOf(column.getValue()));
        }
        call.yieldResultBuilder().addConstraintsFrom(outerRecordConstructorValue, innerRecordConstructorValue).yieldResult(RecordConstructorValue.ofColumns(columnsBuilder.build()));
    }
}

