/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.values.simplification;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ValueMatchers;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRule;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ValueComputationRuleCall;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MatchConstantValueRule
extends ValueComputationRule<Iterable<? extends Value>, Map<Value, ValueCompensation>, Value> {
    @Nonnull
    private static final BindingMatcher<Value> rootMatcher = ValueMatchers.anyValue();

    public MatchConstantValueRule() {
        super(rootMatcher);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.empty();
    }

    @Override
    public void onMatch(@Nonnull ValueComputationRuleCall<Iterable<? extends Value>, Map<Value, ValueCompensation>> call) {
        Map<Value, ValueCompensation> matchedValuesMap;
        if (!call.isRoot()) {
            return;
        }
        PlannerBindings bindings = call.getBindings();
        Value value = bindings.get(rootMatcher);
        Iterable<? extends Value> toBePulledUpValues = Objects.requireNonNull(call.getArgument());
        LinkedIdentityMap<Value, ValueCompensation> newMatchedValuesMap = new LinkedIdentityMap<Value, ValueCompensation>();
        NonnullPair<Value, Map<Value, ValueCompensation>> resultPair = call.getResult(value);
        Map<Value, ValueCompensation> map = matchedValuesMap = resultPair == null ? null : resultPair.getRight();
        if (matchedValuesMap != null) {
            newMatchedValuesMap.putAll(matchedValuesMap);
        }
        Set<CorrelationIdentifier> constantAliases = call.getConstantAliases();
        for (Value value2 : toBePulledUpValues) {
            Set<CorrelationIdentifier> correlatedTo = value2.getCorrelatedTo();
            if (value2.preOrderStream().anyMatch(v -> v instanceof AggregateValue || v instanceof QueriedValue) || !constantAliases.containsAll(correlatedTo)) continue;
            newMatchedValuesMap.put(value2, ignored -> toBePulledUpValue);
        }
        call.yieldValue(value, newMatchedValuesMap);
    }
}

